<!DOCTYPE html>
<html lang="en" data-x="html" data-x-toggle="html-overflow-hidden">
<head>
  <!-- Required meta tags -->
  <meta charset="UTF-8">
  <meta name="viewport" content="width=device-width, initial-scale=1">

  <!-- Google fonts -->
  <link rel="preconnect" href="https://fonts.googleapis.com/">
  <link rel="preconnect" href="https://fonts.gstatic.com/" crossorigin>
  <link href="https://fonts.googleapis.com/css2?family=DM+Sans:ital,wght@0,400;0,500;0,700;1,400;1,500;1,700&amp;display=swap" rel="stylesheet">

  <!-- Stylesheets -->
  <link rel="stylesheet" href="/css/vendors.css">
  <link rel="stylesheet" href="/css/main.css">

  <title>Blog Morocco Marrakech Tours</title>
</head>

<body>
    <?php echo $__env->make('layouts.header2', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
    <section data-anim="fade" class="hero -type-1 -min-2">
      <div class="hero__bg">
        <img src="/img/hero/1.png" alt="image">
        <img src="/img/hero/1/shape.svg" alt="image">
      </div>

      <div class="container">
        <div class="row justify-center">
          <div class="col-xl-12">
            <div class="hero__content">
              <h1 class="hero__title">
                Your guide to everywhere
              </h1>

              <p class="hero__text">
                Find inspiration, guides and stories for wherever you're going Select a destination
              </p>
            </div>
          </div>
        </div>
      </div>
    </section>

    <section class="layout-pt-md layout-pb-xl">
      <div class="container">
        <div class="tabs -pills-3 pt-30 js-tabs">
          <div class="tabs__controls row x-gap-10 y-gap-10 justify-center js-tabs-controls">

            <div class="col-auto">
              <button class="tabs__button fw-500 rounded-200 js-tabs-button is-tab-el-active" data-tab-target=".-tab-item-1">All Guide</button>
            </div>

            <div class="col-auto">
              <button class="tabs__button fw-500 rounded-200 js-tabs-button " data-tab-target=".-tab-item-2">Africa</button>
            </div>

            <div class="col-auto">
              <button class="tabs__button fw-500 rounded-200 js-tabs-button " data-tab-target=".-tab-item-3">Asia</button>
            </div>

            <div class="col-auto">
              <button class="tabs__button fw-500 rounded-200 js-tabs-button " data-tab-target=".-tab-item-4">Europe</button>
            </div>

            <div class="col-auto">
              <button class="tabs__button fw-500 rounded-200 js-tabs-button " data-tab-target=".-tab-item-5">North America</button>
            </div>

            <div class="col-auto">
              <button class="tabs__button fw-500 rounded-200 js-tabs-button " data-tab-target=".-tab-item-6">Oceania</button>
            </div>

            <div class="col-auto">
              <button class="tabs__button fw-500 rounded-200 js-tabs-button " data-tab-target=".-tab-item-7">South America Guide</button>
            </div>

          </div>

          <div class="tabs__content pt-30 js-tabs-content">

            <div class="tabs__pane -tab-item-1 is-tab-el-active">
              <div class="row y-gap-30">
              <?php if(!empty($articles)): ?>
					      <?php $__currentLoopData = $articles; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $article): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                <div class="col-lg-4 col-md-6">
                  <a href="/blog/<?php echo e($article->id); ?>-<?php echo str_replace(' ', '-', $article->title); ?>" class="blogCard -type-1">
                    <div class="blogCard__image ratio ratio-41:30">
                    <?php
                      // Get the file path and extension
                      $imagePath = $article->image; // Assuming the image path is stored in the file_path attribute
                      $extension = pathinfo($imagePath, PATHINFO_EXTENSION);
                      
                      // Add text before the extension
                      $modifiedImagePath = preg_replace('/\.' . $extension . '$/', '-cropped.' . $extension, $imagePath);
                    ?>
                      <img src="<?php echo e(asset('/storage/' . $modifiedImagePath)); ?>" decoding="async" alt="<?php echo e($article->name); ?>" title="<?php echo e($article->name); ?>" class="img-ratio rounded-12">

                      <div class="blogCard__badge">Trips</div>
                    </div>

                    <div class="blogCard__content mt-30">
                      <div class="blogCard__info text-14">
                        <?php
                            $originalDate = \Carbon\Carbon::parse($article->created_at);
                        ?>
                        <div class="lh-13"><?php echo e($originalDate->format('F d Y')); ?></div>
                        <div class="blogCard__line"></div>
                      </div>

                      <h3 class="blogCard__title text-18 fw-500 mt-10"><?php echo e($article->title); ?></h3>
                    </div>
                  </a>
                </div>
                  <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                <?php endif; ?>

                <div class="col-lg-4 col-md-6">
                  <a href="#" class="blogCard -type-1">
                    <div class="blogCard__image ratio ratio-41:30">
                      <img src="img/blogCards/1/2.png" alt="image" class="img-ratio rounded-12">

                      <div class="blogCard__badge">Trips</div>
                    </div>

                    <div class="blogCard__content mt-30">
                      <div class="blogCard__info text-14">
                        <div class="lh-13">April 06 2023</div>
                        <div class="blogCard__line"></div>
                        <div class="lh-13">By Ali Tufan</div>
                      </div>

                      <h3 class="blogCard__title text-18 fw-500 mt-10">Kenya vs Tanzania Safari: The Better African Safari Experience</h3>
                    </div>
                  </a>
                </div>

                <div class="col-lg-4 col-md-6">
                  <a href="#" class="blogCard -type-1">
                    <div class="blogCard__image ratio ratio-41:30">
                      <img src="img/blogCards/1/3.png" alt="image" class="img-ratio rounded-12">

                      <div class="blogCard__badge">Trips</div>
                    </div>

                    <div class="blogCard__content mt-30">
                      <div class="blogCard__info text-14">
                        <div class="lh-13">April 06 2023</div>
                        <div class="blogCard__line"></div>
                        <div class="lh-13">By Ali Tufan</div>
                      </div>

                      <h3 class="blogCard__title text-18 fw-500 mt-10">Kenya vs Tanzania Safari: The Better African Safari Experience</h3>
                    </div>
                  </a>
                </div>

                <div class="col-lg-4 col-md-6">
                  <a href="#" class="blogCard -type-1">
                    <div class="blogCard__image ratio ratio-41:30">
                      <img src="img/blogCards/1/4.png" alt="image" class="img-ratio rounded-12">

                      <div class="blogCard__badge">Trips</div>
                    </div>

                    <div class="blogCard__content mt-30">
                      <div class="blogCard__info text-14">
                        <div class="lh-13">April 06 2023</div>
                        <div class="blogCard__line"></div>
                        <div class="lh-13">By Ali Tufan</div>
                      </div>

                      <h3 class="blogCard__title text-18 fw-500 mt-10">Kenya vs Tanzania Safari: The Better African Safari Experience</h3>
                    </div>
                  </a>
                </div>

                <div class="col-lg-4 col-md-6">
                  <a href="#" class="blogCard -type-1">
                    <div class="blogCard__image ratio ratio-41:30">
                      <img src="img/blogCards/1/5.png" alt="image" class="img-ratio rounded-12">

                      <div class="blogCard__badge">Trips</div>
                    </div>

                    <div class="blogCard__content mt-30">
                      <div class="blogCard__info text-14">
                        <div class="lh-13">April 06 2023</div>
                        <div class="blogCard__line"></div>
                        <div class="lh-13">By Ali Tufan</div>
                      </div>

                      <h3 class="blogCard__title text-18 fw-500 mt-10">Kenya vs Tanzania Safari: The Better African Safari Experience</h3>
                    </div>
                  </a>
                </div>

                <div class="col-lg-4 col-md-6">
                  <a href="#" class="blogCard -type-1">
                    <div class="blogCard__image ratio ratio-41:30">
                      <img src="img/blogCards/1/6.png" alt="image" class="img-ratio rounded-12">

                      <div class="blogCard__badge">Trips</div>
                    </div>

                    <div class="blogCard__content mt-30">
                      <div class="blogCard__info text-14">
                        <div class="lh-13">April 06 2023</div>
                        <div class="blogCard__line"></div>
                        <div class="lh-13">By Ali Tufan</div>
                      </div>

                      <h3 class="blogCard__title text-18 fw-500 mt-10">Kenya vs Tanzania Safari: The Better African Safari Experience</h3>
                    </div>
                  </a>
                </div>

                <div class="col-lg-4 col-md-6">
                  <a href="#" class="blogCard -type-1">
                    <div class="blogCard__image ratio ratio-41:30">
                      <img src="img/blogCards/1/7.png" alt="image" class="img-ratio rounded-12">

                      <div class="blogCard__badge">Trips</div>
                    </div>

                    <div class="blogCard__content mt-30">
                      <div class="blogCard__info text-14">
                        <div class="lh-13">April 06 2023</div>
                        <div class="blogCard__line"></div>
                        <div class="lh-13">By Ali Tufan</div>
                      </div>

                      <h3 class="blogCard__title text-18 fw-500 mt-10">Kenya vs Tanzania Safari: The Better African Safari Experience</h3>
                    </div>
                  </a>
                </div>

                <div class="col-lg-4 col-md-6">
                  <a href="#" class="blogCard -type-1">
                    <div class="blogCard__image ratio ratio-41:30">
                      <img src="img/blogCards/1/8.png" alt="image" class="img-ratio rounded-12">

                      <div class="blogCard__badge">Trips</div>
                    </div>

                    <div class="blogCard__content mt-30">
                      <div class="blogCard__info text-14">
                        <div class="lh-13">April 06 2023</div>
                        <div class="blogCard__line"></div>
                        <div class="lh-13">By Ali Tufan</div>
                      </div>

                      <h3 class="blogCard__title text-18 fw-500 mt-10">Kenya vs Tanzania Safari: The Better African Safari Experience</h3>
                    </div>
                  </a>
                </div>

                <div class="col-lg-4 col-md-6">
                  <a href="#" class="blogCard -type-1">
                    <div class="blogCard__image ratio ratio-41:30">
                      <img src="img/blogCards/1/9.png" alt="image" class="img-ratio rounded-12">

                      <div class="blogCard__badge">Trips</div>
                    </div>

                    <div class="blogCard__content mt-30">
                      <div class="blogCard__info text-14">
                        <div class="lh-13">April 06 2023</div>
                        <div class="blogCard__line"></div>
                        <div class="lh-13">By Ali Tufan</div>
                      </div>

                      <h3 class="blogCard__title text-18 fw-500 mt-10">Kenya vs Tanzania Safari: The Better African Safari Experience</h3>
                    </div>
                  </a>
                </div>

              </div>
            </div>

            <div class="tabs__pane -tab-item-2 ">
              <div class="row y-gap-30">

                <div class="col-lg-4 col-md-6">
                  <a href="#" class="blogCard -type-1">
                    <div class="blogCard__image ratio ratio-41:30">
                      <img src="img/blogCards/1/1.png" alt="image" class="img-ratio rounded-12">

                      <div class="blogCard__badge">Trips</div>
                    </div>

                    <div class="blogCard__content mt-30">
                      <div class="blogCard__info text-14">
                        <div class="lh-13">April 06 2023</div>
                        <div class="blogCard__line"></div>
                        <div class="lh-13">By Ali Tufan</div>
                      </div>

                      <h3 class="blogCard__title text-18 fw-500 mt-10">Kenya vs Tanzania Safari: The Better African Safari Experience</h3>
                    </div>
                  </a>
                </div>

                <div class="col-lg-4 col-md-6">
                  <a href="#" class="blogCard -type-1">
                    <div class="blogCard__image ratio ratio-41:30">
                      <img src="img/blogCards/1/2.png" alt="image" class="img-ratio rounded-12">

                      <div class="blogCard__badge">Trips</div>
                    </div>

                    <div class="blogCard__content mt-30">
                      <div class="blogCard__info text-14">
                        <div class="lh-13">April 06 2023</div>
                        <div class="blogCard__line"></div>
                        <div class="lh-13">By Ali Tufan</div>
                      </div>

                      <h3 class="blogCard__title text-18 fw-500 mt-10">Kenya vs Tanzania Safari: The Better African Safari Experience</h3>
                    </div>
                  </a>
                </div>

                <div class="col-lg-4 col-md-6">
                  <a href="#" class="blogCard -type-1">
                    <div class="blogCard__image ratio ratio-41:30">
                      <img src="img/blogCards/1/3.png" alt="image" class="img-ratio rounded-12">

                      <div class="blogCard__badge">Trips</div>
                    </div>

                    <div class="blogCard__content mt-30">
                      <div class="blogCard__info text-14">
                        <div class="lh-13">April 06 2023</div>
                        <div class="blogCard__line"></div>
                        <div class="lh-13">By Ali Tufan</div>
                      </div>

                      <h3 class="blogCard__title text-18 fw-500 mt-10">Kenya vs Tanzania Safari: The Better African Safari Experience</h3>
                    </div>
                  </a>
                </div>

                <div class="col-lg-4 col-md-6">
                  <a href="#" class="blogCard -type-1">
                    <div class="blogCard__image ratio ratio-41:30">
                      <img src="img/blogCards/1/4.png" alt="image" class="img-ratio rounded-12">

                      <div class="blogCard__badge">Trips</div>
                    </div>

                    <div class="blogCard__content mt-30">
                      <div class="blogCard__info text-14">
                        <div class="lh-13">April 06 2023</div>
                        <div class="blogCard__line"></div>
                        <div class="lh-13">By Ali Tufan</div>
                      </div>

                      <h3 class="blogCard__title text-18 fw-500 mt-10">Kenya vs Tanzania Safari: The Better African Safari Experience</h3>
                    </div>
                  </a>
                </div>

                <div class="col-lg-4 col-md-6">
                  <a href="#" class="blogCard -type-1">
                    <div class="blogCard__image ratio ratio-41:30">
                      <img src="img/blogCards/1/5.png" alt="image" class="img-ratio rounded-12">

                      <div class="blogCard__badge">Trips</div>
                    </div>

                    <div class="blogCard__content mt-30">
                      <div class="blogCard__info text-14">
                        <div class="lh-13">April 06 2023</div>
                        <div class="blogCard__line"></div>
                        <div class="lh-13">By Ali Tufan</div>
                      </div>

                      <h3 class="blogCard__title text-18 fw-500 mt-10">Kenya vs Tanzania Safari: The Better African Safari Experience</h3>
                    </div>
                  </a>
                </div>

                <div class="col-lg-4 col-md-6">
                  <a href="#" class="blogCard -type-1">
                    <div class="blogCard__image ratio ratio-41:30">
                      <img src="img/blogCards/1/6.png" alt="image" class="img-ratio rounded-12">

                      <div class="blogCard__badge">Trips</div>
                    </div>

                    <div class="blogCard__content mt-30">
                      <div class="blogCard__info text-14">
                        <div class="lh-13">April 06 2023</div>
                        <div class="blogCard__line"></div>
                        <div class="lh-13">By Ali Tufan</div>
                      </div>

                      <h3 class="blogCard__title text-18 fw-500 mt-10">Kenya vs Tanzania Safari: The Better African Safari Experience</h3>
                    </div>
                  </a>
                </div>

                <div class="col-lg-4 col-md-6">
                  <a href="#" class="blogCard -type-1">
                    <div class="blogCard__image ratio ratio-41:30">
                      <img src="img/blogCards/1/7.png" alt="image" class="img-ratio rounded-12">

                      <div class="blogCard__badge">Trips</div>
                    </div>

                    <div class="blogCard__content mt-30">
                      <div class="blogCard__info text-14">
                        <div class="lh-13">April 06 2023</div>
                        <div class="blogCard__line"></div>
                        <div class="lh-13">By Ali Tufan</div>
                      </div>

                      <h3 class="blogCard__title text-18 fw-500 mt-10">Kenya vs Tanzania Safari: The Better African Safari Experience</h3>
                    </div>
                  </a>
                </div>

                <div class="col-lg-4 col-md-6">
                  <a href="#" class="blogCard -type-1">
                    <div class="blogCard__image ratio ratio-41:30">
                      <img src="img/blogCards/1/8.png" alt="image" class="img-ratio rounded-12">

                      <div class="blogCard__badge">Trips</div>
                    </div>

                    <div class="blogCard__content mt-30">
                      <div class="blogCard__info text-14">
                        <div class="lh-13">April 06 2023</div>
                        <div class="blogCard__line"></div>
                        <div class="lh-13">By Ali Tufan</div>
                      </div>

                      <h3 class="blogCard__title text-18 fw-500 mt-10">Kenya vs Tanzania Safari: The Better African Safari Experience</h3>
                    </div>
                  </a>
                </div>

                <div class="col-lg-4 col-md-6">
                  <a href="#" class="blogCard -type-1">
                    <div class="blogCard__image ratio ratio-41:30">
                      <img src="img/blogCards/1/9.png" alt="image" class="img-ratio rounded-12">

                      <div class="blogCard__badge">Trips</div>
                    </div>

                    <div class="blogCard__content mt-30">
                      <div class="blogCard__info text-14">
                        <div class="lh-13">April 06 2023</div>
                        <div class="blogCard__line"></div>
                        <div class="lh-13">By Ali Tufan</div>
                      </div>

                      <h3 class="blogCard__title text-18 fw-500 mt-10">Kenya vs Tanzania Safari: The Better African Safari Experience</h3>
                    </div>
                  </a>
                </div>

              </div>
            </div>

            <div class="tabs__pane -tab-item-3 ">
              <div class="row y-gap-30">

                <div class="col-lg-4 col-md-6">
                  <a href="#" class="blogCard -type-1">
                    <div class="blogCard__image ratio ratio-41:30">
                      <img src="img/blogCards/1/1.png" alt="image" class="img-ratio rounded-12">

                      <div class="blogCard__badge">Trips</div>
                    </div>

                    <div class="blogCard__content mt-30">
                      <div class="blogCard__info text-14">
                        <div class="lh-13">April 06 2023</div>
                        <div class="blogCard__line"></div>
                        <div class="lh-13">By Ali Tufan</div>
                      </div>

                      <h3 class="blogCard__title text-18 fw-500 mt-10">Kenya vs Tanzania Safari: The Better African Safari Experience</h3>
                    </div>
                  </a>
                </div>

                <div class="col-lg-4 col-md-6">
                  <a href="#" class="blogCard -type-1">
                    <div class="blogCard__image ratio ratio-41:30">
                      <img src="img/blogCards/1/2.png" alt="image" class="img-ratio rounded-12">

                      <div class="blogCard__badge">Trips</div>
                    </div>

                    <div class="blogCard__content mt-30">
                      <div class="blogCard__info text-14">
                        <div class="lh-13">April 06 2023</div>
                        <div class="blogCard__line"></div>
                        <div class="lh-13">By Ali Tufan</div>
                      </div>

                      <h3 class="blogCard__title text-18 fw-500 mt-10">Kenya vs Tanzania Safari: The Better African Safari Experience</h3>
                    </div>
                  </a>
                </div>

                <div class="col-lg-4 col-md-6">
                  <a href="#" class="blogCard -type-1">
                    <div class="blogCard__image ratio ratio-41:30">
                      <img src="img/blogCards/1/3.png" alt="image" class="img-ratio rounded-12">

                      <div class="blogCard__badge">Trips</div>
                    </div>

                    <div class="blogCard__content mt-30">
                      <div class="blogCard__info text-14">
                        <div class="lh-13">April 06 2023</div>
                        <div class="blogCard__line"></div>
                        <div class="lh-13">By Ali Tufan</div>
                      </div>

                      <h3 class="blogCard__title text-18 fw-500 mt-10">Kenya vs Tanzania Safari: The Better African Safari Experience</h3>
                    </div>
                  </a>
                </div>

                <div class="col-lg-4 col-md-6">
                  <a href="#" class="blogCard -type-1">
                    <div class="blogCard__image ratio ratio-41:30">
                      <img src="img/blogCards/1/4.png" alt="image" class="img-ratio rounded-12">

                      <div class="blogCard__badge">Trips</div>
                    </div>

                    <div class="blogCard__content mt-30">
                      <div class="blogCard__info text-14">
                        <div class="lh-13">April 06 2023</div>
                        <div class="blogCard__line"></div>
                        <div class="lh-13">By Ali Tufan</div>
                      </div>

                      <h3 class="blogCard__title text-18 fw-500 mt-10">Kenya vs Tanzania Safari: The Better African Safari Experience</h3>
                    </div>
                  </a>
                </div>

                <div class="col-lg-4 col-md-6">
                  <a href="#" class="blogCard -type-1">
                    <div class="blogCard__image ratio ratio-41:30">
                      <img src="img/blogCards/1/5.png" alt="image" class="img-ratio rounded-12">

                      <div class="blogCard__badge">Trips</div>
                    </div>

                    <div class="blogCard__content mt-30">
                      <div class="blogCard__info text-14">
                        <div class="lh-13">April 06 2023</div>
                        <div class="blogCard__line"></div>
                        <div class="lh-13">By Ali Tufan</div>
                      </div>

                      <h3 class="blogCard__title text-18 fw-500 mt-10">Kenya vs Tanzania Safari: The Better African Safari Experience</h3>
                    </div>
                  </a>
                </div>

                <div class="col-lg-4 col-md-6">
                  <a href="#" class="blogCard -type-1">
                    <div class="blogCard__image ratio ratio-41:30">
                      <img src="img/blogCards/1/6.png" alt="image" class="img-ratio rounded-12">

                      <div class="blogCard__badge">Trips</div>
                    </div>

                    <div class="blogCard__content mt-30">
                      <div class="blogCard__info text-14">
                        <div class="lh-13">April 06 2023</div>
                        <div class="blogCard__line"></div>
                        <div class="lh-13">By Ali Tufan</div>
                      </div>

                      <h3 class="blogCard__title text-18 fw-500 mt-10">Kenya vs Tanzania Safari: The Better African Safari Experience</h3>
                    </div>
                  </a>
                </div>

                <div class="col-lg-4 col-md-6">
                  <a href="#" class="blogCard -type-1">
                    <div class="blogCard__image ratio ratio-41:30">
                      <img src="img/blogCards/1/7.png" alt="image" class="img-ratio rounded-12">

                      <div class="blogCard__badge">Trips</div>
                    </div>

                    <div class="blogCard__content mt-30">
                      <div class="blogCard__info text-14">
                        <div class="lh-13">April 06 2023</div>
                        <div class="blogCard__line"></div>
                        <div class="lh-13">By Ali Tufan</div>
                      </div>

                      <h3 class="blogCard__title text-18 fw-500 mt-10">Kenya vs Tanzania Safari: The Better African Safari Experience</h3>
                    </div>
                  </a>
                </div>

                <div class="col-lg-4 col-md-6">
                  <a href="#" class="blogCard -type-1">
                    <div class="blogCard__image ratio ratio-41:30">
                      <img src="img/blogCards/1/8.png" alt="image" class="img-ratio rounded-12">

                      <div class="blogCard__badge">Trips</div>
                    </div>

                    <div class="blogCard__content mt-30">
                      <div class="blogCard__info text-14">
                        <div class="lh-13">April 06 2023</div>
                        <div class="blogCard__line"></div>
                        <div class="lh-13">By Ali Tufan</div>
                      </div>

                      <h3 class="blogCard__title text-18 fw-500 mt-10">Kenya vs Tanzania Safari: The Better African Safari Experience</h3>
                    </div>
                  </a>
                </div>

                <div class="col-lg-4 col-md-6">
                  <a href="#" class="blogCard -type-1">
                    <div class="blogCard__image ratio ratio-41:30">
                      <img src="img/blogCards/1/9.png" alt="image" class="img-ratio rounded-12">

                      <div class="blogCard__badge">Trips</div>
                    </div>

                    <div class="blogCard__content mt-30">
                      <div class="blogCard__info text-14">
                        <div class="lh-13">April 06 2023</div>
                        <div class="blogCard__line"></div>
                        <div class="lh-13">By Ali Tufan</div>
                      </div>

                      <h3 class="blogCard__title text-18 fw-500 mt-10">Kenya vs Tanzania Safari: The Better African Safari Experience</h3>
                    </div>
                  </a>
                </div>

              </div>
            </div>

            <div class="tabs__pane -tab-item-4 ">
              <div class="row y-gap-30">

                <div class="col-lg-4 col-md-6">
                  <a href="#" class="blogCard -type-1">
                    <div class="blogCard__image ratio ratio-41:30">
                      <img src="img/blogCards/1/1.png" alt="image" class="img-ratio rounded-12">

                      <div class="blogCard__badge">Trips</div>
                    </div>

                    <div class="blogCard__content mt-30">
                      <div class="blogCard__info text-14">
                        <div class="lh-13">April 06 2023</div>
                        <div class="blogCard__line"></div>
                        <div class="lh-13">By Ali Tufan</div>
                      </div>

                      <h3 class="blogCard__title text-18 fw-500 mt-10">Kenya vs Tanzania Safari: The Better African Safari Experience</h3>
                    </div>
                  </a>
                </div>

                <div class="col-lg-4 col-md-6">
                  <a href="#" class="blogCard -type-1">
                    <div class="blogCard__image ratio ratio-41:30">
                      <img src="img/blogCards/1/2.png" alt="image" class="img-ratio rounded-12">

                      <div class="blogCard__badge">Trips</div>
                    </div>

                    <div class="blogCard__content mt-30">
                      <div class="blogCard__info text-14">
                        <div class="lh-13">April 06 2023</div>
                        <div class="blogCard__line"></div>
                        <div class="lh-13">By Ali Tufan</div>
                      </div>

                      <h3 class="blogCard__title text-18 fw-500 mt-10">Kenya vs Tanzania Safari: The Better African Safari Experience</h3>
                    </div>
                  </a>
                </div>

                <div class="col-lg-4 col-md-6">
                  <a href="#" class="blogCard -type-1">
                    <div class="blogCard__image ratio ratio-41:30">
                      <img src="img/blogCards/1/3.png" alt="image" class="img-ratio rounded-12">

                      <div class="blogCard__badge">Trips</div>
                    </div>

                    <div class="blogCard__content mt-30">
                      <div class="blogCard__info text-14">
                        <div class="lh-13">April 06 2023</div>
                        <div class="blogCard__line"></div>
                        <div class="lh-13">By Ali Tufan</div>
                      </div>

                      <h3 class="blogCard__title text-18 fw-500 mt-10">Kenya vs Tanzania Safari: The Better African Safari Experience</h3>
                    </div>
                  </a>
                </div>

                <div class="col-lg-4 col-md-6">
                  <a href="#" class="blogCard -type-1">
                    <div class="blogCard__image ratio ratio-41:30">
                      <img src="img/blogCards/1/4.png" alt="image" class="img-ratio rounded-12">

                      <div class="blogCard__badge">Trips</div>
                    </div>

                    <div class="blogCard__content mt-30">
                      <div class="blogCard__info text-14">
                        <div class="lh-13">April 06 2023</div>
                        <div class="blogCard__line"></div>
                        <div class="lh-13">By Ali Tufan</div>
                      </div>

                      <h3 class="blogCard__title text-18 fw-500 mt-10">Kenya vs Tanzania Safari: The Better African Safari Experience</h3>
                    </div>
                  </a>
                </div>

                <div class="col-lg-4 col-md-6">
                  <a href="#" class="blogCard -type-1">
                    <div class="blogCard__image ratio ratio-41:30">
                      <img src="img/blogCards/1/5.png" alt="image" class="img-ratio rounded-12">

                      <div class="blogCard__badge">Trips</div>
                    </div>

                    <div class="blogCard__content mt-30">
                      <div class="blogCard__info text-14">
                        <div class="lh-13">April 06 2023</div>
                        <div class="blogCard__line"></div>
                        <div class="lh-13">By Ali Tufan</div>
                      </div>

                      <h3 class="blogCard__title text-18 fw-500 mt-10">Kenya vs Tanzania Safari: The Better African Safari Experience</h3>
                    </div>
                  </a>
                </div>

                <div class="col-lg-4 col-md-6">
                  <a href="#" class="blogCard -type-1">
                    <div class="blogCard__image ratio ratio-41:30">
                      <img src="img/blogCards/1/6.png" alt="image" class="img-ratio rounded-12">

                      <div class="blogCard__badge">Trips</div>
                    </div>

                    <div class="blogCard__content mt-30">
                      <div class="blogCard__info text-14">
                        <div class="lh-13">April 06 2023</div>
                        <div class="blogCard__line"></div>
                        <div class="lh-13">By Ali Tufan</div>
                      </div>

                      <h3 class="blogCard__title text-18 fw-500 mt-10">Kenya vs Tanzania Safari: The Better African Safari Experience</h3>
                    </div>
                  </a>
                </div>

                <div class="col-lg-4 col-md-6">
                  <a href="#" class="blogCard -type-1">
                    <div class="blogCard__image ratio ratio-41:30">
                      <img src="img/blogCards/1/7.png" alt="image" class="img-ratio rounded-12">

                      <div class="blogCard__badge">Trips</div>
                    </div>

                    <div class="blogCard__content mt-30">
                      <div class="blogCard__info text-14">
                        <div class="lh-13">April 06 2023</div>
                        <div class="blogCard__line"></div>
                        <div class="lh-13">By Ali Tufan</div>
                      </div>

                      <h3 class="blogCard__title text-18 fw-500 mt-10">Kenya vs Tanzania Safari: The Better African Safari Experience</h3>
                    </div>
                  </a>
                </div>

                <div class="col-lg-4 col-md-6">
                  <a href="#" class="blogCard -type-1">
                    <div class="blogCard__image ratio ratio-41:30">
                      <img src="img/blogCards/1/8.png" alt="image" class="img-ratio rounded-12">

                      <div class="blogCard__badge">Trips</div>
                    </div>

                    <div class="blogCard__content mt-30">
                      <div class="blogCard__info text-14">
                        <div class="lh-13">April 06 2023</div>
                        <div class="blogCard__line"></div>
                        <div class="lh-13">By Ali Tufan</div>
                      </div>

                      <h3 class="blogCard__title text-18 fw-500 mt-10">Kenya vs Tanzania Safari: The Better African Safari Experience</h3>
                    </div>
                  </a>
                </div>

                <div class="col-lg-4 col-md-6">
                  <a href="#" class="blogCard -type-1">
                    <div class="blogCard__image ratio ratio-41:30">
                      <img src="img/blogCards/1/9.png" alt="image" class="img-ratio rounded-12">

                      <div class="blogCard__badge">Trips</div>
                    </div>

                    <div class="blogCard__content mt-30">
                      <div class="blogCard__info text-14">
                        <div class="lh-13">April 06 2023</div>
                        <div class="blogCard__line"></div>
                        <div class="lh-13">By Ali Tufan</div>
                      </div>

                      <h3 class="blogCard__title text-18 fw-500 mt-10">Kenya vs Tanzania Safari: The Better African Safari Experience</h3>
                    </div>
                  </a>
                </div>

              </div>
            </div>

            <div class="tabs__pane -tab-item-5 ">
              <div class="row y-gap-30">

                <div class="col-lg-4 col-md-6">
                  <a href="#" class="blogCard -type-1">
                    <div class="blogCard__image ratio ratio-41:30">
                      <img src="img/blogCards/1/1.png" alt="image" class="img-ratio rounded-12">

                      <div class="blogCard__badge">Trips</div>
                    </div>

                    <div class="blogCard__content mt-30">
                      <div class="blogCard__info text-14">
                        <div class="lh-13">April 06 2023</div>
                        <div class="blogCard__line"></div>
                        <div class="lh-13">By Ali Tufan</div>
                      </div>

                      <h3 class="blogCard__title text-18 fw-500 mt-10">Kenya vs Tanzania Safari: The Better African Safari Experience</h3>
                    </div>
                  </a>
                </div>

                <div class="col-lg-4 col-md-6">
                  <a href="#" class="blogCard -type-1">
                    <div class="blogCard__image ratio ratio-41:30">
                      <img src="img/blogCards/1/2.png" alt="image" class="img-ratio rounded-12">

                      <div class="blogCard__badge">Trips</div>
                    </div>

                    <div class="blogCard__content mt-30">
                      <div class="blogCard__info text-14">
                        <div class="lh-13">April 06 2023</div>
                        <div class="blogCard__line"></div>
                        <div class="lh-13">By Ali Tufan</div>
                      </div>

                      <h3 class="blogCard__title text-18 fw-500 mt-10">Kenya vs Tanzania Safari: The Better African Safari Experience</h3>
                    </div>
                  </a>
                </div>

                <div class="col-lg-4 col-md-6">
                  <a href="#" class="blogCard -type-1">
                    <div class="blogCard__image ratio ratio-41:30">
                      <img src="img/blogCards/1/3.png" alt="image" class="img-ratio rounded-12">

                      <div class="blogCard__badge">Trips</div>
                    </div>

                    <div class="blogCard__content mt-30">
                      <div class="blogCard__info text-14">
                        <div class="lh-13">April 06 2023</div>
                        <div class="blogCard__line"></div>
                        <div class="lh-13">By Ali Tufan</div>
                      </div>

                      <h3 class="blogCard__title text-18 fw-500 mt-10">Kenya vs Tanzania Safari: The Better African Safari Experience</h3>
                    </div>
                  </a>
                </div>

                <div class="col-lg-4 col-md-6">
                  <a href="#" class="blogCard -type-1">
                    <div class="blogCard__image ratio ratio-41:30">
                      <img src="img/blogCards/1/4.png" alt="image" class="img-ratio rounded-12">

                      <div class="blogCard__badge">Trips</div>
                    </div>

                    <div class="blogCard__content mt-30">
                      <div class="blogCard__info text-14">
                        <div class="lh-13">April 06 2023</div>
                        <div class="blogCard__line"></div>
                        <div class="lh-13">By Ali Tufan</div>
                      </div>

                      <h3 class="blogCard__title text-18 fw-500 mt-10">Kenya vs Tanzania Safari: The Better African Safari Experience</h3>
                    </div>
                  </a>
                </div>

                <div class="col-lg-4 col-md-6">
                  <a href="#" class="blogCard -type-1">
                    <div class="blogCard__image ratio ratio-41:30">
                      <img src="img/blogCards/1/5.png" alt="image" class="img-ratio rounded-12">

                      <div class="blogCard__badge">Trips</div>
                    </div>

                    <div class="blogCard__content mt-30">
                      <div class="blogCard__info text-14">
                        <div class="lh-13">April 06 2023</div>
                        <div class="blogCard__line"></div>
                        <div class="lh-13">By Ali Tufan</div>
                      </div>

                      <h3 class="blogCard__title text-18 fw-500 mt-10">Kenya vs Tanzania Safari: The Better African Safari Experience</h3>
                    </div>
                  </a>
                </div>

                <div class="col-lg-4 col-md-6">
                  <a href="#" class="blogCard -type-1">
                    <div class="blogCard__image ratio ratio-41:30">
                      <img src="img/blogCards/1/6.png" alt="image" class="img-ratio rounded-12">

                      <div class="blogCard__badge">Trips</div>
                    </div>

                    <div class="blogCard__content mt-30">
                      <div class="blogCard__info text-14">
                        <div class="lh-13">April 06 2023</div>
                        <div class="blogCard__line"></div>
                        <div class="lh-13">By Ali Tufan</div>
                      </div>

                      <h3 class="blogCard__title text-18 fw-500 mt-10">Kenya vs Tanzania Safari: The Better African Safari Experience</h3>
                    </div>
                  </a>
                </div>

                <div class="col-lg-4 col-md-6">
                  <a href="#" class="blogCard -type-1">
                    <div class="blogCard__image ratio ratio-41:30">
                      <img src="img/blogCards/1/7.png" alt="image" class="img-ratio rounded-12">

                      <div class="blogCard__badge">Trips</div>
                    </div>

                    <div class="blogCard__content mt-30">
                      <div class="blogCard__info text-14">
                        <div class="lh-13">April 06 2023</div>
                        <div class="blogCard__line"></div>
                        <div class="lh-13">By Ali Tufan</div>
                      </div>

                      <h3 class="blogCard__title text-18 fw-500 mt-10">Kenya vs Tanzania Safari: The Better African Safari Experience</h3>
                    </div>
                  </a>
                </div>

                <div class="col-lg-4 col-md-6">
                  <a href="#" class="blogCard -type-1">
                    <div class="blogCard__image ratio ratio-41:30">
                      <img src="img/blogCards/1/8.png" alt="image" class="img-ratio rounded-12">

                      <div class="blogCard__badge">Trips</div>
                    </div>

                    <div class="blogCard__content mt-30">
                      <div class="blogCard__info text-14">
                        <div class="lh-13">April 06 2023</div>
                        <div class="blogCard__line"></div>
                        <div class="lh-13">By Ali Tufan</div>
                      </div>

                      <h3 class="blogCard__title text-18 fw-500 mt-10">Kenya vs Tanzania Safari: The Better African Safari Experience</h3>
                    </div>
                  </a>
                </div>

                <div class="col-lg-4 col-md-6">
                  <a href="#" class="blogCard -type-1">
                    <div class="blogCard__image ratio ratio-41:30">
                      <img src="img/blogCards/1/9.png" alt="image" class="img-ratio rounded-12">

                      <div class="blogCard__badge">Trips</div>
                    </div>

                    <div class="blogCard__content mt-30">
                      <div class="blogCard__info text-14">
                        <div class="lh-13">April 06 2023</div>
                        <div class="blogCard__line"></div>
                        <div class="lh-13">By Ali Tufan</div>
                      </div>

                      <h3 class="blogCard__title text-18 fw-500 mt-10">Kenya vs Tanzania Safari: The Better African Safari Experience</h3>
                    </div>
                  </a>
                </div>

              </div>
            </div>

            <div class="tabs__pane -tab-item-6 ">
              <div class="row y-gap-30">

                <div class="col-lg-4 col-md-6">
                  <a href="#" class="blogCard -type-1">
                    <div class="blogCard__image ratio ratio-41:30">
                      <img src="img/blogCards/1/1.png" alt="image" class="img-ratio rounded-12">

                      <div class="blogCard__badge">Trips</div>
                    </div>

                    <div class="blogCard__content mt-30">
                      <div class="blogCard__info text-14">
                        <div class="lh-13">April 06 2023</div>
                        <div class="blogCard__line"></div>
                        <div class="lh-13">By Ali Tufan</div>
                      </div>

                      <h3 class="blogCard__title text-18 fw-500 mt-10">Kenya vs Tanzania Safari: The Better African Safari Experience</h3>
                    </div>
                  </a>
                </div>

                <div class="col-lg-4 col-md-6">
                  <a href="#" class="blogCard -type-1">
                    <div class="blogCard__image ratio ratio-41:30">
                      <img src="img/blogCards/1/2.png" alt="image" class="img-ratio rounded-12">

                      <div class="blogCard__badge">Trips</div>
                    </div>

                    <div class="blogCard__content mt-30">
                      <div class="blogCard__info text-14">
                        <div class="lh-13">April 06 2023</div>
                        <div class="blogCard__line"></div>
                        <div class="lh-13">By Ali Tufan</div>
                      </div>

                      <h3 class="blogCard__title text-18 fw-500 mt-10">Kenya vs Tanzania Safari: The Better African Safari Experience</h3>
                    </div>
                  </a>
                </div>

                <div class="col-lg-4 col-md-6">
                  <a href="#" class="blogCard -type-1">
                    <div class="blogCard__image ratio ratio-41:30">
                      <img src="img/blogCards/1/3.png" alt="image" class="img-ratio rounded-12">

                      <div class="blogCard__badge">Trips</div>
                    </div>

                    <div class="blogCard__content mt-30">
                      <div class="blogCard__info text-14">
                        <div class="lh-13">April 06 2023</div>
                        <div class="blogCard__line"></div>
                        <div class="lh-13">By Ali Tufan</div>
                      </div>

                      <h3 class="blogCard__title text-18 fw-500 mt-10">Kenya vs Tanzania Safari: The Better African Safari Experience</h3>
                    </div>
                  </a>
                </div>

                <div class="col-lg-4 col-md-6">
                  <a href="#" class="blogCard -type-1">
                    <div class="blogCard__image ratio ratio-41:30">
                      <img src="img/blogCards/1/4.png" alt="image" class="img-ratio rounded-12">

                      <div class="blogCard__badge">Trips</div>
                    </div>

                    <div class="blogCard__content mt-30">
                      <div class="blogCard__info text-14">
                        <div class="lh-13">April 06 2023</div>
                        <div class="blogCard__line"></div>
                        <div class="lh-13">By Ali Tufan</div>
                      </div>

                      <h3 class="blogCard__title text-18 fw-500 mt-10">Kenya vs Tanzania Safari: The Better African Safari Experience</h3>
                    </div>
                  </a>
                </div>

                <div class="col-lg-4 col-md-6">
                  <a href="#" class="blogCard -type-1">
                    <div class="blogCard__image ratio ratio-41:30">
                      <img src="img/blogCards/1/5.png" alt="image" class="img-ratio rounded-12">

                      <div class="blogCard__badge">Trips</div>
                    </div>

                    <div class="blogCard__content mt-30">
                      <div class="blogCard__info text-14">
                        <div class="lh-13">April 06 2023</div>
                        <div class="blogCard__line"></div>
                        <div class="lh-13">By Ali Tufan</div>
                      </div>

                      <h3 class="blogCard__title text-18 fw-500 mt-10">Kenya vs Tanzania Safari: The Better African Safari Experience</h3>
                    </div>
                  </a>
                </div>

                <div class="col-lg-4 col-md-6">
                  <a href="#" class="blogCard -type-1">
                    <div class="blogCard__image ratio ratio-41:30">
                      <img src="img/blogCards/1/6.png" alt="image" class="img-ratio rounded-12">

                      <div class="blogCard__badge">Trips</div>
                    </div>

                    <div class="blogCard__content mt-30">
                      <div class="blogCard__info text-14">
                        <div class="lh-13">April 06 2023</div>
                        <div class="blogCard__line"></div>
                        <div class="lh-13">By Ali Tufan</div>
                      </div>

                      <h3 class="blogCard__title text-18 fw-500 mt-10">Kenya vs Tanzania Safari: The Better African Safari Experience</h3>
                    </div>
                  </a>
                </div>

                <div class="col-lg-4 col-md-6">
                  <a href="#" class="blogCard -type-1">
                    <div class="blogCard__image ratio ratio-41:30">
                      <img src="img/blogCards/1/7.png" alt="image" class="img-ratio rounded-12">

                      <div class="blogCard__badge">Trips</div>
                    </div>

                    <div class="blogCard__content mt-30">
                      <div class="blogCard__info text-14">
                        <div class="lh-13">April 06 2023</div>
                        <div class="blogCard__line"></div>
                        <div class="lh-13">By Ali Tufan</div>
                      </div>

                      <h3 class="blogCard__title text-18 fw-500 mt-10">Kenya vs Tanzania Safari: The Better African Safari Experience</h3>
                    </div>
                  </a>
                </div>

                <div class="col-lg-4 col-md-6">
                  <a href="#" class="blogCard -type-1">
                    <div class="blogCard__image ratio ratio-41:30">
                      <img src="img/blogCards/1/8.png" alt="image" class="img-ratio rounded-12">

                      <div class="blogCard__badge">Trips</div>
                    </div>

                    <div class="blogCard__content mt-30">
                      <div class="blogCard__info text-14">
                        <div class="lh-13">April 06 2023</div>
                        <div class="blogCard__line"></div>
                        <div class="lh-13">By Ali Tufan</div>
                      </div>

                      <h3 class="blogCard__title text-18 fw-500 mt-10">Kenya vs Tanzania Safari: The Better African Safari Experience</h3>
                    </div>
                  </a>
                </div>

                <div class="col-lg-4 col-md-6">
                  <a href="#" class="blogCard -type-1">
                    <div class="blogCard__image ratio ratio-41:30">
                      <img src="img/blogCards/1/9.png" alt="image" class="img-ratio rounded-12">

                      <div class="blogCard__badge">Trips</div>
                    </div>

                    <div class="blogCard__content mt-30">
                      <div class="blogCard__info text-14">
                        <div class="lh-13">April 06 2023</div>
                        <div class="blogCard__line"></div>
                        <div class="lh-13">By Ali Tufan</div>
                      </div>

                      <h3 class="blogCard__title text-18 fw-500 mt-10">Kenya vs Tanzania Safari: The Better African Safari Experience</h3>
                    </div>
                  </a>
                </div>

              </div>
            </div>

            <div class="tabs__pane -tab-item-7 ">
              <div class="row y-gap-30">

                <div class="col-lg-4 col-md-6">
                  <a href="#" class="blogCard -type-1">
                    <div class="blogCard__image ratio ratio-41:30">
                      <img src="img/blogCards/1/1.png" alt="image" class="img-ratio rounded-12">

                      <div class="blogCard__badge">Trips</div>
                    </div>

                    <div class="blogCard__content mt-30">
                      <div class="blogCard__info text-14">
                        <div class="lh-13">April 06 2023</div>
                        <div class="blogCard__line"></div>
                        <div class="lh-13">By Ali Tufan</div>
                      </div>

                      <h3 class="blogCard__title text-18 fw-500 mt-10">Kenya vs Tanzania Safari: The Better African Safari Experience</h3>
                    </div>
                  </a>
                </div>

                <div class="col-lg-4 col-md-6">
                  <a href="#" class="blogCard -type-1">
                    <div class="blogCard__image ratio ratio-41:30">
                      <img src="img/blogCards/1/2.png" alt="image" class="img-ratio rounded-12">

                      <div class="blogCard__badge">Trips</div>
                    </div>

                    <div class="blogCard__content mt-30">
                      <div class="blogCard__info text-14">
                        <div class="lh-13">April 06 2023</div>
                        <div class="blogCard__line"></div>
                        <div class="lh-13">By Ali Tufan</div>
                      </div>

                      <h3 class="blogCard__title text-18 fw-500 mt-10">Kenya vs Tanzania Safari: The Better African Safari Experience</h3>
                    </div>
                  </a>
                </div>

                <div class="col-lg-4 col-md-6">
                  <a href="#" class="blogCard -type-1">
                    <div class="blogCard__image ratio ratio-41:30">
                      <img src="img/blogCards/1/3.png" alt="image" class="img-ratio rounded-12">

                      <div class="blogCard__badge">Trips</div>
                    </div>

                    <div class="blogCard__content mt-30">
                      <div class="blogCard__info text-14">
                        <div class="lh-13">April 06 2023</div>
                        <div class="blogCard__line"></div>
                        <div class="lh-13">By Ali Tufan</div>
                      </div>

                      <h3 class="blogCard__title text-18 fw-500 mt-10">Kenya vs Tanzania Safari: The Better African Safari Experience</h3>
                    </div>
                  </a>
                </div>

                <div class="col-lg-4 col-md-6">
                  <a href="#" class="blogCard -type-1">
                    <div class="blogCard__image ratio ratio-41:30">
                      <img src="img/blogCards/1/4.png" alt="image" class="img-ratio rounded-12">

                      <div class="blogCard__badge">Trips</div>
                    </div>

                    <div class="blogCard__content mt-30">
                      <div class="blogCard__info text-14">
                        <div class="lh-13">April 06 2023</div>
                        <div class="blogCard__line"></div>
                        <div class="lh-13">By Ali Tufan</div>
                      </div>

                      <h3 class="blogCard__title text-18 fw-500 mt-10">Kenya vs Tanzania Safari: The Better African Safari Experience</h3>
                    </div>
                  </a>
                </div>

                <div class="col-lg-4 col-md-6">
                  <a href="#" class="blogCard -type-1">
                    <div class="blogCard__image ratio ratio-41:30">
                      <img src="img/blogCards/1/5.png" alt="image" class="img-ratio rounded-12">

                      <div class="blogCard__badge">Trips</div>
                    </div>

                    <div class="blogCard__content mt-30">
                      <div class="blogCard__info text-14">
                        <div class="lh-13">April 06 2023</div>
                        <div class="blogCard__line"></div>
                        <div class="lh-13">By Ali Tufan</div>
                      </div>

                      <h3 class="blogCard__title text-18 fw-500 mt-10">Kenya vs Tanzania Safari: The Better African Safari Experience</h3>
                    </div>
                  </a>
                </div>

                <div class="col-lg-4 col-md-6">
                  <a href="#" class="blogCard -type-1">
                    <div class="blogCard__image ratio ratio-41:30">
                      <img src="img/blogCards/1/6.png" alt="image" class="img-ratio rounded-12">

                      <div class="blogCard__badge">Trips</div>
                    </div>

                    <div class="blogCard__content mt-30">
                      <div class="blogCard__info text-14">
                        <div class="lh-13">April 06 2023</div>
                        <div class="blogCard__line"></div>
                        <div class="lh-13">By Ali Tufan</div>
                      </div>

                      <h3 class="blogCard__title text-18 fw-500 mt-10">Kenya vs Tanzania Safari: The Better African Safari Experience</h3>
                    </div>
                  </a>
                </div>

                <div class="col-lg-4 col-md-6">
                  <a href="#" class="blogCard -type-1">
                    <div class="blogCard__image ratio ratio-41:30">
                      <img src="img/blogCards/1/7.png" alt="image" class="img-ratio rounded-12">

                      <div class="blogCard__badge">Trips</div>
                    </div>

                    <div class="blogCard__content mt-30">
                      <div class="blogCard__info text-14">
                        <div class="lh-13">April 06 2023</div>
                        <div class="blogCard__line"></div>
                        <div class="lh-13">By Ali Tufan</div>
                      </div>

                      <h3 class="blogCard__title text-18 fw-500 mt-10">Kenya vs Tanzania Safari: The Better African Safari Experience</h3>
                    </div>
                  </a>
                </div>

                <div class="col-lg-4 col-md-6">
                  <a href="#" class="blogCard -type-1">
                    <div class="blogCard__image ratio ratio-41:30">
                      <img src="img/blogCards/1/8.png" alt="image" class="img-ratio rounded-12">

                      <div class="blogCard__badge">Trips</div>
                    </div>

                    <div class="blogCard__content mt-30">
                      <div class="blogCard__info text-14">
                        <div class="lh-13">April 06 2023</div>
                        <div class="blogCard__line"></div>
                        <div class="lh-13">By Ali Tufan</div>
                      </div>

                      <h3 class="blogCard__title text-18 fw-500 mt-10">Kenya vs Tanzania Safari: The Better African Safari Experience</h3>
                    </div>
                  </a>
                </div>

                <div class="col-lg-4 col-md-6">
                  <a href="#" class="blogCard -type-1">
                    <div class="blogCard__image ratio ratio-41:30">
                      <img src="img/blogCards/1/9.png" alt="image" class="img-ratio rounded-12">

                      <div class="blogCard__badge">Trips</div>
                    </div>

                    <div class="blogCard__content mt-30">
                      <div class="blogCard__info text-14">
                        <div class="lh-13">April 06 2023</div>
                        <div class="blogCard__line"></div>
                        <div class="lh-13">By Ali Tufan</div>
                      </div>

                      <h3 class="blogCard__title text-18 fw-500 mt-10">Kenya vs Tanzania Safari: The Better African Safari Experience</h3>
                    </div>
                  </a>
                </div>

              </div>
            </div>

          </div>
        </div>

        <div class="d-flex justify-center flex-column mt-60">

          <div class="pagination justify-center">
            <button class="pagination__button button -accent-1 mr-15 -prev">
              <i class="icon-arrow-left text-15"></i>
            </button>

            <div class="pagination__count">
              <a href="#">1</a>
              <a href="#" class="is-active">2</a>
              <a href="#">3</a>
              <a href="#">4</a>
              <a href="#">5</a>
              <div>...</div>
              <a href="#">20</a>
            </div>

            <button class="pagination__button button -accent-1 ml-15 -next">
              <i class="icon-arrow-right text-15"></i>
            </button>
          </div>

          <div class="text-14 text-center mt-20">Showing results 1-30 of 1,415</div>

        </div>
      </div>
    </section>
    <?php echo $__env->make('layouts.footer', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
  </main>

  <!-- JavaScript -->
  <script src="https://maps.googleapis.com/maps/api/js?key=AIzaSyAAz77U5XQuEME6TpftaMdX0bBelQxXRlM"></script>
  <script src="../../../unpkg.com/%40googlemaps/markerclusterer%402.5.3/dist/index.min.js"></script>

  <script src="/js/vendors.js"></script>
  <script src="/js/main.js"></script>
</body>
</html><?php /**PATH C:\xampp\htdocs\projetAbdellah\resources\views/blog.blade.php ENDPATH**/ ?>