<!DOCTYPE html>
<html lang="en" data-x="html" data-x-toggle="html-overflow-hidden">
<head>
  <!-- Required meta tags -->
  <meta charset="UTF-8">
  <meta name="viewport" content="width=device-width, initial-scale=1">

  <!-- Google fonts -->
  <link rel="preconnect" href="https://fonts.googleapis.com/">
  <link rel="preconnect" href="https://fonts.gstatic.com/" crossorigin>
  <link href="https://fonts.googleapis.com/css2?family=DM+Sans:ital,wght@0,400;0,500;0,700;1,400;1,500;1,700&amp;display=swap" rel="stylesheet">

  <!-- Stylesheets -->
  <link rel="stylesheet" href="/css/vendors.css">
  <link rel="stylesheet" href="/css/main.css">

  <title>Marrakech Morocco Tours</title>
</head>

<body>
  <?php echo $__env->make('layouts.header', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
    <section data-anim-wrap class="hero -type-10">
      <div data-anim-child="fade" class="hero__bg">
        <img src="/img/background/Ouarzazate.webp" alt="background">
      </div>

      <div class="container">
        <div class="row justify-center text-center">
          <div class="col-xl-9 col-lg-10">
            <div class="hero__content">
              <h1 data-anim-child="slide-up delay-2" class="hero__title text-white">
                <?php echo __('strings.Choose Our Country'); ?>

              </h1>

              <div data-anim-child="slide-up delay-4" class="hero__search">
                <svg width="20" height="20" viewBox="0 0 20 20" fill="none" xmlns="http://www.w3.org/2000/svg">
                  <path d="M10.0001 4.29932C7.95277 4.29932 6.28711 5.96498 6.28711 8.01232C6.28711 10.0597 7.95277 11.7253 10.0001 11.7253C12.0475 11.7253 13.7131 10.0597 13.7131 8.01232C13.7131 5.96498 12.0475 4.29932 10.0001 4.29932ZM10.0001 10.162C8.8148 10.162 7.85047 9.19764 7.85047 8.01232C7.85047 6.82701 8.8148 5.86268 10.0001 5.86268C11.1854 5.86268 12.1498 6.82701 12.1498 8.01232C12.1498 9.19764 11.1854 10.162 10.0001 10.162Z" fill="#05073C" />
                  <path d="M10.0006 0C5.58258 0 1.98828 3.59434 1.98828 8.01231V8.23379C1.98828 10.4682 3.2693 13.0719 5.79586 15.9726C7.62742 18.0754 9.4334 19.5416 9.50934 19.603L10.0006 20L10.4918 19.6031C10.5678 19.5417 12.3738 18.0754 14.2053 15.9726C16.7318 13.0719 18.0129 10.4682 18.0129 8.23383V8.01234C18.0129 3.59434 14.4186 0 10.0006 0ZM16.4495 8.23383C16.4495 12.0098 11.5843 16.5807 10.0006 17.9683C8.41648 16.5803 3.55164 12.0095 3.55164 8.23383V8.01234C3.55164 4.45641 6.44465 1.5634 10.0006 1.5634C13.5565 1.5634 16.4495 4.45641 16.4495 8.01234V8.23383Z" fill="#05073C" />
                </svg>
              </div>
            </div>
          </div>
        </div>
      </div>
    </section>

    <section class="layout-pt-xl">
      <div data-anim-wrap class="container">
        <div data-anim-child="slide-up" class="row y-gap-10 justify-between items-center y-gap-10">
          <div class="col-auto">
            <h2 class="text-30 md:text-24">
             <?php echo e(__('strings.Day trips from')); ?>

              <div class="dropdown -type-list js-dropdown js-form-dd" data-main-value="Mararkech">
                <div class=" text-light-7 js-button">
                  <span class="js-title" style="color: #ef7742;"><?php echo e(__('strings.Mararkech')); ?></span>
                  <i class="icon-chevron-down ml-5 text-18"></i>
                </div>
              </div>
            </h2>
          </div>
        </div>

        <div data-anim-child="slide-up delay-2" class="row y-gap-30 pt-40 sm:pt-20">
        <?php if(!empty($trips)): ?>
	        <?php $__currentLoopData = $trips; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $trip): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?> 
          <div class="col-lg-3 col-md-6">
            <a href="/detail/<?php echo str_replace(' ', '-', $trip->name); ?>" class="tourCard -type-1 d-block border-1 bg-white hover-shadow-1 overflow-hidden rounded-12 bg-white -hover-shadow">
              <div class="tourCard__header">
                <div class="tourCard__image ratio ratio-28:20">
                  <?php
                      // Get the file path and extension
                      $imagePath = $trip->pictures; // Assuming the image path is stored in the file_path attribute
                      $extension = pathinfo($imagePath, PATHINFO_EXTENSION);
                      
                      // Add text before the extension
                      $modifiedImagePath = preg_replace('/\.' . $extension . '$/', '-cropped.' . $extension, $imagePath);
                  ?>
                  <img src="<?php echo e(asset('/storage/' . $modifiedImagePath)); ?>" decoding="async" alt="<?php echo e($trip->name); ?>" title="<?php echo e($trip->name); ?>" class="img-ratio">
                </div>

                <button class="tourCard__favorit
                e">
                  <i class="icon-heart"></i>
                </button>
              </div>

              <div class="tourCard__content px-20 py-10">
                <div class="tourCard__location d-flex items-center text-13 text-light-2">
                  <i class="icon-pin d-flex text-16 text-light-2 mr-5"></i>
                  <?php echo e(__('strings.Mararkech')); ?>, <?php echo e(__('strings.Morocco')); ?>

                </div>

                <h3 class="tourCard__title text-16 fw-500 mt-5">
                  <span>
                  <?php if(Session()->has('lang')): ?>
                      <?php if(Session('lang') === 'fr'): ?>
                          <?php echo e($trip->name_fr); ?>

                      <?php elseif(Session('lang') === 'es'): ?>
                          <?php echo e($trip->name_es); ?>

                      <?php else: ?>
                          <?php echo e($trip->name); ?>

                      <?php endif; ?>
                  <?php else: ?>
                  <?php echo e($trip->name); ?>

                  <?php endif; ?>	
                  </span>
                </h3>

                <div class="tourCard__rating text-13 mt-5">
                  <div class="d-flex items-center">
                    <div class="d-flex x-gap-5">

                      <div><i class="icon-star text-10 text-yellow-2"></i></div>

                      <div><i class="icon-star text-10 text-yellow-2"></i></div>

                      <div><i class="icon-star text-10 text-yellow-2"></i></div>

                      <div><i class="icon-star text-10 text-yellow-2"></i></div>

                      <div><i class="icon-star text-10 text-yellow-2"></i></div>

                    </div>

                    <span class="text-dark-1 ml-10">4.8 (269)</span>
                  </div>
                </div>

                <div class="d-flex justify-between items-center border-1-top text-13 text-dark-1 pt-10 mt-10">
                  <div class="d-flex items-center">
                    <i class="icon-clock text-16 mr-5"></i>
                    1 <?php echo e(__('strings.Day')); ?>

                  </div>

                  <div><?php echo e(__('strings.From')); ?> <span class="text-16 fw-500">$<?php echo e($trip->price); ?></span></div>
                </div>
              </div>
            </a>
          </div>
          <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
					<?php endif; ?>  

          <div class="col-lg-3 col-md-6">

            <a href="#" class="tourCard -type-1 d-block border-1 bg-white hover-shadow-1 overflow-hidden rounded-12 bg-white -hover-shadow">
              <div class="tourCard__header">
                <div class="tourCard__image ratio ratio-28:20">
                  <img src="img/tourCards/1/4.png" alt="image" class="img-ratio">
                </div>

                <button class="tourCard__favorite">
                  <i class="icon-heart"></i>
                </button>
              </div>

              <div class="tourCard__content px-20 py-10">
                <div class="tourCard__location d-flex items-center text-13 text-light-2">
                  <i class="icon-pin d-flex text-16 text-light-2 mr-5"></i>
                  New York, USA
                </div>

                <h3 class="tourCard__title text-16 fw-500 mt-5">
                  <span>All Inclusive Ultimate Circle Island Day Tour with Lunch</span>
                </h3>

                <div class="tourCard__rating text-13 mt-5">
                  <div class="d-flex items-center">
                    <div class="d-flex x-gap-5">

                      <div><i class="icon-star text-10 text-yellow-2"></i></div>

                      <div><i class="icon-star text-10 text-yellow-2"></i></div>

                      <div><i class="icon-star text-10 text-yellow-2"></i></div>

                      <div><i class="icon-star text-10 text-yellow-2"></i></div>

                      <div><i class="icon-star text-10 text-yellow-2"></i></div>

                    </div>

                    <span class="text-dark-1 ml-10">4.8 (269)</span>
                  </div>
                </div>

                <div class="d-flex justify-between items-center border-1-top text-13 text-dark-1 pt-10 mt-10">
                  <div class="d-flex items-center">
                    <i class="icon-clock text-16 mr-5"></i>
                    4 days
                  </div>

                  <div>From <span class="text-16 fw-500">$771,00</span></div>
                </div>
              </div>
            </a>

          </div>

        </div>
      </div>
    </section>
    <section class="layout-pt-xl layout-pb-xl bg-accent-1-05">
      <div data-anim-wrap class="container">
        <div class="row y-gap-30 items-center justify-between">
          <div data-anim-child="slide-up" class="col-xl-4 col-lg-5">
            <h2 class="text-30 md:text-24"><?php echo e(__('strings.Popular things to do')); ?></h2>

            <p class="mt-30 md:mt-10"><?php echo e(__('strings.Txt Popular things to do')); ?></p>

            <a href="/tour-packages" class="button -md -dark-1 bg-accent-1 text-white mt-30 md:mt-20">
              <?php echo e(__('strings.See All')); ?>

              <i class="icon-arrow-top-right ml-10"></i>
            </a>
          </div>

          <div data-anim-child="slide-up delay-2" class="col-xl-6 col-lg-7">
            <div class="row y-gap-30">

              <div class="col-md-4 col-6">
                <a href="/blog" class="featureCard -type-5 -hover-accent-1">
                  <div class="featureCard__icon">
                    <img src="img/icons/5/1.svg" alt="image">
                  </div>

                  <h4 class="text-18 fw-500 mt-20"><?php echo e(__('strings.City Tours')); ?></h4>
                  <div class="lh-13 mt-5">100+ <?php echo e(__('strings.Tours')); ?></div>
                </a>
              </div>

              <div class="col-md-4 col-6">
                <a href="/blog" class="featureCard -type-5 -hover-accent-1">
                  <div class="featureCard__icon">
                    <img src="img/icons/5/2.svg" alt="image">
                  </div>

                  <h4 class="text-18 fw-500 mt-20"><?php echo e(__('strings.Cultural Morocco Tours')); ?></h4>
                  <div class="lh-13 mt-5">100+ <?php echo e(__('strings.Tours')); ?></div>
                </a>
              </div>

              <div class="col-md-4 col-6">
                <a href="/blog" class="featureCard -type-5 -hover-accent-1">
                  <div class="featureCard__icon">
                    <img src="img/icons/5/3.svg" alt="image">
                  </div>

                  <h4 class="text-18 fw-500 mt-20"><?php echo e(__('strings.Agadir')); ?></h4>
                  <div class="lh-13 mt-5">100+ <?php echo e(__('strings.Tours')); ?></div>
                </a>
              </div>

              <div class="col-md-4 col-6">
                <a href="/blog" class="featureCard -type-5 -hover-accent-1">
                  <div class="featureCard__icon">
                    <img src="img/icons/5/4.svg" alt="image">
                  </div>

                  <h4 class="text-18 fw-500 mt-20"><?php echo e(__('strings.Essaouira')); ?></h4>
                  <div class="lh-13 mt-5">100+ <?php echo e(__('strings.Tours')); ?></div>
                </a>
              </div>

              <div class="col-md-4 col-6">
                <a href="/blog" class="featureCard -type-5 -hover-accent-1">
                  <div class="featureCard__icon">
                    <img src="img/icons/5/5.svg" alt="image">
                  </div>

                  <h4 class="text-18 fw-500 mt-20"><?php echo e(__('strings.Oualidia')); ?></h4>
                  <div class="lh-13 mt-5">100+ <?php echo e(__('strings.Tours')); ?></div>
                </a>
              </div>

              <div class="col-md-4 col-6">
                <a href="/blog" class="featureCard -type-5 -hover-accent-1">
                  <div class="featureCard__icon">
                    <img src="img/icons/5/6.svg" alt="image">
                  </div>

                  <h4 class="text-18 fw-500 mt-20"><?php echo e(__('strings.Marrakech Food Tour')); ?></h4>
                  <div class="lh-13 mt-5">100+ <?php echo e(__('strings.Tours')); ?></div>
                </a>
              </div>

            </div>
          </div>
        </div>
      </div>
    </section>
    <section data-anim-wrap class="relative layout-pt-xl layout-pb-xl lg:pt-0">
      <div data-anim-child="slide-up delay-2" class="sectionBg -type-2">
        <div class="bg-accent-1-05 rounded-24"></div>
        <img src="/img/about/3/1.jpg" alt="image" class="rounded-24">
      </div>

      <div class="container">
        <div data-anim-child="slide-up" class="row">
          <div class="col-xl-4 offset-xl-1 col-lg-5">
            <h2 class="text-30 md:text-24"><?php echo __('strings.Why choose'); ?></h2>

            <div class="row y-gap-30 pt-60 sm:pt-30">

              <div class="col-12">
                <div class="featureIcon -type-1 d-flex">
                  <div class="featureIcon__icon size-50">
                    <img src="/img/icons/1/ticket.svg" alt="icon">
                  </div>

                  <div class="ml-30">
                    <h3 class="featureIcon__title text-18 fw-500"><?php echo e(__('strings.Ultimate flexibility')); ?></h3>
                    <p class="featureIcon__text mt-10"><?php echo e(__('strings.Txt Ultimate flexibility')); ?></p>
                  </div>
                </div>
              </div>

              <div class="col-12">
                <div class="featureIcon -type-1 d-flex">
                  <div class="featureIcon__icon size-50">
                    <img src="/img/icons/1/hot-air-balloon.svg" alt="icon">
                  </div>

                  <div class="ml-30">
                    <h3 class="featureIcon__title text-18 fw-500"><?php echo e(__('strings.Memorable experiences')); ?></h3>
                    <p class="featureIcon__text mt-10"><?php echo e(__('strings.Txt Memorable experiences')); ?></p>
                  </div>
                </div>
              </div>

              <div class="col-12">
                <div class="featureIcon -type-1 d-flex">
                  <div class="featureIcon__icon size-50">
                    <img src="/img/icons/1/diamond.svg" alt="icon">
                  </div>

                  <div class="ml-30">
                    <h3 class="featureIcon__title text-18 fw-500"><?php echo e(__('strings.Our Travel Reviews')); ?></h3>
                    <p class="featureIcon__text mt-10"><?php echo e(__('strings.Txt Our Travel Reviews')); ?></p>
                  </div>
                </div>
              </div>

            </div>
          </div>
        </div>
      </div>
    </section>
    <section class="layout-pt-xl">
      <div data-anim-wrap class="container">
        <div data-anim-child="slide-up" class="row y-gap-10 justify-between items-center y-gap-10">
          <div class="col-auto">
            <h2 class="text-30 md:text-24">
            <?php echo e(__('strings.Tour Packages')); ?>

            </h2>
          </div>
        </div>

        <div data-anim-child="slide-up delay-2" class="row y-gap-30 pt-40 sm:pt-20">
        <?php if(!empty($packages)): ?>
					<?php $__currentLoopData = $packages; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $package): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
          <div class="col-lg-3 col-md-6">
            <a href="/detail/<?php echo str_replace(' ', '-', $package->name); ?>" class="tourCard -type-1 d-block border-1 bg-white hover-shadow-1 overflow-hidden rounded-12 bg-white -hover-shadow">
              <div class="tourCard__header">
                <div class="tourCard__image ratio ratio-28:20">
                <?php
                    // Get the file path and extension
                    $imagePath = $package->pictures; // Assuming the image path is stored in the file_path attribute
                    $extension = pathinfo($imagePath, PATHINFO_EXTENSION);
                    
                    // Add text before the extension
                    $modifiedImagePath = preg_replace('/\.' . $extension . '$/', '-cropped.' . $extension, $imagePath);
                ?>
									<img src="<?php echo e(asset('/storage/' . $modifiedImagePath)); ?>" decoding="async" alt="<?php echo e($package->name); ?>" title="<?php echo e($package->name); ?>" class="img-ratio">
                </div>

                <button class="tourCard__favorite">
                  <i class="icon-heart"></i>
                </button>
              </div>

              <div class="tourCard__content px-20 py-10">
                <div class="tourCard__location d-flex items-center text-13 text-light-2">
                  <i class="icon-pin d-flex text-16 text-light-2 mr-5"></i>
                  Paris, France
                </div>

                <h3 class="tourCard__title text-16 fw-500 mt-5">
                  <span>
                  <?php if(Session()->has('lang')): ?>
                      <?php if(Session('lang') === 'fr'): ?>
                          <?php echo e($package->name_fr); ?>

                      <?php elseif(Session('lang') === 'es'): ?>
                          <?php echo e($package->name_es); ?>

                      <?php else: ?>
                          <?php echo e($package->name); ?>

                      <?php endif; ?>
                  <?php else: ?>
                  <?php echo e($package->name); ?>

                  <?php endif; ?>
                  </span>
                </h3>
                <div class="tourCard__rating text-13 mt-5">
                  <div class="d-flex items-center">
                    <div class="d-flex x-gap-5">

                      <div><i class="icon-star text-10 text-yellow-2"></i></div>

                      <div><i class="icon-star text-10 text-yellow-2"></i></div>

                      <div><i class="icon-star text-10 text-yellow-2"></i></div>

                      <div><i class="icon-star text-10 text-yellow-2"></i></div>

                      <div><i class="icon-star text-10 text-yellow-2"></i></div>

                    </div>

                    <span class="text-dark-1 ml-10">4.8 (269)</span>
                  </div>
                </div>

                <div class="d-flex justify-between items-center border-1-top text-13 text-dark-1 pt-10 mt-10">
                  <div class="d-flex items-center">
                    <i class="icon-clock text-16 mr-5"></i>
                    <?php echo e($package->days); ?> <?php echo e(__('strings.Days')); ?>

                  </div>

                  <div><?php echo e(__('strings.From')); ?> <span class="text-16 fw-500">$<?php echo e($package->price); ?></span></div>
                </div>
              </div>
            </a>
          </div>
          <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
					<?php endif; ?>  
        </div>
      </div>
    </section>
    <section class="layout-pt-xl layout-pb-xl">
      <div data-anim-wrap class="container">
        <div data-anim-child="slide-up" class="row justify-between items-end y-gap-10">
          <div class="col-auto">
            <h2 class="text-30 md:text-24"><?php echo e(__('strings.Everting you need to now')); ?></h2>
          </div>

          <div class="col-auto">

            <button class="buttonArrow d-flex items-center ">
              <span><?php echo e(__('strings.See all')); ?></span>
              <i class="icon-arrow-top-right text-16 ml-10"></i>
            </button>

          </div>
        </div>

        <div data-anim-child="slide-up delay-2" class="row y-gap-30 pt-40 sm:pt-20">
          <?php if(!empty($blogs)): ?>
					<?php $__currentLoopData = $blogs; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $article): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
          <div class="col-lg-4 col-md-6">
            <a href="/blog/<?php echo e($article->id); ?>-<?php echo str_replace(' ', '-', $article->title); ?>" class="blogCard -type-1">
              <div class="blogCard__image ratio ratio-41:30">
                <?php
                    // Get the file path and extension
                    $imagePath = $article->image; // Assuming the image path is stored in the file_path attribute
                    $extension = pathinfo($imagePath, PATHINFO_EXTENSION);
                    
                    // Add text before the extension
                    $modifiedImagePath = preg_replace('/\.' . $extension . '$/', '-cropped.' . $extension, $imagePath);
                ?>
                <img src="<?php echo e(asset('/storage/' . $modifiedImagePath)); ?>" decoding="async" alt="<?php echo e($article->name); ?>" title="<?php echo e($article->name); ?>" class="img-ratio rounded-12">
                <div class="blogCard__badge">Article</div>
              </div>

              <div class="blogCard__content mt-30">
                <div class="blogCard__info text-14">
                <?php
                    $originalDate = \Carbon\Carbon::parse($article->created_at);
                ?>
                  <div class="lh-13"><?php echo e($originalDate->format('F d Y')); ?></div>
                  <div class="blogCard__line"></div>
                  <div class="lh-13">Morocco Marrakech</div>
                </div>

                <h3 class="blogCard__title text-18 fw-500 mt-10"><?php echo e($article->title); ?></h3>
              </div>
            </a>
          </div>
          <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
          <?php endif; ?>

          <div class="col-lg-4 col-md-6">
            <a href="#" class="blogCard -type-1">
              <div class="blogCard__image ratio ratio-41:30">
                <img src="img/blogCards/1/2.png" alt="image" class="img-ratio rounded-12">

                <div class="blogCard__badge">Trips</div>
              </div>

              <div class="blogCard__content mt-30">
                <div class="blogCard__info text-14">
                  <div class="lh-13">April 06 2023</div>
                  <div class="blogCard__line"></div>
                  <div class="lh-13">By Ali Tufan</div>
                </div>

                <h3 class="blogCard__title text-18 fw-500 mt-10">Kenya vs Tanzania Safari: The Better African Safari Experience</h3>
              </div>
            </a>
          </div>

          <div class="col-lg-4 col-md-6">
            <a href="#" class="blogCard -type-1">
              <div class="blogCard__image ratio ratio-41:30">
                <img src="img/blogCards/1/3.png" alt="image" class="img-ratio rounded-12">

                <div class="blogCard__badge">Trips</div>
              </div>

              <div class="blogCard__content mt-30">
                <div class="blogCard__info text-14">
                  <div class="lh-13">April 06 2023</div>
                  <div class="blogCard__line"></div>
                  <div class="lh-13">By Ali Tufan</div>
                </div>

                <h3 class="blogCard__title text-18 fw-500 mt-10">Kenya vs Tanzania Safari: The Better African Safari Experience</h3>
              </div>
            </a>
          </div>

        </div>
      </div>
    </section>

    <section class="layout-pt-xl layout-pb-xl relative">
      <div class="sectionBg">
        <img src="img/cta/13/bg.jpg" alt="image" class="img-cover">
      </div>

      <div class="container">
        <div class="row">
          <div class="col-lg-5">
            <h2 class="text-30 text-white fw-700"><?php echo __('strings.Subscribe To'); ?></h2>
            <div class="singleInput type-1 mt-30">
              <input type="text" placeholder="Your email">
              <button class="button -md -dark-1 bg-white"><?php echo e(__('strings.Subscribe')); ?></button>
            </div>
          </div>
        </div>
      </div>
    </section>
    <?php echo $__env->make('layouts.footer', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
  </main>

  <!-- JavaScript -->
  <script src="https://maps.googleapis.com/maps/api/js?key=AIzaSyAAz77U5XQuEME6TpftaMdX0bBelQxXRlM"></script>
  <script src="../../../unpkg.com/%40googlemaps/markerclusterer%402.5.3/dist/index.min.js"></script>

  <script src="/js/vendors.js"></script>
  <script src="/js/main.js"></script>
</body>
</html><?php /**PATH C:\xampp\htdocs\projetAbdellah\resources\views/index.blade.php ENDPATH**/ ?>