<!DOCTYPE html>
<html lang="en" data-x="html" data-x-toggle="html-overflow-hidden">
<head>
  <!-- Required meta tags -->
  <meta charset="UTF-8">
  <meta name="viewport" content="width=device-width, initial-scale=1">

  <!-- Google fonts -->
  <link rel="preconnect" href="https://fonts.googleapis.com/">
  <link rel="preconnect" href="https://fonts.gstatic.com/" crossorigin>
  <link href="https://fonts.googleapis.com/css2?family=DM+Sans:ital,wght@0,400;0,500;0,700;1,400;1,500;1,700&amp;display=swap" rel="stylesheet">

  <!-- Stylesheets -->
  <link rel="stylesheet" href="/css/vendors.css">
  <link rel="stylesheet" href="/css/main.css">

  <title>Morocco Marrakech Tours</title>
</head>

<body>
  <?php echo $__env->make('layouts.header2', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
    <section data-anim="fade" class="hero -type-1 -min-2">
      <div class="hero__bg">
        <img src="<?php echo e(Voyager::image( $detail->image )); ?>" alt="image">
        <img src="/img/hero/1/shape.svg" alt="image">
      </div>

      <div class="container">
        <div class="row justify-center">
          <div class="col-xl-12">
            <div class="hero__content">
              <h1 class="hero__title">
                <?php echo e($detail->title); ?>

              </h1>
            </div>
          </div>
        </div>
      </div>
    </section>

    <section class="layout-pt-md layout-pb-xl">
      <div class="container">
        <div class="row y-gap-30 justify-center">
          <div class="col-lg-8">
            <p class="mt-20"><?php echo $detail->content; ?></p>
            <div class="row y-gap-15 justify-between items-center pt-20">
              <div class="col-auto">
                <div class="d-flex x-gap-10">
                  <div>
                    <a href="#" class="button -accent-1 size-40 flex-center bg-accent-1-05 rounded-full">
                      <i class="icon-facebook text-14"></i>
                    </a>
                  </div>
                  <div>
                    <a href="#" class="button -accent-1 size-40 flex-center bg-accent-1-05 rounded-full">
                      <i class="icon-twitter text-14"></i>
                    </a>
                  </div>
                  <div>
                    <a href="#" class="button -accent-1 size-40 flex-center bg-accent-1-05 rounded-full">
                      <i class="icon-instagram text-14"></i>
                    </a>
                  </div>
                  <div>
                    <a href="#" class="button -accent-1 size-40 flex-center bg-accent-1-05 rounded-full">
                      <i class="icon-linkedin text-14"></i>
                    </a>
                  </div>
                </div>
              </div>

              <div class="col-auto">
                <div class="d-flex x-gap-10">
                  <div>
                    <button class="button -accent-1 border-1 text-14 px-15 py-10 rounded-200">Advanture</button>
                  </div>
                  <div>
                    <button class="button -accent-1 border-1 text-14 px-15 py-10 rounded-200">Nature</button>
                  </div>
                  <div>
                    <button class="button -accent-1 border-1 text-14 px-15 py-10 rounded-200">Culture</button>
                  </div>
                </div>
              </div>
            </div>
          </div>
        </div>
      </div>
    </section>
    <?php echo $__env->make('layouts.footer', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
  </main>

  <!-- JavaScript -->
  <script src="https://maps.googleapis.com/maps/api/js?key=AIzaSyAAz77U5XQuEME6TpftaMdX0bBelQxXRlM"></script>
  <script src="../../../unpkg.com/%40googlemaps/markerclusterer%402.5.3/dist/index.min.js"></script>

  <script src="/js/vendors.js"></script>
  <script src="/js/main.js"></script>
</body>
</html><?php /**PATH C:\xampp\htdocs\projetAbdellah\resources\views/blog-details.blade.php ENDPATH**/ ?>