<!DOCTYPE html>
<html lang="en" data-x="html" data-x-toggle="html-overflow-hidden">
<head>
  <!-- Required meta tags -->
  <meta charset="UTF-8">
  <meta name="viewport" content="width=device-width, initial-scale=1">

  <!-- Google fonts -->
  <link rel="preconnect" href="https://fonts.googleapis.com/">
  <link rel="preconnect" href="https://fonts.gstatic.com/" crossorigin>
  <link href="https://fonts.googleapis.com/css2?family=DM+Sans:ital,wght@0,400;0,500;0,700;1,400;1,500;1,700&amp;display=swap" rel="stylesheet">
  <link href="/img/favicon-moroccomarakech-travel.png" rel="shortcut icon" type="image/x-icon">

  <!-- Stylesheets -->
  <link rel="stylesheet" href="/css/vendors.css">
  <link rel="stylesheet" href="/css/main.css">
  <link rel="stylesheet" href="/css/style.css">
  <title>Morocco Marrakech Travel</title>
  <meta name="description" content="Morocco Marrakech Travel, your premier travel agency dedicated to providing unforgettable experiences in the enchanting land of Morocco we specialize in crafting personalized itineraries that showcase...">
  <meta property="og:title" content="Morocco Marrakech Travel">
  <meta property="og:description" content="Morocco Marrakech Travel, your premier travel agency dedicated to providing unforgettable experiences in the enchanting land of Morocco. Nestled in the heart of Marrakech we specialize in crafting personalized itineraries that showcase...">
  <meta property="og:type" content="article">
  <meta property="og:url" content="http://www.discovermorocco-tours.com/">
  <meta property="og:image" content="https://moroccomarrakechtravel.com/img/general/logo%20morocco%20marrakech%20travel.svg">
  <meta property="og:site_name" content="Morocco Marrakech Travel">
  <meta name="keywords" content="Morocco Marrakech Travel, Morocco Tours , Best Morocco tour companies, Marrakech  Day Trips, Morocco Private Tours, Desert Tours, Marrakech  Desert  Tours, Morocco Sahara Tours, sahara Trips, Merzouga  Desert  Tours, Morocco Tours Packages, chafchaouen  day trip, Tours from Casablanca, Desert Tours from Fes">
  
  <style>
    h3.tourCard__title.text-16.fw-500.mt-5 {
        height: 50px;
    }
    
    @media only screen and (min-width: 700px) {
    .hero__bg.is-in-view {
        height: 622px;
    }
}
  </style>
<!-- Google tag (gtag.js) -->
<script async src="https://www.googletagmanager.com/gtag/js?id=G-ZKC9E0JDYY"></script>
<script>
  window.dataLayer = window.dataLayer || [];
  function gtag(){dataLayer.push(arguments);}
  gtag('js', new Date());

  gtag('config', 'G-G7V3W9R0EJ');
</script>
<script type="application/ld+json">
{
  "@context": "http://schema.org",
  "@type": "Morocco Marrakech Travel",
  "url": "https://www.moroccomarrakechtravel.com",
  "samwAs":[
    "https://www.instagram.com/morocco_marrakech_travel/"],
  "contactPoint": [{
    "@type": "Morocco Marrakech Travel",
    "telephone": "+212 613-399-383",
    "contactType": "Articles"
  }]
}
</script>
</head>

<body>
  <?php echo $__env->make('layouts.header', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
    <section data-anim-wrap class="hero -type-10">
      <div data-anim-child="fade" class="hero__bg">
        <img src="/img/background/Ouarzazate.webp" alt="background Morocco Marrakech Travel" title="background Morocco Marrakech Travel">
      </div>

      <div class="container">
        <div class="row justify-center text-center">
          <div class="col-xl-9 col-lg-10">
            <div class="hero__content">
              <h1 data-anim-child="slide-up delay-2" class="hero__title text-white">
                <?php echo __('strings.Choose Our Country'); ?>

              </h1>
            </div>
          </div>
        </div>
      </div>
    </section>

    <section class="layout-pt-xl">
      <div data-anim-wrap class="container">
        <div data-anim-child="slide-up" class="row y-gap-10 justify-between items-center y-gap-10">
          <div class="col-auto">
            <h2 class="text-30 md:text-24">
             <?php echo e(__('strings.Day trips from')); ?>

              <div class="dropdown -type-list js-dropdown js-form-dd" data-main-value="Mararkech">
                <div class=" text-light-7 js-button">
                  <span class="js-title" style="color: #ef7742;"><?php echo e(__('strings.Mararkech')); ?></span>
                  <i class="icon-chevron-down ml-5 text-18"></i>
                </div>
              </div>
            </h2>
          </div>
        </div>

        <div data-anim-child="slide-up delay-2" class="row y-gap-30 pt-40 sm:pt-20">
        <?php if(!empty($trips)): ?>
	        <?php $__currentLoopData = $trips; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $trip): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?> 
          <div class="col-lg-4 col-md-6">
            <a href="/detail/<?php echo str_replace(' ', '-', $trip->name); ?>" class="tourCard -type-1 d-block border-1 bg-white hover-shadow-1 overflow-hidden rounded-12 bg-white -hover-shadow">
              <div class="tourCard__header">
                <div class="tourCard__image ratio ratio-28:20">
                  <?php
                      // Get the file path and extension
                      $imagePath = $trip->pictures; // Assuming the image path is stored in the file_path attribute
                      $extension = pathinfo($imagePath, PATHINFO_EXTENSION);
                      
                      // Add text before the extension
                      $modifiedImagePath = preg_replace('/\.' . $extension . '$/', '-cropped.' . $extension, $imagePath);
                  ?>
                  <img src="<?php echo e(asset('https://moroccomarrakechtravel.com/moroccomarrakechtravelFinal/public/storage/' . $modifiedImagePath)); ?>" decoding="async" alt="<?php echo e($trip->name); ?>" title="<?php echo e($trip->name); ?>" class="img-ratio">
                </div>
              </div>

              <div class="tourCard__content px-20 py-10">

                <h3 class="tourCard__title text-16 fw-500 mt-5">
                  <span>
                  <?php if(Session()->has('lang')): ?>
                      <?php if(Session('lang') === 'fr'): ?>
                          <?php echo e($trip->name_fr); ?>

                      <?php elseif(Session('lang') === 'es'): ?>
                          <?php echo e($trip->name_es); ?>

                      <?php else: ?>
                          <?php echo e($trip->name); ?>

                      <?php endif; ?>
                  <?php else: ?>
                  <?php echo e($trip->name); ?>

                  <?php endif; ?>	
                  </span>
                </h3>



                <div class="d-flex justify-between items-center border-1-top text-13 text-dark-1 pt-10 mt-10">
                  <div class="d-flex items-center">
                    <i class="icon-clock text-16 mr-5"></i>
                    1 <?php echo e(__('strings.Day')); ?>

                  </div>

                  <div><?php echo e(__('strings.view more')); ?></div>
                </div>
              </div>
            </a>
          </div>
          <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
		  <?php endif; ?>  
        </div>
      </div>
    </section>
    <section class="layout-pt-xl layout-pb-xl bg-accent-1-05">
      <div data-anim-wrap="" class="container animated">
        <div class="tabs -pills-4 js-tabs">

          <div data-anim-child="slide-up delay-2" class="tabs__content pt-40 sm:pt-20 js-tabs-content is-in-view">

            <div class="tabs__pane -tab-item-1 is-tab-el-active">
              <div class="js-section-slider swiper-initialized swiper-horizontal swiper-pointer-events swiper-autoheight swiper-watch-progress swiper-backface-hidden" data-gap="30" data-slider-cols="xl-4 lg-3 md-2 sm-1 base-1" data-nav-prev="js-slider1-prev" data-nav-next="js-slider1-next">
                <div class="swiper-wrapper" id="swiper-wrapper-b23a497723be0bdb" aria-live="polite" style="height: 392px;">
                    <?php if(!empty($trips)): ?>
	                <?php $__currentLoopData = $trips; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $trip): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?> 
                  <div class="swiper-slide " style="width: 600px; margin-right: 30px;" role="group" aria-label="1 / 8">

                    <a href="" class="tourCard -type-1 -rounded bg-white hover-shadow-1 overflow-hidden rounded-20 bg-white -hover-shadow">
                      <div class="tourCard__header">
                        <div class="tourCard__image ratio ratio-28:20">
                                <?php
                          // Get the file path and extension
                          $imagePath = $trip->pictures; // Assuming the image path is stored in the file_path attribute
                          $extension = pathinfo($imagePath, PATHINFO_EXTENSION);
                          
                          // Add text before the extension
                          $modifiedImagePath = preg_replace('/\.' . $extension . '$/', '-cropped.' . $extension, $imagePath);
                      ?>
                      <img src="<?php echo e(asset('https://moroccomarrakechtravel.com/moroccomarrakechtravelFinal/public/storage/' . $modifiedImagePath)); ?>" decoding="async" alt="<?php echo e($trip->name); ?>" title="<?php echo e($trip->name); ?>" class="img-ratio">

                          <div class="tourCard__shape"></div>
                        </div>
                      </div>

                      <div class="tourCard__content px-20 py-10">
                        <h3 class="tourCard__title text-16 fw-500 mt-5">
                          <span>
                              <?php if(Session()->has('lang')): ?>
                                  <?php if(Session('lang') === 'fr'): ?>
                                      <?php echo e($trip->name_fr); ?>

                                  <?php elseif(Session('lang') === 'es'): ?>
                                      <?php echo e($trip->name_es); ?>

                                  <?php else: ?>
                                      <?php echo e($trip->name); ?>

                                  <?php endif; ?>
                              <?php else: ?>
                              <?php echo e($trip->name); ?>

                              <?php endif; ?>
                          </span>
                        </h3>
                        <div class="d-flex justify-between items-center border-1-top text-13 text-dark-1 pt-10 mt-10">
                          <div class="d-flex items-center">
                            <i class="icon-clock text-16 mr-5"></i>
                            1 <?php echo e(__('strings.Day')); ?>

                          </div>

                          <div><?php echo e(__('strings.view more')); ?></div>
                        </div>
                      </div>
                    </a>

                  </div>
                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
		            <?php endif; ?> 
                  
                </div>
              <span class="swiper-notification" aria-live="assertive" aria-atomic="true"></span></div>

              <div class="d-flex mt-40">
                <button class="button -dark-1 rounded-full size-72 flex-center bg-white js-slider1-prev" tabindex="0" aria-label="Previous slide" aria-controls="swiper-wrapper-33310f99f16f133aa" aria-disabled="false">
                  <i class="icon-arrow-left text-20"></i>
                </button>

                <button class="button -dark-1 rounded-full size-72 flex-center bg-white ml-10 js-slider1-next swiper-button-disabled" tabindex="-1" aria-label="Next slide" aria-controls="swiper-wrapper-33310f99f16f133aa" aria-disabled="true" disabled="">
                  <i class="icon-arrow-right text-20"></i>
                </button>
              </div>
            </div>
          </div>
        </div>
      </div>
    </section>
    <section class="layout-pt-xl layout-pb-xl bg-accent-1-05">
      <div data-anim-wrap class="container">
        <div class="row y-gap-30 items-center justify-between">
          <div data-anim-child="slide-up" class="col-xl-4 col-lg-5">
            <h2 class="text-30 md:text-24"><?php echo e(__('strings.Popular things to do')); ?></h2>

            <p class="mt-30 md:mt-10"><?php echo __('strings.Txt Popular things to do'); ?></p>

            <a href="/popullar-things-to-do-in-morocco" class="button -md -dark-1 bg-accent-1 text-white mt-30 md:mt-20">
              <?php echo e(__('strings.See All')); ?>

              <i class="icon-arrow-top-right ml-10"></i>
            </a>
          </div>

          <div data-anim-child="slide-up delay-2" class="col-xl-6 col-lg-7">
            <div class="row y-gap-30">

              <div class="col-md-4 col-6">
                <a href="https://moroccomarrakechtravel.com/detail/One-Day-Tour-Exploring-Marrakech" class="featureCard -type-5 -hover-accent-1">
                  <div class="featureCard__icon">
                    <img src="img/icons/5/1.svg" alt="City Tours Morocco Marrakech Travel" title="City Tours Morocco Marrakech Travel">
                  </div>

                  <h4 class="text-18 fw-500 mt-20"><?php echo e(__('strings.City Tours')); ?></h4>
                </a>
              </div>

              <div class="col-md-4 col-6">
                <a href="https://moroccomarrakechtravel.com/detail/9-days-8-nights-descovring-tour-frome-Marrakech" class="featureCard -type-5 -hover-accent-1">
                  <div class="featureCard__icon">
                    <img src="img/icons/5/2.svg" alt="Cultural Morocco Tours Morocco Marrakech Travel" title="Cultural Morocco Tours Morocco Marrakech Travel">
                  </div>

                  <h4 class="text-18 fw-500 mt-20"><?php echo e(__('strings.Cultural Morocco Tours')); ?></h4>
                </a>
              </div>

              <div class="col-md-4 col-6">
                <a href="https://moroccomarrakechtravel.com/detail/One-Day-Trip-from-Marrakech-to-Agadir" class="featureCard -type-5 -hover-accent-1">
                  <div class="featureCard__icon">
                    <img src="img/icons/5/3.svg" alt="Agadir Morocco Marrakech Travel" title="Agadir Morocco Marrakech Travel">
                  </div>

                  <h4 class="text-18 fw-500 mt-20"><?php echo e(__('strings.Agadir')); ?></h4>
                </a>
              </div>

              <div class="col-md-4 col-6">
                <a href="https://moroccomarrakechtravel.com/detail/One-Day-Trip-from-Marrakech-to-Essaouira" class="featureCard -type-5 -hover-accent-1">
                  <div class="featureCard__icon">
                    <img src="img/icons/5/4.svg" alt="Essaouira Morocco Marrakech Travel" title="Essaouira Morocco Marrakech Travel">
                  </div>

                  <h4 class="text-18 fw-500 mt-20"><?php echo e(__('strings.Essaouira')); ?></h4>
                </a>
              </div>

              <div class="col-md-4 col-6">
                <a href="https://moroccomarrakechtravel.com/detail/One-Day-Adventure-to-Oualidia-from-Marrakech" class="featureCard -type-5 -hover-accent-1">
                  <div class="featureCard__icon">
                    <img src="img/icons/5/5.svg" alt="Oualidia Morocco Marrakech Travel" title="Oualidia Morocco Marrakech Travel">
                  </div>

                  <h4 class="text-18 fw-500 mt-20"><?php echo e(__('strings.Oualidia')); ?></h4>
                </a>
              </div>

              <div class="col-md-4 col-6">
                <a href="https://moroccomarrakechtravel.com/detail/3-Days-2-nights-Trip-from-Marrakech-to-Merzouga-desert" class="featureCard -type-5 -hover-accent-1">
                  <div class="featureCard__icon">
                    <img src="img/icons/5/6.svg" alt="Marrakech Food Tour Morocco Marrakech Travel" title="Marrakech Food Tour Morocco Marrakech Travel">
                  </div>

                  <h4 class="text-18 fw-500 mt-20"><?php echo e(__('strings.Marrakech Food Tour')); ?></h4>
                </a>
              </div>

            </div>
          </div>
        </div>
      </div>
    </section>
    <section style="margin-top:120px" data-anim-wrap class="relative layout-pt-xl layout-pb-xl lg:pt-0">
      <div data-anim-child="slide-up delay-2" class="sectionBg -type-2">
        <div class="bg-accent-1-05 rounded-24"></div>
        <img src="/img/about/3/pexels-piotr-arnoldes-7862031-6302111.webp" alt="Why choose Morocco Marrakech Travel" class="rounded-24" title="Why choose Morocco Marrakech Travel">
      </div>

      <div class="container">
        <div data-anim-child="slide-up" class="row">
          <div class="col-xl-4 offset-xl-1 col-lg-5">
            <h2 class="text-30 md:text-24"><?php echo __('strings.Why choose'); ?></h2>

            <div class="row y-gap-30 pt-60 sm:pt-30">

              <div class="col-12">
                <div class="featureIcon -type-1 d-flex">
                  <div class="featureIcon__icon size-50">
                    <img src="/img/icons/1/ticket.svg" alt="icon Ultimate flexibility Morocco Marrakech Travel" title="icon Ultimate flexibility Morocco Marrakech Travel">
                  </div>

                  <div class="ml-30">
                    <h3 class="featureIcon__title text-18 fw-500"><?php echo e(__('strings.Ultimate flexibility')); ?></h3>
                    <p class="featureIcon__text mt-10"><?php echo e(__('strings.Txt Ultimate flexibility')); ?></p>
                  </div>
                </div>
              </div>

              <div class="col-12">
                <div class="featureIcon -type-1 d-flex">
                  <div class="featureIcon__icon size-50">
                    <img src="/img/icons/1/hot-air-balloon.svg" alt="icon Memorable experiences Morocco Marrakech Travel" title="icon Memorable experiences Morocco Marrakech Travel">
                  </div>

                  <div class="ml-30">
                    <h3 class="featureIcon__title text-18 fw-500"><?php echo e(__('strings.Memorable experiences')); ?></h3>
                    <p class="featureIcon__text mt-10"><?php echo e(__('strings.Txt Memorable experiences')); ?></p>
                  </div>
                </div>
              </div>

              <div class="col-12">
                <div class="featureIcon -type-1 d-flex">
                  <div class="featureIcon__icon size-50">
                    <img src="/img/icons/1/diamond.svg" alt="icon Our Travel Reviews Morocco Marrakech Travel" title="icon Our Travel Reviews Morocco Marrakech Travel">
                  </div>

                  <div class="ml-30">
                    <h3 class="featureIcon__title text-18 fw-500"><?php echo e(__('strings.Our Travel Reviews')); ?></h3>
                    <p class="featureIcon__text mt-10"><?php echo e(__('strings.Txt Our Travel Reviews')); ?></p>
                  </div>
                </div>
              </div>

            </div>
          </div>
        </div>
      </div>
    </section>
    <section class="layout-pt-xl">
      <div data-anim-wrap class="container">
        <div data-anim-child="slide-up" class="row y-gap-10 justify-between items-center y-gap-10">
          <div class="col-auto">
            <h2 class="text-30 md:text-24">
            <?php echo e(__('strings.Tour Packages')); ?>

            </h2>
          </div>
        </div>

        <div data-anim-child="slide-up delay-2" class="row y-gap-30 pt-40 sm:pt-20">
        <?php if(!empty($packages)): ?>
		<?php $__currentLoopData = $packages; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $package): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
          <div class="col-lg-4 col-md-6">
            <a href="/detail/<?php echo str_replace(' ', '-', $package->name); ?>" class="tourCard -type-1 d-block border-1 bg-white hover-shadow-1 overflow-hidden rounded-12 bg-white -hover-shadow">
              <div class="tourCard__header">
                <div class="tourCard__image ratio ratio-28:20">
                <?php
                    // Get the file path and extension
                    $imagePath = $package->pictures; // Assuming the image path is stored in the file_path attribute
                    $extension = pathinfo($imagePath, PATHINFO_EXTENSION);
                    
                    // Add text before the extension
                    $modifiedImagePath = preg_replace('/\.' . $extension . '$/', '-cropped.' . $extension, $imagePath);
                ?>
									<img src="<?php echo e(asset('https://moroccomarrakechtravel.com/moroccomarrakechtravelFinal/public/storage/' . $modifiedImagePath)); ?>" decoding="async" alt="<?php echo e($package->name); ?>" title="<?php echo e($package->name); ?>" class="img-ratio">
                </div>

              </div>

              <div class="tourCard__content px-20 py-10">

                <h3 class="tourCard__title text-16 fw-500 mt-5">
                  <span>
                  <?php if(Session()->has('lang')): ?>
                      <?php if(Session('lang') === 'fr'): ?>
                          <?php echo e($package->name_fr); ?>

                      <?php elseif(Session('lang') === 'es'): ?>
                          <?php echo e($package->name_es); ?>

                      <?php else: ?>
                          <?php echo e($package->name); ?>

                      <?php endif; ?>
                  <?php else: ?>
                  <?php echo e($package->name); ?>

                  <?php endif; ?>
                  </span>
                </h3>
                <div class="d-flex justify-between items-center border-1-top text-13 text-dark-1 pt-10 mt-10">
                  <div class="d-flex items-center">
                    <i class="icon-clock text-16 mr-5"></i>
                    <?php echo e($package->days); ?> <?php echo e(__('strings.Days')); ?>

                  </div>

                  <div><?php echo e(__('strings.view more')); ?></div>
                </div>
              </div>
            </a>
          </div>
          <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
					<?php endif; ?>  
        </div>
      </div>
    </section>
    <section class="layout-pt-xl layout-pb-xl">
      <div data-anim-wrap class="container">
        <div data-anim-child="slide-up" class="row justify-between items-end y-gap-10">
          <div class="col-auto">
            <h2 class="text-30 md:text-24"><?php echo e(__('strings.Everting you need to now')); ?></h2>
          </div>

          <div class="col-auto">

            <button class="buttonArrow d-flex items-center ">
              <span><?php echo e(__('strings.See All')); ?></span>
              <i class="icon-arrow-top-right text-16 ml-10"></i>
            </button>

          </div>
        </div>

        <div data-anim-child="slide-up delay-2" class="row y-gap-30 pt-40 sm:pt-20">
          <?php if(!empty($blogs)): ?>
					<?php $__currentLoopData = $blogs; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $article): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
          <div class="col-lg-4 col-md-6">
            <a href="/blog/<?php echo e($article->id); ?>-<?php echo str_replace(' ', '-', $article->title); ?>" class="blogCard -type-1">
              <div class="blogCard__image ratio ratio-41:30">
                <?php
                    // Get the file path and extension
                    $imagePath = $article->image; // Assuming the image path is stored in the file_path attribute
                    $extension = pathinfo($imagePath, PATHINFO_EXTENSION);
                    
                    // Add text before the extension
                    $modifiedImagePath = preg_replace('/\.' . $extension . '$/', '-cropped.' . $extension, $imagePath);
                ?>
                <img src="<?php echo e(asset('https://moroccomarrakechtravel.com/moroccomarrakechtravelFinal/public/storage/' . $modifiedImagePath)); ?>" decoding="async" alt="<?php echo e($article->title); ?>" title="<?php echo e($article->title); ?>" class="img-ratio rounded-12">
                <div class="blogCard__badge">Article</div>
              </div>

              <div class="blogCard__content mt-30">
                <div class="blogCard__info text-14">
                <?php
                    $originalDate = \Carbon\Carbon::parse($article->created_at);
                ?>
                  <div class="lh-13"><?php echo e($originalDate->format('F d Y')); ?></div>
                  <div class="blogCard__line"></div>
                  <div class="lh-13">Morocco Marrakech</div>
                </div>

                <h3 class="blogCard__title text-18 fw-500 mt-10"><?php echo e($article->title); ?></h3>
              </div>
            </a>
          </div>
          <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
          <?php endif; ?>
        </div>
      </div>
    </section>

    <section class="layout-pt-xl layout-pb-xl relative">
      <div class="sectionBg">
        <img src="img/cta/13/bg.webp" alt="Subscribe To Morocco Marrakech Travel" title="Subscribe To Morocco Marrakech Travel" class="img-cover">
      </div>

      <div class="container">
        <div class="row">
          <div class="col-lg-5">
            <h2 class="text-30 text-white fw-700"><?php echo __('strings.Subscribe To'); ?></h2>
            <div class="singleInput type-1 mt-30">
              <input type="text" placeholder="Your email">
              <button class="button -md -dark-1 bg-white"><?php echo e(__('strings.Subscribe')); ?></button>
            </div>
          </div>
        </div>
      </div>
    </section>
    <?php echo $__env->make('layouts.footer', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
  </main>

  <!-- JavaScript -->
  <script src="https://maps.googleapis.com/maps/api/js?key=AIzaSyAAz77U5XQuEME6TpftaMdX0bBelQxXRlM"></script>
  <script src="/js/vendors.js"></script>
  <script src="/js/main.js"></script>
</body>
</html><?php /**PATH /home/chofxqkp/moroccomarrakechtravel.com/moroccomarrakechtravelFinal/resources/views/index2.blade.php ENDPATH**/ ?>