<!DOCTYPE html>
<html lang="en" data-x="html" data-x-toggle="html-overflow-hidden">
<head>
  <!-- Required meta tags -->
  <meta charset="UTF-8">
  <meta name="viewport" content="width=device-width, initial-scale=1">

  <!-- Google fonts -->
  <link rel="preconnect" href="https://fonts.googleapis.com/">
  <link rel="preconnect" href="https://fonts.gstatic.com/" crossorigin>
  <link href="https://fonts.googleapis.com/css2?family=DM+Sans:ital,wght@0,400;0,500;0,700;1,400;1,500;1,700&amp;display=swap" rel="stylesheet">

  <!-- Stylesheets -->
  <link rel="stylesheet" href="css/vendors.css">
  <link rel="stylesheet" href="css/main.css">

  <title>Contact Morocco Marrakech Tours</title>
  <style>
    .custom-alert-success {
        background-color: #d4edda;
        color: #155724;
        border: 1px solid #c3e6cb;
        padding: 10px 15px;
        border-radius: 4px;
        position: relative;
        margin-bottom: 1rem;
    }

    .custom-alert-success .close-btn {
        position: absolute;
        top: 10px;
        right: 15px;
        background: transparent;
        border: none;
        font-size: 16px;
        cursor: pointer;
    }

    .custom-alert-success .close-btn:focus {
        outline: none;
    }
</style>
<script src="https://www.google.com/recaptcha/api.js?render=<?php echo e(env('RECAPTCHA_SITE_KEY')); ?>"></script>


</head>

<body>
  <?php echo $__env->make('layouts.header2', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
    <div data-anim="fade" class="map relative mt-header ml-60 mr-60 md:ml-0 md:mr-0">

      <iframe src="https://www.google.com/maps/embed?pb=!1m18!1m12!1m3!1d13588.234530091742!2d-8.0232381945098!3d31.632244986603453!2m3!1f0!2f0!3f0!3m2!1i1024!2i768!4f13.1!3m3!1m2!1s0xdafee8d931f3209%3A0x96ce34d39325c762!2sGu%C3%A9liz%2C%20Marrakech%2040000!5e0!3m2!1sfr!2sma!4v1721485880027!5m2!1sfr!2sma" width="100%" height="450" style="border:0;" allowfullscreen="" loading="lazy" referrerpolicy="no-referrer-when-downgrade"></iframe>
    </div>
    <section data-anim="fade" class="layout-pt-lg layout-pb-lg">
      <div class="container">
        <div class="row justify-center">
          <div class="col-lg-8">
            <h2 class="text-30 fw-700 text-center mb-30"><?php echo e(__('strings.Leave us your info')); ?></h2>
            <?php if(session('success')): ?>
              <div class="custom-alert-success">
                  <?php echo e(session('success')); ?>

                  <button class="close-btn" onclick="this.parentElement.style.display='none';">&times;</button>
              </div>
            <?php endif; ?>
            <div class="contactForm">
              <form action="" method="POST">
                <?php echo csrf_field(); ?>
                <div class="row y-gap-30">
                  <div class="col-md-6"> 
                    <input type="text" placeholder="<?php echo e(__('strings.Full Name')); ?>" name="name">
                    <?php $__errorArgs = ['name'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                      <div class="alert alert-danger"><?php echo e($message); ?></div>
                    <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
                  </div>
                  <div class="col-md-6">
                    <input type="text" placeholder="<?php echo e(__('strings.Phone')); ?>" name="phone">
                    <?php $__errorArgs = ['phone'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                      <div class="alert alert-danger"><?php echo e($message); ?></div>
                    <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
                  </div>
                  <div class="col-12">
                    <input type="text" placeholder="<?php echo e(__('strings.Email')); ?>" name="email">
                    <?php $__errorArgs = ['email'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                      <div class="alert alert-danger"><?php echo e($message); ?></div>
                    <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
                  </div>
                  <div class="col-12">
                    <textarea placeholder="Message" rows="6" name="message"><?php echo e(__('strings.Message')); ?></textarea>
                    <?php $__errorArgs = ['email'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                      <div class="alert alert-danger"><?php echo e($message); ?></div>
                    <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
                  </div>
                  <div class="col-12">
                    <!-- reCAPTCHA Token -->
                    <input type="hidden" name="g-recaptcha-response" id="recaptchaToken">

                    <!-- Display Validation Error for reCAPTCHA -->
                    <?php if($errors->has('g-recaptcha-response')): ?>
                        <div class="alert alert-danger">
                            <?php echo e($errors->first('g-recaptcha-response')); ?>

                        </div>
                    <?php endif; ?>
                  </div>
                  
                  <div class="col-12">
                    <button type="submit" class="button -md -dark-1 bg-accent-1 text-white col-12"><?php echo e(__('strings.Send Message')); ?></button>
                  </div>
                </div>
              </form>
              <script>
    grecaptcha.ready(function() {
        grecaptcha.execute('<?php echo e(env("RECAPTCHA_SITE_KEY")); ?>', {action: 'submit'}).then(function(token) {
            document.getElementById('recaptchaToken').value = token;
        });
    });
</script>
            </div>
          </div>
        </div>
      </div>
    </section>
    <?php echo $__env->make('layouts.footer', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
  </main>
  <!-- JavaScript -->
  <script src="https://maps.googleapis.com/maps/api/js?key=AIzaSyAAz77U5XQuEME6TpftaMdX0bBelQxXRlM"></script>

  <script src="/js/vendors.js"></script>
  <script src="/js/main.js"></script>
</body>
</html><?php /**PATH C:\xampp\htdocs\moroccomarrakechtravelFinal\resources\views/contact.blade.php ENDPATH**/ ?>