<!doctype html>
<html lang="en-US" data-bs-theme="light">
    <meta http-equiv="content-type" content="text/html;charset=UTF-8" />
    <head>
        <meta charset="UTF-8">
        <meta name="viewport" content="width=device-width, initial-scale=1">
        <link rel="profile" href="https://gmpg.org/xfn/11">
        <title><?php echo e($detail->name); ?> - Moroccan Trip</title>
        <meta name='robots' content='max-image-preview:large' />
        <style>img:is([sizes="auto" i], [sizes^="auto," i]) { contain-intrinsic-size: 3000px 1500px }</style>
        <style id='classic-theme-styles-inline-css' type='text/css'>
        /*! This file is auto-generated */
        .wp-block-button__link{color:#fff;background-color:#32373c;border-radius:9999px;box-shadow:none;text-decoration:none;padding:calc(.667em + 2px) calc(1.333em + 2px);font-size:1.125em}.wp-block-file__button{background:#32373c;color:#fff;text-decoration:none}
        </style>
        <style id='global-styles-inline-css' type='text/css'>
        :root{--wp--preset--aspect-ratio--square: 1;--wp--preset--aspect-ratio--4-3: 4/3;--wp--preset--aspect-ratio--3-4: 3/4;--wp--preset--aspect-ratio--3-2: 3/2;--wp--preset--aspect-ratio--2-3: 2/3;--wp--preset--aspect-ratio--16-9: 16/9;--wp--preset--aspect-ratio--9-16: 9/16;--wp--preset--color--black: #000000;--wp--preset--color--cyan-bluish-gray: #abb8c3;--wp--preset--color--white: #ffffff;--wp--preset--color--pale-pink: #f78da7;--wp--preset--color--vivid-red: #cf2e2e;--wp--preset--color--luminous-vivid-orange: #ff6900;--wp--preset--color--luminous-vivid-amber: #fcb900;--wp--preset--color--light-green-cyan: #7bdcb5;--wp--preset--color--vivid-green-cyan: #00d084;--wp--preset--color--pale-cyan-blue: #8ed1fc;--wp--preset--color--vivid-cyan-blue: #0693e3;--wp--preset--color--vivid-purple: #9b51e0;--wp--preset--gradient--vivid-cyan-blue-to-vivid-purple: linear-gradient(135deg,rgba(6,147,227,1) 0%,rgb(155,81,224) 100%);--wp--preset--gradient--light-green-cyan-to-vivid-green-cyan: linear-gradient(135deg,rgb(122,220,180) 0%,rgb(0,208,130) 100%);--wp--preset--gradient--luminous-vivid-amber-to-luminous-vivid-orange: linear-gradient(135deg,rgba(252,185,0,1) 0%,rgba(255,105,0,1) 100%);--wp--preset--gradient--luminous-vivid-orange-to-vivid-red: linear-gradient(135deg,rgba(255,105,0,1) 0%,rgb(207,46,46) 100%);--wp--preset--gradient--very-light-gray-to-cyan-bluish-gray: linear-gradient(135deg,rgb(238,238,238) 0%,rgb(169,184,195) 100%);--wp--preset--gradient--cool-to-warm-spectrum: linear-gradient(135deg,rgb(74,234,220) 0%,rgb(151,120,209) 20%,rgb(207,42,186) 40%,rgb(238,44,130) 60%,rgb(251,105,98) 80%,rgb(254,248,76) 100%);--wp--preset--gradient--blush-light-purple: linear-gradient(135deg,rgb(255,206,236) 0%,rgb(152,150,240) 100%);--wp--preset--gradient--blush-bordeaux: linear-gradient(135deg,rgb(254,205,165) 0%,rgb(254,45,45) 50%,rgb(107,0,62) 100%);--wp--preset--gradient--luminous-dusk: linear-gradient(135deg,rgb(255,203,112) 0%,rgb(199,81,192) 50%,rgb(65,88,208) 100%);--wp--preset--gradient--pale-ocean: linear-gradient(135deg,rgb(255,245,203) 0%,rgb(182,227,212) 50%,rgb(51,167,181) 100%);--wp--preset--gradient--electric-grass: linear-gradient(135deg,rgb(202,248,128) 0%,rgb(113,206,126) 100%);--wp--preset--gradient--midnight: linear-gradient(135deg,rgb(2,3,129) 0%,rgb(40,116,252) 100%);--wp--preset--font-size--small: 13px;--wp--preset--font-size--medium: 20px;--wp--preset--font-size--large: 36px;--wp--preset--font-size--x-large: 42px;--wp--preset--spacing--20: 0.44rem;--wp--preset--spacing--30: 0.67rem;--wp--preset--spacing--40: 1rem;--wp--preset--spacing--50: 1.5rem;--wp--preset--spacing--60: 2.25rem;--wp--preset--spacing--70: 3.38rem;--wp--preset--spacing--80: 5.06rem;--wp--preset--shadow--natural: 6px 6px 9px rgba(0, 0, 0, 0.2);--wp--preset--shadow--deep: 12px 12px 50px rgba(0, 0, 0, 0.4);--wp--preset--shadow--sharp: 6px 6px 0px rgba(0, 0, 0, 0.2);--wp--preset--shadow--outlined: 6px 6px 0px -3px rgba(255, 255, 255, 1), 6px 6px rgba(0, 0, 0, 1);--wp--preset--shadow--crisp: 6px 6px 0px rgba(0, 0, 0, 1);}:where(.is-layout-flex){gap: 0.5em;}:where(.is-layout-grid){gap: 0.5em;}body .is-layout-flex{display: flex;}.is-layout-flex{flex-wrap: wrap;align-items: center;}.is-layout-flex > :is(*, div){margin: 0;}body .is-layout-grid{display: grid;}.is-layout-grid > :is(*, div){margin: 0;}:where(.wp-block-columns.is-layout-flex){gap: 2em;}:where(.wp-block-columns.is-layout-grid){gap: 2em;}:where(.wp-block-post-template.is-layout-flex){gap: 1.25em;}:where(.wp-block-post-template.is-layout-grid){gap: 1.25em;}.has-black-color{color: var(--wp--preset--color--black) !important;}.has-cyan-bluish-gray-color{color: var(--wp--preset--color--cyan-bluish-gray) !important;}.has-white-color{color: var(--wp--preset--color--white) !important;}.has-pale-pink-color{color: var(--wp--preset--color--pale-pink) !important;}.has-vivid-red-color{color: var(--wp--preset--color--vivid-red) !important;}.has-luminous-vivid-orange-color{color: var(--wp--preset--color--luminous-vivid-orange) !important;}.has-luminous-vivid-amber-color{color: var(--wp--preset--color--luminous-vivid-amber) !important;}.has-light-green-cyan-color{color: var(--wp--preset--color--light-green-cyan) !important;}.has-vivid-green-cyan-color{color: var(--wp--preset--color--vivid-green-cyan) !important;}.has-pale-cyan-blue-color{color: var(--wp--preset--color--pale-cyan-blue) !important;}.has-vivid-cyan-blue-color{color: var(--wp--preset--color--vivid-cyan-blue) !important;}.has-vivid-purple-color{color: var(--wp--preset--color--vivid-purple) !important;}.has-black-background-color{background-color: var(--wp--preset--color--black) !important;}.has-cyan-bluish-gray-background-color{background-color: var(--wp--preset--color--cyan-bluish-gray) !important;}.has-white-background-color{background-color: var(--wp--preset--color--white) !important;}.has-pale-pink-background-color{background-color: var(--wp--preset--color--pale-pink) !important;}.has-vivid-red-background-color{background-color: var(--wp--preset--color--vivid-red) !important;}.has-luminous-vivid-orange-background-color{background-color: var(--wp--preset--color--luminous-vivid-orange) !important;}.has-luminous-vivid-amber-background-color{background-color: var(--wp--preset--color--luminous-vivid-amber) !important;}.has-light-green-cyan-background-color{background-color: var(--wp--preset--color--light-green-cyan) !important;}.has-vivid-green-cyan-background-color{background-color: var(--wp--preset--color--vivid-green-cyan) !important;}.has-pale-cyan-blue-background-color{background-color: var(--wp--preset--color--pale-cyan-blue) !important;}.has-vivid-cyan-blue-background-color{background-color: var(--wp--preset--color--vivid-cyan-blue) !important;}.has-vivid-purple-background-color{background-color: var(--wp--preset--color--vivid-purple) !important;}.has-black-border-color{border-color: var(--wp--preset--color--black) !important;}.has-cyan-bluish-gray-border-color{border-color: var(--wp--preset--color--cyan-bluish-gray) !important;}.has-white-border-color{border-color: var(--wp--preset--color--white) !important;}.has-pale-pink-border-color{border-color: var(--wp--preset--color--pale-pink) !important;}.has-vivid-red-border-color{border-color: var(--wp--preset--color--vivid-red) !important;}.has-luminous-vivid-orange-border-color{border-color: var(--wp--preset--color--luminous-vivid-orange) !important;}.has-luminous-vivid-amber-border-color{border-color: var(--wp--preset--color--luminous-vivid-amber) !important;}.has-light-green-cyan-border-color{border-color: var(--wp--preset--color--light-green-cyan) !important;}.has-vivid-green-cyan-border-color{border-color: var(--wp--preset--color--vivid-green-cyan) !important;}.has-pale-cyan-blue-border-color{border-color: var(--wp--preset--color--pale-cyan-blue) !important;}.has-vivid-cyan-blue-border-color{border-color: var(--wp--preset--color--vivid-cyan-blue) !important;}.has-vivid-purple-border-color{border-color: var(--wp--preset--color--vivid-purple) !important;}.has-vivid-cyan-blue-to-vivid-purple-gradient-background{background: var(--wp--preset--gradient--vivid-cyan-blue-to-vivid-purple) !important;}.has-light-green-cyan-to-vivid-green-cyan-gradient-background{background: var(--wp--preset--gradient--light-green-cyan-to-vivid-green-cyan) !important;}.has-luminous-vivid-amber-to-luminous-vivid-orange-gradient-background{background: var(--wp--preset--gradient--luminous-vivid-amber-to-luminous-vivid-orange) !important;}.has-luminous-vivid-orange-to-vivid-red-gradient-background{background: var(--wp--preset--gradient--luminous-vivid-orange-to-vivid-red) !important;}.has-very-light-gray-to-cyan-bluish-gray-gradient-background{background: var(--wp--preset--gradient--very-light-gray-to-cyan-bluish-gray) !important;}.has-cool-to-warm-spectrum-gradient-background{background: var(--wp--preset--gradient--cool-to-warm-spectrum) !important;}.has-blush-light-purple-gradient-background{background: var(--wp--preset--gradient--blush-light-purple) !important;}.has-blush-bordeaux-gradient-background{background: var(--wp--preset--gradient--blush-bordeaux) !important;}.has-luminous-dusk-gradient-background{background: var(--wp--preset--gradient--luminous-dusk) !important;}.has-pale-ocean-gradient-background{background: var(--wp--preset--gradient--pale-ocean) !important;}.has-electric-grass-gradient-background{background: var(--wp--preset--gradient--electric-grass) !important;}.has-midnight-gradient-background{background: var(--wp--preset--gradient--midnight) !important;}.has-small-font-size{font-size: var(--wp--preset--font-size--small) !important;}.has-medium-font-size{font-size: var(--wp--preset--font-size--medium) !important;}.has-large-font-size{font-size: var(--wp--preset--font-size--large) !important;}.has-x-large-font-size{font-size: var(--wp--preset--font-size--x-large) !important;}
        :where(.wp-block-post-template.is-layout-flex){gap: 1.25em;}:where(.wp-block-post-template.is-layout-grid){gap: 1.25em;}
        :where(.wp-block-columns.is-layout-flex){gap: 2em;}:where(.wp-block-columns.is-layout-grid){gap: 2em;}
        :root :where(.wp-block-pullquote){font-size: 1.5em;line-height: 1.6;}
        </style>
        <link rel='stylesheet' id='babe-ion-rangeslider-css-css' href='/wp-content/plugins/ba-book-everything/js/ion.rangeSlider/ion.rangeSlider.mind584.css?ver=1.7.12' type='text/css' media='all' />
        <link rel='stylesheet' id='babe-daterangepicker-style-css' href='/wp-content/plugins/ba-book-everything/css/daterangepickerd584.css?ver=1.7.12' type='text/css' media='all' />
        <link rel='stylesheet' id='babe-select2-style-css' href='/wp-content/plugins/ba-book-everything/css/select2.mind584.css?ver=1.7.12' type='text/css' media='all' />
        <link rel='stylesheet' id='babe-modal-style-css' href='/wp-content/plugins/ba-book-everything/css/babe-modald584.css?ver=1.7.12' type='text/css' media='all' />
        <link rel='stylesheet' id='jquery-ui-style-css' href='/wp-content/plugins/ba-book-everything/css/jquery-ui.mind584.css?ver=1.7.12' type='text/css' media='all' />
        <link rel='stylesheet' id='babe-fontawesome-css' href='/wp-content/plugins/ba-book-everything/fonts/fontawesome-free/css/all.mind584.css?ver=1.7.12' type='text/css' media='all' />
        <link rel='stylesheet' id='babe-style-css' href='/wp-content/plugins/ba-book-everything/css/babe-styled584.css?ver=1.7.12' type='text/css' media='all' />
        <link rel='stylesheet' id='contact-form-7-css' href='/wp-content/plugins/contact-form-7/includes/css/stylesf049.css?ver=6.0' type='text/css' media='all' />
        <link rel='stylesheet' id='travila-icon-css' href='/wp-content/plugins/travila-core/assets/css/feather5152.css?ver=1.0' type='text/css' media='all' />
        <link rel='stylesheet' id='travila-custom-css' href='/wp-content/themes/travila/assets/css/travila-custom9704.css?ver=6.7.1' type='text/css' media='all' />
        <style id='travila-custom-inline-css' type='text/css'>
        html:root { --bs-warning: #F09814}html:root { --unit-primary-color: #F09814}
        html:root { --bs-brand-secondary: #FEFA17}
        </style>
        <link rel='stylesheet' id='travila-fonts-css' href='/wp-content/themes/travila/assets/css/travila-fonts9704.css?ver=6.7.1' type='text/css' media='all' />
        <link rel='stylesheet' id='bootstrap-css' href='/wp-content/themes/travila/assets/css/bootstrap.min9704.css?ver=6.7.1' type='text/css' media='all' />
        <link rel='stylesheet' id='travila-normalize-css' href='/wp-content/themes/travila/assets/css/normalize9704.css?ver=6.7.1' type='text/css' media='all' />
        <link rel='stylesheet' id='font-awesome-free-css' href='/wp-content/themes/travila/assets/css/fontawesome-all.min9704.css?ver=6.7.1' type='text/css' media='all' />
        <link rel='stylesheet' id='uicons-css' href='/wp-content/themes/travila/assets/css/uicons-regular-rounded9704.css?ver=6.7.1' type='text/css' media='all' />
        <link rel='stylesheet' id='swiper-bundle-css' href='/wp-content/themes/travila/assets/css/swiper-bundle.min9704.css?ver=6.7.1' type='text/css' media='all' />
        <link rel='stylesheet' id='magnific-popup-css' href='/wp-content/themes/travila/assets/css/magnific-popup9704.css?ver=6.7.1' type='text/css' media='all' />
        <link rel='stylesheet' id='travila-animate-css' href='/wp-content/themes/travila/assets/css/animate9704.css?ver=6.7.1' type='text/css' media='all' />
        <link rel='stylesheet' id='select2-css' href='/wp-content/themes/travila/assets/css/select2.min9704.css?ver=6.7.1' type='text/css' media='all' />
        <link rel='stylesheet' id='perfect-scrollbar-css' href='/wp-content/themes/travila/assets/css/perfect-scrollbar9704.css?ver=6.7.1' type='text/css' media='all' />
        <link rel='stylesheet' id='carouselTicker-css' href='/wp-content/themes/travila/assets/css/carouselTicker9704.css?ver=6.7.1' type='text/css' media='all' />
        <link rel='stylesheet' id='bootstrap-datepicker3-css' href='/wp-content/themes/travila/assets/css/bootstrap-datepicker39704.css?ver=6.7.1' type='text/css' media='all' />
        <link rel='stylesheet' id='slick-css' href='/wp-content/themes/travila/assets/css/slick9704.css?ver=6.7.1' type='text/css' media='all' />
        <link rel='stylesheet' id='travila-core-css' href='/wp-content/themes/travila/assets/css/travila-core9704.css?ver=6.7.1' type='text/css' media='all' />
        <link rel='stylesheet' id='travila-unit-css' href='/wp-content/themes/travila/assets/css/travila-unit9704.css?ver=6.7.1' type='text/css' media='all' />
        <link rel='stylesheet' id='travila-style-css' href='/wp-content/themes/travila/style9704.css?ver=6.7.1' type='text/css' media='all' />
        <link rel='stylesheet' id='elementor-icons-css' href='/wp-content/plugins/elementor/assets/lib/eicons/css/elementor-icons.min0fd8.css?ver=5.31.0' type='text/css' media='all' />
        <link rel='stylesheet' id='elementor-frontend-css' href='/wp-content/uploads/elementor/css/custom-frontend.min6c69.css?ver=1732681890' type='text/css' media='all' />
        <link rel='stylesheet' id='swiper-css' href='/wp-content/plugins/elementor/assets/lib/swiper/v8/css/swiper.min94a4.css?ver=8.4.5' type='text/css' media='all' />
        <link rel='stylesheet' id='e-swiper-css' href='/wp-content/plugins/elementor/assets/css/conditionals/e-swiper.min401f.css?ver=3.25.4' type='text/css' media='all' />
        <link rel='stylesheet' id='elementor-post-11-css' href='/wp-content/uploads/elementor/css/post-116c69.css?ver=1732681890' type='text/css' media='all' />
        <link rel='stylesheet' id='widget-image-css' href='/wp-content/plugins/elementor/assets/css/widget-image.min401f.css?ver=3.25.4' type='text/css' media='all' />
        <link rel='stylesheet' id='widget-icon-list-css' href='/wp-content/uploads/elementor/css/custom-widget-icon-list.min6c69.css?ver=1732681890' type='text/css' media='all' />
        <link rel='stylesheet' id='elementor-post-824-css' href='/wp-content/uploads/elementor/css/post-824a5e2.css?ver=1732758408' type='text/css' media='all' />
        <link rel='stylesheet' id='google-fonts-1-css' href='https://fonts.googleapis.com/css?family=Roboto%3A100%2C100italic%2C200%2C200italic%2C300%2C300italic%2C400%2C400italic%2C500%2C500italic%2C600%2C600italic%2C700%2C700italic%2C800%2C800italic%2C900%2C900italic%7CRoboto+Slab%3A100%2C100italic%2C200%2C200italic%2C300%2C300italic%2C400%2C400italic%2C500%2C500italic%2C600%2C600italic%2C700%2C700italic%2C800%2C800italic%2C900%2C900italic%7CManrope%3A100%2C100italic%2C200%2C200italic%2C300%2C300italic%2C400%2C400italic%2C500%2C500italic%2C600%2C600italic%2C700%2C700italic%2C800%2C800italic%2C900%2C900italic&amp;display=swap&amp;ver=6.7.1' type='text/css' media='all' />
        <link rel="preconnect" href="https://fonts.gstatic.com/" crossorigin><script type="text/javascript" src="/wp-includes/js/jquery/jquery.minf43b.js?ver=3.7.1" id="jquery-core-js"></script>
        <script type="text/javascript" src="/wp-includes/js/jquery/jquery-migrate.min5589.js?ver=3.4.1" id="jquery-migrate-js"></script>
        <link rel="https://api.w.org/" href="/wp-json/" /><link rel="alternate" title="JSON" type="application/json" href="/wp-json/wp/v2/pages/824" /><link rel="EditURI" type="application/rsd+xml" title="RSD" href="/xmlrpc.php?rsd" />
        <meta name="generator" content="WordPress 6.7.1" />
        <link rel="canonical" href="index.html" />
        <link rel='shortlink' href='/?p=824' />
        <link rel="alternate" title="oEmbed (JSON)" type="application/json+oembed" href="/wp-json/oembed/1.0/embed?url=https%3A%2F%2Ftravila.alithemes.com%2Fhome-four%2F" />
        <link rel="alternate" title="oEmbed (XML)" type="text/xml+oembed" href="/wp-json/oembed/1.0/embed?url=https%3A%2F%2Ftravila.alithemes.com%2Fhome-four%2F&amp;format=xml" />
        <meta name="generator" content="Elementor 3.25.4; features: additional_custom_breakpoints, e_optimized_control_loading, e_element_cache; settings: css_print_method-external, google_font-enabled, font_display-swap">
        <!-- This Google structured data (Rich Snippet) auto generated by RadiusTheme Review Schema plugin version 2.2.3 -->
        <style>
            .e-con.e-parent:nth-of-type(n+4):not(.e-lazyloaded):not(.e-no-lazyload),
            .e-con.e-parent:nth-of-type(n+4):not(.e-lazyloaded):not(.e-no-lazyload) * {
                background-image: none !important;
            }
            @media screen and (max-height: 1024px) {
                .e-con.e-parent:nth-of-type(n+3):not(.e-lazyloaded):not(.e-no-lazyload),
                .e-con.e-parent:nth-of-type(n+3):not(.e-lazyloaded):not(.e-no-lazyload) * {
                    background-image: none !important;
                }
            }
            @media screen and (max-height: 640px) {
                .e-con.e-parent:nth-of-type(n+2):not(.e-lazyloaded):not(.e-no-lazyload),
                .e-con.e-parent:nth-of-type(n+2):not(.e-lazyloaded):not(.e-no-lazyload) * {
                    background-image: none !important;
                }
            }
        </style>
        <link rel="icon" href="/wp-content/uploads/logo/Morocco-Tours.png" sizes="192x192">
        <link rel="apple-touch-icon" href="/wp-content/uploads/logo/Morocco-Tours.png">
        <style type="text/css" id="wp-custom-css">
            .box-popular-posts ul li .card-post .card-image img {
                margin-bottom: 0;
            }
            .card-property.card-flight.card-hotel .card-facilities .item-facilities p {
                padding: 0!important;
                display: flex;
                align-items: center;
                gap: 10px;
            }
            .box-grid-hotels .card-price>p {
                display: block!important;
            }
            .blog__details-content h4 {
                margin-top: 1.1em;
            }
            .alert {
                padding: 15px;
                margin-bottom: 20px;
                border: 1px solid transparent;
                border-radius: 4px;
            }

            .alert-success {
                color: #155724;
                background-color: #d4edda;
                border-color: #c3e6cb;
            }
        </style>
		<style id="kirki-inline-styles"></style>
        <script type="application/ld+json">
{
  "@context": "https://schema.org",
  "@type": "LocalBusiness",
  "name": "<?php echo e($detail->name); ?> - Moroccan Trip",
  "image": "https://moroccan-trips.com/wp-content/uploads/logo/Morocco-Tours.png",
  "url": "https://moroccan-trips.com/",
  "telephone": "+212 662-739094",
  "address": {
    "@type": "PostalAddress",
    "streetAddress": "Marrakech, Morocco",
    "addressLocality": "Marrakech",
    "addressCountry": "MA"
  },
  "aggregateRating": {
    "@type": "AggregateRating",
    "ratingValue": "5",
    "reviewCount": "1000"
  },
  "review": {
    "@type": "Review",
    "author": {
      "@type": "Person",
      "name": "John Doe"
    },
    "reviewRating": {
      "@type": "Rating",
      "ratingValue": "5",
      "bestRating": "5"
    },
  }
}
</script>
<script src="https://www.google.com/recaptcha/api.js?render=<?php echo e(env('RECAPTCHA_SITE_KEY')); ?>"></script>

    </head>

<body class="to_book-template-default single single-to_book postid-2413 wp-embed-responsive no-sidebar background-body elementor-default elementor-kit-11 e--ua-blink e--ua-edge e--ua-webkit" data-elementor-device-mode="desktop">
    <?php echo $__env->make('layouts.header', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
		
    <!-- main-area -->
    <main class="main-area">
        <section class="box-section box-breadcrumb background-body">
            <div class="container">
                <ul class="breadcrumbs m-0">
                    <li>
                        <a href="/"><?php echo e(__('strings.home')); ?></a>
                        <span class="arrow-right">
                            <svg width="7" height="12" viewBox="0 0 7 12" fill="none" xmlns="http://www.w3.org/2000/svg">
                                <path d="M1 11L6 6L1 1" stroke="" stroke-width="1.5" stroke-linecap="round" stroke-linejoin="round"></path>
                            </svg>
                        </span>
                    </li>
                    <li>
                        <?php if($detail->category == 1): ?>
                        <a href="/day-trips"><?php echo e(__('strings.Day Trips')); ?></a>
                        <?php elseif($detail->category == 2): ?>
                        <a href="/desert-tours"><?php echo e(__('strings.Desert Tours')); ?></a>
                        <?php else: ?>
                        <a href="/tour-packages"><?php echo e(__('strings.Tour Packages')); ?></a>
                        <?php endif; ?>
                        <span class="arrow-right">
                            <svg width="7" height="12" viewBox="0 0 7 12" fill="none" xmlns="http://www.w3.org/2000/svg">
                                <path d="M1 11L6 6L1 1" stroke="" stroke-width="1.5" stroke-linecap="round" stroke-linejoin="round"></path>
                            </svg>
                        </span>
                    </li>
                    <li> <span class="text-breadcrumb"><?php echo e($detail->name); ?></span></li>
                </ul>
            </div>
        </section>
        <section class="box-section box-content-tour-detail background-body">
            <div class="container">
                <?php if(session('success')): ?>
                    <div class="alert alert-success">
                        <?php echo e(session('success')); ?>

                    </div>
                <?php endif; ?>
                <div class="row mt-30">
                    <div class="col-lg-8">
                        <div class="box-banner-activities-detail-4"> 
                            <img fetchpriority="high" width="808" height="541" src="<?php echo e(asset('/storage/' . $detail->pictures)); ?>" class="attachment-full size-full" alt="<?php echo e($detail->name); ?>"> 
                        </div>
                        <div class="tour-title-main">
                            <h4 class="neutral-1000"><?php echo e($detail->name); ?></h4>
                        </div>
                        <div class="box-info-tour">
                            <div class="tour-info-group">
                                <div class="icon-item ">
                                    <svg width="18" height="19" viewBox="0 0 18 19" xmlns="http://www.w3.org/2000/svg">
                                        <path d="M14.5312 1.8828H13.8595V1.20312C13.8595 0.814789 13.5448 0.5 13.1564 0.5C12.7681 0.5 12.4533 0.814789 12.4533 1.20312V1.8828H5.55469V1.20312C5.55469 0.814789 5.2399 0.5 4.85156 0.5C4.46323 0.5 4.14844 0.814789 4.14844 1.20312V1.8828H3.47678C1.55967 1.8828 0 3.44247 0 5.35954V15.0232C0 16.9403 1.55967 18.5 3.47678 18.5H14.5313C16.4483 18.5 18.008 16.9403 18.008 15.0232V5.35954C18.008 3.44247 16.4483 1.8828 14.5312 1.8828ZM3.47678 3.28905H4.14844V4.66014C4.14844 5.04848 4.46323 5.36327 4.85156 5.36327C5.2399 5.36327 5.55469 5.04848 5.55469 4.66014V3.28905H12.4533V4.66014C12.4533 5.04848 12.7681 5.36327 13.1565 5.36327C13.5448 5.36327 13.8596 5.04848 13.8596 4.66014V3.28905H14.5313C15.6729 3.28905 16.6018 4.21788 16.6018 5.35954V6.03124H1.40625V5.35954C1.40625 4.21788 2.33508 3.28905 3.47678 3.28905ZM14.5312 17.0938H3.47678C2.33508 17.0938 1.40625 16.1649 1.40625 15.0232V7.43749H16.6018V15.0232C16.6018 16.1649 15.6729 17.0938 14.5312 17.0938ZM6.24611 10.2031C6.24611 10.5915 5.93132 10.9062 5.54298 10.9062H4.16018C3.77184 10.9062 3.45705 10.5915 3.45705 10.2031C3.45705 9.81479 3.77184 9.5 4.16018 9.5H5.54298C5.93128 9.5 6.24611 9.81479 6.24611 10.2031ZM14.551 10.2031C14.551 10.5915 14.2362 10.9062 13.8479 10.9062H12.4651C12.0767 10.9062 11.7619 10.5915 11.7619 10.2031C11.7619 9.81479 12.0767 9.5 12.4651 9.5H13.8479C14.2362 9.5 14.551 9.81479 14.551 10.2031ZM10.3945 10.2031C10.3945 10.5915 10.0798 10.9062 9.69142 10.9062H8.30862C7.92028 10.9062 7.60549 10.5915 7.60549 10.2031C7.60549 9.81479 7.92028 9.5 8.30862 9.5H9.69142C10.0797 9.5 10.3945 9.81479 10.3945 10.2031ZM6.24611 14.3516C6.24611 14.7399 5.93132 15.0547 5.54298 15.0547H4.16018C3.77184 15.0547 3.45705 14.7399 3.45705 14.3516C3.45705 13.9632 3.77184 13.6484 4.16018 13.6484H5.54298C5.93128 13.6484 6.24611 13.9632 6.24611 14.3516ZM14.551 14.3516C14.551 14.7399 14.2362 15.0547 13.8479 15.0547H12.4651C12.0767 15.0547 11.7619 14.7399 11.7619 14.3516C11.7619 13.9632 12.0767 13.6484 12.4651 13.6484H13.8479C14.2362 13.6484 14.551 13.9632 14.551 14.3516ZM10.3945 14.3516C10.3945 14.7399 10.0798 15.0547 9.69142 15.0547H8.30862C7.92028 15.0547 7.60549 14.7399 7.60549 14.3516C7.60549 13.9632 7.92028 13.6484 8.30862 13.6484H9.69142C10.0797 13.6484 10.3945 13.9632 10.3945 14.3516Z" fill=""></path>
                                    </svg>
                                </div>
                                <div class="info-item">
                                    <p class="text-sm-medium neutral-600 m-0"><?php echo e(__('strings.Duration')); ?></p>
                                    <p class="text-lg-bold neutral-1000 m-0">
                                        <?php echo e($detail->days); ?>

                                        <?php if($detail->days == 1): ?>
                                        <?php echo e(__('strings.Day')); ?>

                                        <?php else: ?>
                                        <?php echo e(__('strings.Days')); ?>

                                        <?php endif; ?>
                                    </p>
                                </div>
                            </div>
                            <div class="tour-info-group">
                                <div class="icon-item background-1">
                                    <svg width="21" height="21" viewBox="0 0 21 21" xmlns="http://www.w3.org/2000/svg">
                                        <path d="M13 2.25C13.4142 2.25 13.75 1.91421 13.75 1.5C13.75 1.08579 13.4142 0.75 13 0.75H9.9548C8.1182 0.74999 6.67861 0.74999 5.53648 0.87373C4.37094 1.00001 3.42656 1.26232 2.62024 1.84815C2.13209 2.20281 1.70281 2.63209 1.34815 3.12023C0.76232 3.92656 0.50001 4.87094 0.37373 6.03648C0.24999 7.17861 0.24999 8.6182 0.25 10.4548V10.5452C0.24999 12.3818 0.24999 13.8214 0.37373 14.9635C0.50001 16.1291 0.76232 17.0734 1.34815 17.8798C1.70281 18.3679 2.13209 18.7972 2.62023 19.1518C3.42656 19.7377 4.37094 20 5.53648 20.1263C6.67859 20.25 8.1182 20.25 9.9547 20.25H10.0453C11.8818 20.25 13.3214 20.25 14.4635 20.1263C15.6291 20 16.5734 19.7377 17.3798 19.1518C17.8679 18.7972 18.2972 18.3679 18.6518 17.8798C19.2377 17.0734 19.5 16.1291 19.6263 14.9635C19.75 13.8214 19.75 12.3818 19.75 10.5453V7.5C19.75 7.08579 19.4142 6.75 19 6.75C18.5858 6.75 18.25 7.08579 18.25 7.5V10.5C18.25 12.3916 18.249 13.75 18.135 14.802C18.0225 15.8399 17.8074 16.4901 17.4383 16.9981C17.1762 17.3589 16.8589 17.6762 16.4981 17.9383C15.9901 18.3074 15.3399 18.5225 14.302 18.635C13.25 18.749 11.8916 18.75 10 18.75C8.1084 18.75 6.74999 18.749 5.69804 18.635C4.66013 18.5225 4.00992 18.3074 3.50191 17.9383C3.14111 17.6762 2.82382 17.3589 2.56168 16.9981C2.19259 16.4901 1.97745 15.8399 1.865 14.802C1.75103 13.75 1.75 12.3916 1.75 10.5C1.75 8.6084 1.75103 7.24999 1.865 6.19805C1.97745 5.16013 2.19259 4.50992 2.56168 4.00191C2.82382 3.64111 3.14111 3.32382 3.50191 3.06168C4.00992 2.69259 4.66013 2.47745 5.69805 2.365C6.74999 2.25103 8.1084 2.25 10 2.25H13Z" fill=""></path>
                                        <path d="M4.32682 13.0267C4.1444 13.3986 4.29799 13.848 4.66987 14.0304C5.04175 14.2128 5.4911 14.0592 5.67352 13.6873L7.13386 10.7103C7.58649 9.78749 8.91687 9.83259 9.30597 10.7839C10.1852 12.9329 13.1906 13.0347 14.2132 10.9501L15.6736 7.97305C15.856 7.60116 15.7024 7.15181 15.3305 6.9694C14.9586 6.78698 14.5093 6.94057 14.3268 7.31245L12.8665 10.2895C12.4139 11.2123 11.0835 11.1672 10.6944 10.2159C9.81517 8.06687 6.80972 7.96506 5.78715 10.0497L4.32682 13.0267Z" fill=""></path>
                                        <path d="M15.5 2.5C15.5 3.88071 16.6193 5 18 5C19.3807 5 20.5 3.88071 20.5 2.5C20.5 1.11929 19.3807 0 18 0C16.6193 0 15.5 1.11929 15.5 2.5ZM17 2.5C17 3.05228 17.4477 3.5 18 3.5C18.5523 3.5 19 3.05228 19 2.5C19 1.94772 18.5523 1.5 18 1.5C17.4477 1.5 17 1.94772 17 2.5Z" fill=""></path>
                                    </svg>
                                </div>
                                <div class="info-item">
                                    <p class="text-sm-medium neutral-600 m-0"><?php echo e(__('strings.Tour Type')); ?></p>
                                    <p class="text-lg-bold neutral-1000 m-0">
                                    <?php if($detail->category == 1): ?>
                                    <?php echo e(__('strings.Day Trips')); ?>

                                    <?php elseif($detail->category == 2): ?>
                                    <?php echo e(__('strings.Desert Tours')); ?>

                                    <?php else: ?>
                                    <?php echo e(__('strings.Tour Packages')); ?>

                                    <?php endif; ?>
                                    </p>
                                </div>
                            </div>
                            <div class="tour-info-group">
                                <div class="icon-item background-3">
                                    <svg width="24" height="25" viewBox="0 0 24 25" xmlns="http://www.w3.org/2000/svg">
                                        <g>
                                            <path d="M21.5993 9.98724C22.2546 8.57953 22.7344 7.10443 22.7344 5.80109C22.7344 2.87799 20.3571 0.5 17.4351 0.5C15.3765 0.5 13.5884 1.6803 12.7114 3.39984C12.4056 3.37347 12.0963 3.35938 11.7891 3.35938C5.9469 3.35938 1.21875 8.08698 1.21875 13.9297C1.21875 19.7719 5.94635 24.5 11.7891 24.5C17.6312 24.5 22.3594 19.7724 22.3594 13.9297C22.3594 12.6126 22.123 11.2964 21.5993 9.98724ZM17.4351 1.90625C19.5817 1.90625 21.3281 3.65344 21.3281 5.80109C21.3281 8.57275 18.605 12.5386 17.4124 14.1425C15.8795 12.0587 13.5421 8.38324 13.5421 5.80109C13.5419 3.65344 15.2884 1.90625 17.4351 1.90625ZM5.05829 7.71765L9.77563 10.0762L9.23492 12.7796L7.3678 14.0244C7.17224 14.1547 7.05469 14.3743 7.05469 14.6094V17.6237L3.9613 18.6904C3.11389 17.3019 2.625 15.6719 2.625 13.9297C2.625 11.5349 3.54895 9.35187 5.05829 7.71765ZM4.82538 19.8799L7.98706 18.7897C8.27069 18.6919 8.46094 18.4249 8.46094 18.125V14.9857L10.2572 13.7881C10.4123 13.6847 10.5201 13.5239 10.5566 13.341L11.2597 9.82538C11.322 9.51447 11.1683 9.20044 10.8847 9.05872L6.16553 6.69904C7.888 5.35632 10.0206 4.67059 12.2355 4.77679C11.7907 7.03979 13.0248 9.73877 14.1724 11.7544L12.2307 13.365C11.9421 13.6045 11.8922 14.0282 12.1172 14.3281L13.3828 16.0156H10.5703C10.1819 16.0156 9.86719 16.3304 9.86719 16.7188V20.9375C9.86719 21.3259 10.1819 21.6406 10.5703 21.6406H13.7891L14.4481 22.6999C11.0292 23.7385 7.24127 22.703 4.82538 19.8799ZM15.7798 22.1782L14.7766 20.566C14.6483 20.3598 14.4227 20.2344 14.1797 20.2344H11.2734V17.4219H14.7891C15.3671 17.4219 15.6989 16.7599 15.3516 16.2969L13.6439 14.02L14.9059 12.9731C15.8904 14.5264 16.7787 15.6379 16.8618 15.741C17.1422 16.0889 17.6722 16.0903 17.9544 15.7439C18.0595 15.615 19.4385 13.909 20.6884 11.7328C20.8641 12.4469 20.9531 13.1819 20.9531 13.9297C20.9531 17.5532 18.8392 20.692 15.7798 22.1782Z" fill="black"></path>
                                            <path d="M17.436 8.2724C18.7959 8.2724 19.9022 7.16571 19.9022 5.8056C19.9022 4.44531 18.7957 3.33862 17.436 3.33862C16.076 3.33862 14.9697 4.44531 14.9697 5.8056C14.9697 7.16571 16.076 8.2724 17.436 8.2724ZM17.436 4.74487C18.0204 4.74487 18.496 5.22076 18.496 5.8056C18.496 6.39026 18.0204 6.86615 17.436 6.86615C16.8515 6.86615 16.376 6.39026 16.376 5.8056C16.376 5.22076 16.8515 4.74487 17.436 4.74487Z" fill="black"></path>
                                        </g>
                                    </svg>
                                </div>
                                <div class="info-item">
                                    <p class="text-sm-medium neutral-600 m-0"><?php echo e(__('strings.Languages')); ?></p>
                                    <p class="text-lg-bold neutral-1000 m-0">English</p>
                                </div>
                            </div>
                        </div>
                        <div class="box-collapse-expand travila-tour">       
                            <div class="group-collapse-expand travila-overview">
                                <button class="btn btn-collapse" type="button" data-bs-toggle="collapse" data-bs-target="#collapse-overview" aria-expanded="false" aria-controls="collapse-overview">
                                    <h6 class="fs-24">Overview</h6>
                                    <svg width="12" height="7" viewBox="0 0 12 7" fill="none" xmlns="http://www.w3.org/2000/svg">
                                        <path d="M1 1L6 6L11 1" stroke="" stroke-width="1.5" stroke-linecap="round" stroke-linejoin="round"></path>
                                    </svg>
                                </button>
                                <div class="collapse show" id="collapse-overview">
                                    <div class="card card-body">
                                        <?php echo $detail->content; ?>

                                    </div>
                                </div>
                            </div>
                            <div class="group-collapse-expand">
                                <button class="btn btn-collapse" type="button" data-bs-toggle="collapse" data-bs-target="#collapseQuestion" aria-expanded="false" aria-controls="collapseQuestion">
                                    <h6 class="fs-24">Question &amp; Answers</h6>
                                    <svg width="12" height="7" viewBox="0 0 12 7" fill="none" xmlns="http://www.w3.org/2000/svg">
                                        <path d="M1 1L6 6L11 1" stroke="" stroke-width="1.5" stroke-linecap="round" stroke-linejoin="round"></path>
                                    </svg>
                                </button>
                                <div class="collapse show" id="collapseQuestion">
                                    <div class="card card-body">
                                        <div class="list-questions">
                                            <?php if(!empty($faqs)): ?>
                                            <?php $__currentLoopData = $faqs; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $faq): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                            <div class="item-question">
                                                <div class="head-question">
                                                    <p class="text-md-bold neutral-1000"><?php echo e($faq->title); ?></p>
                                                </div>
                                                <div class="content-question">
                                                    <p class="text-sm-medium neutral-800"><?php echo e($faq->content); ?></p>
                                                </div>
                                            </div>
                                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                            <?php endif; ?>
                                            
                                        </div>
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>
                <div class="col-lg-4">
                    <div id="babe_widget_booking_form-2" class="booking-form widget_babe_widget_booking_form">
                        <h4 class="booking-form-title"><?php echo e(__('strings.Booking Form')); ?></h4>
                        
                        <div id="widget-babe-booking-form">
                            <div id="booking_form_block">
                                <form  method="post" action="">
                                    <?php echo csrf_field(); ?>
                                    <div class="input_group">
                                        <input type="hidden" name="trip" value="<?php echo e($detail->name); ?>">
                                        <div class="booking-form-block">
                                            <label class="booking_form_input_label"><?php echo e(__('strings.From')); ?>:</label>
                                            <div class="booking-date">
                                                <input type="date" class="" name="tripStart" >
                                            </div>
                                        </div>
                                        <div class="booking-form-block">
                                            <label class="booking_form_input_label"><?php echo e(__('strings.To')); ?>:</label>
                                            <div class="booking-date">
                                                <input type="date" class="" name="tripEnd">
                                            </div>
                                        </div>
                                        <div class="booking-form-block">
                                            <label class="booking_form_input_label"><?php echo e(__('strings.Full Name')); ?>:</label>
                                            <div class="booking-date">
                                                <input type="text" class="" name="fullname" placeholder="<?php echo e(__('strings.Full Name')); ?>" >
                                            </div>
                                        </div>
                                        <div class="booking-form-block">
                                            <label class="booking_form_input_label"><?php echo e(__('strings.Email')); ?>:</label>
                                            <div class="booking-date">
                                                <input type="text" class="" name="email" placeholder="<?php echo e(__('strings.Email')); ?>">
                                            </div>
                                        </div>
                                        <div class="booking-form-block">
                                            <label class="booking_form_input_label"><?php echo e(__('strings.Phone')); ?>:</label>
                                            <div class="booking-date">
                                                <input type="text" class="" name="phone" placeholder="<?php echo e(__('strings.Phone')); ?>">
                                            </div>
                                        </div>
                                        <div class="booking-form-block booking-guests-block">
                                            <label class="booking_form_input_label"><span class="booking_form_step_num">3</span><?php echo e(__('strings.Popular Tours')); ?>:</label>
                                            <div id="booking-guests-result">
                                                <div class="select_guests_block input_select_field">
                                                    <div class="input_select_title">
                                                        <div class="input_select_title_value"><?php echo e(__('strings.Adult')); ?></div>
                                                        <div class="input_select_wrapper">
                                                            <input type="number" class="" name="Adult">
                                                        </div>  
                                                    </div>
                                                </div>
                                                <div class="select_guests_block input_select_field">
                                                    <div class="input_select_title">
                                                        <div class="input_select_title_value"><?php echo e(__('strings.Children')); ?></div>
                                                        <div class="input_select_wrapper">
                                                            <input type="number" class="" name="Children">
                                                        </div>  
                                                    </div>
                                                </div>
                                            </div>
                                        </div>
                                        <div class="booking-form-block">
                                            <label class="booking_form_input_label"><?php echo e(__('strings.Message')); ?>:</label>
                                            <div class="booking-date">
                                                <textarea name="message" id="" cols="30" rows="10" placeholder="<?php echo e(__('strings.Message')); ?>"></textarea>
                                            </div>
                                        </div>
                                        <div class="booking-form-block">
                                        <input type="hidden" name="g-recaptcha-response" id="recaptchaToken">
                                    
                                    <!-- Display Validation Error for reCAPTCHA -->
                                    <?php if($errors->has('g-recaptcha-response')): ?>
                                        <div class="alert alert-danger">
                                            <?php echo e($errors->first('g-recaptcha-response')); ?>

                                        </div>
                                    <?php endif; ?>
                                        </div>
                                    </div>
                                    <input type="submit" value="<?php echo e(__('strings.Book Now')); ?>">
                                </form>
                            </div>
                        </div>
                    </div>
                    <div id="travila_booking_posts-2" class="booking-form widget_travila_booking_posts">
                        <div class="sidebar-left border-1 background-body">
                            <h6 class="text-lg-bold neutral-1000"><?php echo e(__('strings.Popular Tours')); ?></h6>
                            <div class="box-popular-posts box-popular-posts-md">
                                <ul>
                                    <?php $__currentLoopData = $trips; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $trip): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                    <li>
                                        <div class="card-post">
                                            <div class="card-image">
                                                <a href="/detail/<?php echo e($trip->id); ?>-<?php echo str_replace(' ', '-', $trip->name); ?>">
                                                    <?php
                                                        // Get the file path and extension
                                                        $imagePath = $trip->pictures; // Assuming the image path is stored in the file_path attribute
                                                        $extension = pathinfo($imagePath, PATHINFO_EXTENSION);
                                                        
                                                        // Add text before the extension
                                                        $modifiedImagePath = preg_replace('/\.' . $extension . '$/', '-cropped.' . $extension, $imagePath);
                                                    ?>
                                                    <img src="<?php echo e(asset('/storage/' . $modifiedImagePath)); ?>" alt="<?php echo e($trip->name); ?>" title="<?php echo e($trip->name); ?>">
                                                </a>
                                            </div>
                                            <div class="card-info">
                                                <a class="text-md-bold" href="/detail/<?php echo e($trip->id); ?>-<?php echo str_replace(' ', '-', $trip->name); ?>"><?php echo e($trip->name); ?></a>
                                            </div>
                                        </div>
                                    </li>
                                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                </ul>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </section>
    </main>
    <!-- main-area-end -->
    <?php echo $__env->make('layouts.footerm', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
    <script type="text/javascript">
				const lazyloadRunObserver = () => {
					const lazyloadBackgrounds = document.querySelectorAll( `.e-con.e-parent:not(.e-lazyloaded)` );
					const lazyloadBackgroundObserver = new IntersectionObserver( ( entries ) => {
						entries.forEach( ( entry ) => {
							if ( entry.isIntersecting ) {
								let lazyloadBackground = entry.target;
								if( lazyloadBackground ) {
									lazyloadBackground.classList.add( 'e-lazyloaded' );
								}
								lazyloadBackgroundObserver.unobserve( entry.target );
							}
						});
					}, { rootMargin: '200px 0px 200px 0px' } );
					lazyloadBackgrounds.forEach( ( lazyloadBackground ) => {
						lazyloadBackgroundObserver.observe( lazyloadBackground );
					} );
				};
				const events = [
					'DOMContentLoaded',
					'elementor/lazyload/observe',
				];
				events.forEach( ( event ) => {
					document.addEventListener( event, lazyloadRunObserver );
				} );
			</script>
			<link rel="stylesheet" id="elementor-post-17-css" href="/wp-content/uploads/elementor/css/post-174cf7.css?ver=1732681877" type="text/css" media="all">
<link rel="stylesheet" id="babe-admin-elementor-style-css" href="/wp-content/plugins/ba-book-everything/css/admin/babe-admin-elementor9704.css?ver=6.7.1" type="text/css" media="all">
<link rel="stylesheet" id="elementor-post-3064-css" href="/wp-content/uploads/elementor/css/post-30644cf7.css?ver=1732681877" type="text/css" media="all">
<link rel="stylesheet" id="elementor-icons-shared-0-css" href="/wp-content/plugins/elementor/assets/lib/font-awesome/css/fontawesome.min52d5.css?ver=5.15.3" type="text/css" media="all">
<link rel="stylesheet" id="elementor-icons-fa-solid-css" href="/wp-content/plugins/elementor/assets/lib/font-awesome/css/solid.min52d5.css?ver=5.15.3" type="text/css" media="all">
<link rel="stylesheet" id="elementor-post-3103-css" href="/wp-content/uploads/elementor/css/post-31034cf7.css?ver=1732681877" type="text/css" media="all">
<link rel="stylesheet" id="elementor-post-1847-css" href="/wp-content/uploads/elementor/css/post-1847cc95.css?ver=1732682031" type="text/css" media="all">
<script type="text/javascript" src="/wp-content/plugins/ba-book-everything/js/select2.full.mind584.js?ver=1.7.12" id="babe-select2-js-js"></script>
<script type="text/javascript" src="/wp-content/plugins/ba-book-everything/js/jquery.validate.mind584.js?ver=1.7.12" id="babe-validate-js-js"></script>
<script type="text/javascript" src="/wp-content/plugins/ba-book-everything/js/utild584.js?ver=1.7.12" id="babe-util-js-js"></script>
<script type="text/javascript" async="async" src="/wp-content/plugins/ba-book-everything/js/babe-modald584.js?ver=1.7.12" id="babe-modal-js-js"></script>
<script type="text/javascript" src="/wp-content/plugins/ba-book-everything/js/modald584.js?ver=1.7.12" id="babe-modal-adv-js-js"></script>
<script type="text/javascript" src="/wp-includes/js/dist/vendor/moment.minf799.js?ver=2.30.1" id="moment-js"></script>
<script type="text/javascript" src="/wp-content/plugins/ba-book-everything/js/daterangepickerd584.js?ver=1.7.12" id="babe-daterangepicker-js-js"></script>
<script type="text/javascript" src="/wp-content/plugins/ba-book-everything/js/ion.rangeSlider/ion.rangeSlider.mind584.js?ver=1.7.12" id="babe-ion-rangeslider-js-js"></script>

<script type="text/javascript" src="/wp-content/plugins/ba-book-everything/js/babe-scriptsd584.js?ver=1.7.12" id="babe-js-js"></script>
<script type="text/javascript" src="/wp-includes/js/jquery/ui/core.minb37e.js?ver=1.13.3" id="jquery-ui-core-js"></script>
<script type="text/javascript" src="/wp-includes/js/jquery/ui/datepicker.minb37e.js?ver=1.13.3" id="jquery-ui-datepicker-js"></script>
<script type="text/javascript" src="/wp-includes/js/dist/hooks.min4fdd.js?ver=4d63a3d491d11ffd8ac6" id="wp-hooks-js"></script>
<script type="text/javascript" src="/wp-includes/js/dist/i18n.minc33c.js?ver=5e580eb46a90c2b997e6" id="wp-i18n-js"></script>
<script type="text/javascript" id="wp-i18n-js-after">
/* <![CDATA[ */
wp.i18n.setLocaleData( { 'text direction\u0004ltr': [ 'ltr' ] } );
/* ]]> */
</script>
<script type="text/javascript" src="/wp-content/plugins/contact-form-7/includes/swv/js/indexf049.js?ver=6.0" id="swv-js"></script>

<script type="text/javascript" src="/wp-content/plugins/contact-form-7/includes/js/indexf049.js?ver=6.0" id="contact-form-7-js"></script>

<script type="text/javascript" src="/wp-content/plugins/travila-core/assets/js/wishlistf57d.js?ver=1733382335" id="travila-wishlist-js"></script>
<script type="text/javascript" src="/wp-content/themes/travila/assets/js/bootstrap.bundle.min9704.js?ver=6.7.1" id="bootstrap-js"></script>
<script type="text/javascript" src="/wp-content/themes/travila/assets/js/magnific-popup9704.js?ver=6.7.1" id="magnific-popup-js"></script>
<script type="text/javascript" src="/wp-content/themes/travila/assets/js/perfect-scrollbar.min9704.js?ver=6.7.1" id="perfect-scrollbar-js"></script>
<script type="text/javascript" src="/wp-content/themes/travila/assets/js/swiper-bundle.min9704.js?ver=6.7.1" id="swiper-bundle-js"></script>
<script type="text/javascript" src="/wp-content/themes/travila/assets/js/slick9704.js?ver=6.7.1" id="slick-js"></script>
<script type="text/javascript" src="/wp-content/themes/travila/assets/js/jquery.carouselTicker9704.js?ver=6.7.1" id="carouselTicker-js"></script>
<script type="text/javascript" src="/wp-includes/js/imagesloaded.minbb93.js?ver=5.0.0" id="imagesloaded-js"></script>
<script type="text/javascript" src="/wp-includes/js/masonry.min3a05.js?ver=4.2.2" id="masonry-js"></script>
<script type="text/javascript" src="/wp-content/themes/travila/assets/js/scrollup9704.js?ver=6.7.1" id="scrollup-js"></script>
<script type="text/javascript" src="/wp-content/themes/travila/assets/js/wow9704.js?ver=6.7.1" id="wow-js"></script>
<script type="text/javascript" src="/wp-content/themes/travila/assets/js/waypoints9704.js?ver=6.7.1" id="waypoints-js"></script>
<script type="text/javascript" src="/wp-content/themes/travila/assets/js/counterup9704.js?ver=6.7.1" id="counterup-js"></script>
<script type="text/javascript" src="/wp-content/themes/travila/assets/js/dark9704.js?ver=6.7.1" id="travila-dark-js"></script>
<script type="text/javascript" src="/wp-content/themes/travila/assets/js/jquery.countdown.min9704.js?ver=6.7.1" id="countdown-js"></script>
<script type="text/javascript" src="/wp-content/themes/travila/assets/js/noUISlider9704.js?ver=6.7.1" id="noUISlider-js"></script>
<script type="text/javascript" src="/wp-content/themes/travila/assets/js/travila-filter9704.js?ver=6.7.1" id="travila-filter-js"></script>
<script type="text/javascript" src="/wp-content/themes/travila/assets/js/slider9704.js?ver=6.7.1" id="travila-slider-js"></script>
<script type="text/javascript" src="/wp-content/themes/travila/assets/js/main9704.js?ver=6.7.1" id="travila-main-js"></script><a id="scrollUp" href="#top" style="position: fixed; z-index: 2147483647; display: none;"><svg width="20" height="25" viewBox="0 0 20 25" fill="none" xmlns="http://www.w3.org/2000/svg"><path d="M10.5998 24.2694C10.7522 24.1169 10.8485 23.9083 10.8485 23.6676L10.8503 1.20328C10.8504 0.737952 10.4653 0.35288 9.99997 0.352917C9.53464 0.352955 9.14951 0.738087 9.14947 1.20342L9.14766 23.6678C9.14762 24.1331 9.53269 24.5182 9.99802 24.5181C10.2387 24.5181 10.4473 24.4218 10.5998 24.2694Z" fill=""></path><path d="M18.8405 10.0441C19.1695 9.71509 19.1695 9.16953 18.8406 8.84061L10.6017 0.601675C10.2728 0.272759 9.7272 0.272803 9.39823 0.601772L1.15796 8.84204C0.828992 9.17101 0.828948 9.71657 1.15786 10.0455C1.48678 10.3744 2.03234 10.3744 2.36131 10.0454L9.99981 2.40689L17.6371 10.0442C17.966 10.3731 18.5115 10.373 18.8405 10.0441Z" fill=""></path></svg></a>
<script type="text/javascript" src="/wp-content/plugins/travila-core/assets/js/hello-world9704.js?ver=6.7.1" id="genixcore-js"></script>
<script type="text/javascript" src="/wp-content/plugins/elementor/assets/js/webpack.runtime.min401f.js?ver=3.25.4" id="elementor-webpack-runtime-js"></script>
<script type="text/javascript" src="/wp-content/plugins/elementor/assets/js/frontend-modules.min401f.js?ver=3.25.4" id="elementor-frontend-modules-js"></script>

<script src="https://www.google.com/recaptcha/api.js?render=<?php echo e(env('RECAPTCHA_SITE_KEY')); ?>"></script>
    <script>
        grecaptcha.ready(function() {
            grecaptcha.execute('<?php echo e(env('RECAPTCHA_SITE_KEY')); ?>', {action: 'submit'}).then(function(token) {
                document.getElementById('recaptchaToken').value = token;
            });
        });
    </script>
</body>
</html><?php /**PATH C:\xampp\htdocs\mohamed - Copy\resources\views/tour-details-m.blade.php ENDPATH**/ ?>