<!DOCTYPE html>
<html lang="en" data-x="html" data-x-toggle="html-overflow-hidden">
<head>
  <!-- Required meta tags -->
  <meta charset="UTF-8">
  <meta name="viewport" content="width=device-width, initial-scale=1">

  <!-- Google fonts -->
  <link rel="preconnect" href="https://fonts.googleapis.com/">
  <link rel="preconnect" href="https://fonts.gstatic.com/" crossorigin>
  <link href="https://fonts.googleapis.com/css2?family=DM+Sans:ital,wght@0,400;0,500;0,700;1,400;1,500;1,700&amp;display=swap" rel="stylesheet">

  <!-- Stylesheets -->
  <link rel="stylesheet" href="css/vendors.css">
  <link rel="stylesheet" href="css/main.css">
  <link rel="stylesheet" href="/css/style.css">
  <title><?php echo e(__('strings.Tour Packages')); ?> - Morocco Marrakech Travel</title>
  <link href="/img/favicon-moroccomarakech-travel.png" rel="shortcut icon" type="image/x-icon">
  <script>
  window.dataLayer = window.dataLayer || [];
  function gtag(){dataLayer.push(arguments);}
  gtag('js', new Date());

  gtag('config', 'G-G7V3W9R0EJ');
</script>
  <style>
    h3.tourCard__title.text-16.fw-500.mt-5 {
        height: 70px;
    }
  </style>
</head>

<body>
  <?php echo $__env->make('layouts.header2', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
    <section data-anim="fade" class="pageHeader -type-3">
      <div class="container">
        <div class="row justify-between">
          <div class="col-auto">
            <div class="breadcrumbs">
              <span class="breadcrumbs__item">
                <a href="/"><?php echo e(__('strings.home')); ?></a>
              </span>
              <span>></span>
              <span class="breadcrumbs__item">
                <a href="#"><?php echo e(__('strings.Tour Packages')); ?></a>
              </span>
            </div>
          </div>

          <div class="col-auto">
            <div class="pageHeader__subtitle"><?php echo e(__('strings.THE BEST Tour Packages')); ?></div>
          </div>
        </div>

        <div class="row pt-30">
          <div class="col-auto">
            <h1 class="pageHeader__title"><?php echo e(__('strings.Explore all things to do in Morocco')); ?></h1>
          </div>
        </div>
      </div>
    </section>

    <section data-anim-wrap class="layout-pb-xl">
      <div class="container">
        <div class="row y-gap-30 pt-30">
        <?php if(!empty($packages)): ?>
		<?php $__currentLoopData = $packages; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $package): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
          <div data-anim-child="slide-up delay-3" class="col-lg-4 col-sm-6">
            <a href="/detail/<?php echo str_replace(' ', '-', $package->name); ?>" class="tourCard -type-1 py-10 px-10 border-1 rounded-12  -hover-shadow">
              <div class="tourCard__header">
                <div class="tourCard__image ratio ratio-28:20">
                <?php
                      // Get the file path and extension
                      $imagePath = $package->pictures; // Assuming the image path is stored in the file_path attribute
                      $extension = pathinfo($imagePath, PATHINFO_EXTENSION);
                      
                      // Add text before the extension
                      $modifiedImagePath = preg_replace('/\.' . $extension . '$/', '-cropped.' . $extension, $imagePath);
                  ?>
                  <img src="<?php echo e(asset('https://moroccomarrakechtravel.com/moroccomarrakechtravelFinal/public/storage/' . $modifiedImagePath)); ?>" decoding="async" alt="<?php echo e($package->name); ?>" title="<?php echo e($package->name); ?>" class="img-ratio rounded-12">
                </div>
              </div>

              <div class="tourCard__content px-10 pt-10">
                <h3 class="tourCard__title text-16 fw-500 mt-5">
                  <span>
                  <?php if(Session()->has('lang')): ?>
                      <?php if(Session('lang') === 'fr'): ?>
                          <?php echo e($package->name_fr); ?>

                      <?php elseif(Session('lang') === 'es'): ?>
                          <?php echo e($package->name_es); ?>

                      <?php else: ?>
                          <?php echo e($package->name); ?>

                      <?php endif; ?>
                  <?php else: ?>
                  <?php echo e($package->name); ?>

                  <?php endif; ?>
                  </span>
                </h3>
                <div class="d-flex justify-between items-center border-1-top text-13 text-dark-1 pt-10 mt-10">
                  <div class="d-flex items-center">
                    <i class="icon-clock text-16 mr-5"></i>
                    <?php echo e($package->days); ?> <?php echo e(__('strings.Days')); ?>

                  </div>

                  <div><?php echo e(__('strings.view more')); ?></div>
                </div>
              </div>
            </a>

          </div>
          <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
		<?php endif; ?>

        </div>
      </div>
    </section>

    <?php echo $__env->make('layouts.footer', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>


  </main>

  <!-- JavaScript -->
  <script src="https://maps.googleapis.com/maps/api/js?key=AIzaSyAAz77U5XQuEME6TpftaMdX0bBelQxXRlM"></script>
  <script src="../../../unpkg.com/%40googlemaps/markerclusterer%402.5.3/dist/index.min.js"></script>

  <script src="js/vendors.js"></script>
  <script src="js/main.js"></script>
</body>
</html><?php /**PATH /home/chofxqkp/moroccomarrakechtravel.com/moroccomarrakechtravelFinal/resources/views/packages.blade.php ENDPATH**/ ?>