<?php

use Illuminate\Support\Facades\Route;
use App\Http\Controllers\ToursController;
use App\Http\Controllers\ContactController;
use App\Http\Controllers\LangController;
use App\Http\Controllers\BookController;
use App\Http\Controllers\PagesController;
use App\Http\Controllers\BlogController;
use App\Http\Controllers\NewsletterController;
use App\Http\Controllers\Controller;
use Illuminate\Support\Facades\Mail;
use App\Mail\ContactMail;
use App\Http\Controllers\TranslationController;
use App\Http\Controllers\TripPlannerController;
use Illuminate\Support\Facades\Http;

use App\Http\Controllers\DecryptController;


/*
|--------------------------------------------------------------------------
| Web Routes
|--------------------------------------------------------------------------
|
| Here is where you can register web routes for your application. These
| routes are loaded by the RouteServiceProvider within a group which
| contains the "web" middleware group. Now create something great!
|
*/
Route::get('/detail/{id}-{name}', [ToursController::class, 'detail']);
Route::post('/detail/{id}-{name}', [BookController::class, 'booking']);
Route::get('/lang/{lang}', [LangController::class,'change']);
Route::get('/aboutm', function () {
    return view('aboutm');
});
Route::get('/frequently-asked-questions', function () {
    return view('frequently-asked-questions.index');
});
Route::get('/', [ToursController::class, 'index']);
Route::get('/home2', [ToursController::class, 'index2']);
Route::get('/homet', [ToursController::class, 'indexT']);

Route::get('/day-trips', [ToursController::class, 'trips']);
Route::get('/desert-tours', [ToursController::class, 'allDesert']);
Route::get('/desert-tours/{from}', [ToursController::class, 'desert']);
Route::get('/tour-packages/{from}', [ToursController::class, 'packages']);
Route::get('/tour-packages', [ToursController::class, 'allPackages']);
Route::get('/mountain-trekking', [ToursController::class, 'trekking']);

Route::get('/contact', function () {
    return view('contact');
});
Route::post('/contact', [ContactController::class, 'mail']);
Route::post('/', [NewsletterController::class, 'newsletter']);

Route::get('/about', function () {
    return view('about');
});
Route::get('/frequently-asked-questions', [PagesController::class, 'faq']);

Route::get('/popullar-things-to-do-in-morocco', function () {
    return view('things-to-do');
});
Route::get('/privacy-policy', [PagesController::class, 'privacy']);
Route::get('/terms-and-conditions', [PagesController::class, 'terms']);
Route::get('/blog', [BlogController::class, 'index']);
Route::get('/blog/{id}-{title}', [BlogController::class, 'detail']);


// Route for the translation API
Route::get('/set-language/{lang}', [TranslationController::class, 'setLanguage'])->name('setLanguage');

Route::get('/slide', function () {
    return view('slide-sponsoring');
});

Route::get('/slide/packages', function () {
    return view('index');
});

Route::get('/trip-planner', [TripPlannerController::class, 'index'])->name('trip.index');
Route::post('/trip-planner', [TripPlannerController::class, 'plan'])->name('trip.plan');
Route::post('/send-trip-planner', [BookController::class, 'booking'])->name('trip.book');


Route::group(['prefix' => 'admin'], function () {
    Voyager::routes();
});
