<!DOCTYPE html>
<html lang="en" data-x="html" data-x-toggle="html-overflow-hidden">
<head>
  <!-- Required meta tags -->
  <meta charset="UTF-8">
  <meta name="viewport" content="width=device-width, initial-scale=1">

  <!-- Google fonts -->
  <link rel="preconnect" href="https://fonts.googleapis.com/">
  <link rel="preconnect" href="https://fonts.gstatic.com/" crossorigin>
  <link href="https://fonts.googleapis.com//css2?family=DM+Sans:ital,wght@0,400;0,500;0,700;1,400;1,500;1,700&amp;display=swap" rel="stylesheet">

  <!-- Stylesheets -->
  <link rel="stylesheet" href="/css/vendors.css">
  <link rel="stylesheet" href="/css/main.css">
  <link rel="stylesheet" href="/css/style.css">
  <title>{{ $pages->title }} - Morocco Marrakech Travel<</title>
  <link href="/img/favicon-moroccomarakech-travel.png" rel="shortcut icon" type="image/x-icon">
  <script>
  window.dataLayer = window.dataLayer || [];
  function gtag(){dataLayer.push(arguments);}
  gtag('js', new Date());

  gtag('config', 'G-G7V3W9R0EJ');
</script>
</head>

<body>
    @include('layouts.header2')

    <section data-anim="fade" class="pageHeader -type-1">
      <div class="pageHeader__bg">
        <img src="/img/background/chefchaouen.webp" alt="image">
        <img src="/img/hero/1/shape.svg" alt="image">
      </div>

      <div class="container">
        <div class="row justify-center">
          <div class="col-12">
            <div class="pageHeader__content">
              <h1 class="pageHeader__title">
                {{ $pages->title }}
              </h1>
            </div>
          </div>
        </div>
      </div>
    </section>

    <section class="layout-pt-lg">
      <div data-anim-wrap class="container">
        <div class="row y-gap-20 justify-between">
          <div data-anim-child="slide-up delay-2" class="col-lg-12">
              {!! $pages->body !!}
          </div>
        </div>
      </div>
    </section>
    <section class="layout-pt-xl">
      <div data-anim-wrap class="container">
        <div data-anim-child="slide-up" class="row">
          <div class="col-auto">
            <h2 class="text-30 md:text-24">{!!__('strings.Why choose')!!}</h2>
          </div>
        </div>

        <div data-anim-child="slide-up delay-2" class="row md:x-gap-20 pt-40 sm:pt-20 mobile-/css-slider -w-280">

          <div class="col-lg-4 col-sm-6">
            <div class="featureIcon -type-1 pr-40 md:pr-0">
              <div class="featureIcon__icon">
                <img src="/img/icons/1/ticket.svg" alt="icon">
              </div>

              <h3 class="featureIcon__title text-18 fw-500 mt-30">{{__('strings.Ultimate flexibility')}}</h3>
              <p class="featureIcon__text mt-10">{{__('strings.Txt Ultimate flexibility')}}</p>
            </div>
          </div>

          <div class="col-lg-4 col-sm-6">
            <div class="featureIcon -type-1 pr-40 md:pr-0">
              <div class="featureIcon__icon">
                <img src="img/icons/1/hot-air-balloon.svg" alt="icon">
              </div>

              <h3 class="featureIcon__title text-18 fw-500 mt-30">{{__('strings.Memorable experiences')}}</h3>
              <p class="featureIcon__text mt-10">{{__('strings.Txt Memorable experiences')}}</p>
            </div>
          </div>

          <div class="col-lg-4 col-sm-6">
            <div class="featureIcon -type-1 pr-40 md:pr-0">
              <div class="featureIcon__icon">
                <img src="img/icons/1/diamond.svg" alt="icon">
              </div>

              <h3 class="featureIcon__title text-18 fw-500 mt-30">{{__('strings.Our Travel Reviews')}}</h3>
              <p class="featureIcon__text mt-10">{{__('strings.Txt Our Travel Reviews')}}</p>
            </div>
          </div>
        </div>
      </div>
    </section>
    @include('layouts.footer')
  </main>

  <!-- JavaScript -->
  <script src="https://maps.googleapis.com/maps/api/js?key=AIzaSyAAz77U5XQuEME6TpftaMdX0bBelQxXRlM"></script>
  <script src="../../../unpkg.com/%40googlemaps/markerclusterer%402.5.3/dist/index.min.js"></script>

  <script src="/js/vendors.js"></script>
  <script src="/js/main.js"></script>
</body>
</html>