<!DOCTYPE html>
<html lang="en" data-x="html" data-x-toggle="html-overflow-hidden">
<head>
  <!-- Required meta tags -->
  <meta charset="UTF-8">
  <meta name="viewport" content="width=device-width, initial-scale=1">

  <!-- Google fonts -->
  <link rel="preconnect" href="https://fonts.googleapis.com/">
  <link rel="preconnect" href="https://fonts.gstatic.com/" crossorigin>
  <link href="https://fonts.googleapis.com/css2?family=DM+Sans:ital,wght@0,400;0,500;0,700;1,400;1,500;1,700&amp;display=swap" rel="stylesheet">

  <!-- Stylesheets -->
  <link rel="stylesheet" href="css/vendors.css">
  <link rel="stylesheet" href="css/main.css">

  <title>Book</title>
</head>

<body>
  @include('layouts.header2')
    <div data-anim="fade" class="map relative mt-header ml-60 mr-60 md:ml-0 md:mr-0">

      <iframe src="https://www.google.com/maps/embed?pb=!1m18!1m12!1m3!1d13588.234530091742!2d-8.0232381945098!3d31.632244986603453!2m3!1f0!2f0!3f0!3m2!1i1024!2i768!4f13.1!3m3!1m2!1s0xdafee8d931f3209%3A0x96ce34d39325c762!2sGu%C3%A9liz%2C%20Marrakech%2040000!5e0!3m2!1sfr!2sma!4v1721485880027!5m2!1sfr!2sma" width="100%" height="450" style="border:0;" allowfullscreen="" loading="lazy" referrerpolicy="no-referrer-when-downgrade"></iframe>
    </div>
    <section data-anim="fade" class="layout-pt-lg layout-pb-lg">
      <div class="container">
        <div class="row justify-center">
          <div class="col-lg-8">
            <h2 class="text-30 fw-700 text-center mb-30">Leave us your info</h2>

            <div class="contactForm">
              <form action="{{ route('contact') }}" method="POST">
                @csrf
                <div class="row y-gap-30">
                  <div class="col-md-6"> 
                    <input type="text" placeholder="Name" name="name">
                  </div>
                  <div class="col-md-6">
                    <input type="text" placeholder="Phone" name="phone">
                  </div>
                  <div class="col-12">
                    <input type="text" placeholder="Email" name="email">
                  </div>
                  <div class="col-12">
                    <textarea placeholder="Message" rows="6" name="message"></textarea>
                  </div>
                  <div class="col-12">
                    <button type="submit" class="button -md -dark-1 bg-accent-1 text-white col-12">Send Message</button>
                  </div>
                </div>
              </form>
            </div>
          </div>
        </div>
      </div>
    </section>
    @include('layouts.footer')
  </main>
  <!-- JavaScript -->
  <script src="https://maps.googleapis.com/maps/api/js?key=AIzaSyAAz77U5XQuEME6TpftaMdX0bBelQxXRlM"></script>

  <script src="/js/vendors.js"></script>
  <script src="/js/main.js"></script>
</body>
</html>