<!DOCTYPE html>
<html lang="en" data-x="html" data-x-toggle="html-overflow-hidden">
<head>
  <!-- Required meta tags -->
  <meta charset="UTF-8">
  <meta name="viewport" content="width=device-width, initial-scale=1">

  <!-- Google fonts -->
  <link rel="preconnect" href="https://fonts.googleapis.com/">
  <link rel="preconnect" href="https://fonts.gstatic.com/" crossorigin>
  <link href="https://fonts.googleapis.com/css2?family=DM+Sans:ital,wght@0,400;0,500;0,700;1,400;1,500;1,700&amp;display=swap" rel="stylesheet">

  <!-- Stylesheets -->
  <link rel="stylesheet" href="/css/vendors.css">
  <link rel="stylesheet" href="/css/main.css">
<link rel="stylesheet" href="/css/style.css">
  <title>{{__('strings.blog')}} - Moroccan Trips</title>
  <link href="/img/favicon-moroccomarakech-travel.png" rel="shortcut icon" type="image/x-icon">
  <script>
  window.dataLayer = window.dataLayer || [];
  function gtag(){dataLayer.push(arguments);}
  gtag('js', new Date());

  gtag('config', 'G-G7V3W9R0EJ');
</script>
</head>

<body>
    @include('layouts.header2')
    <section data-anim="fade" class="hero -type-1 -min-2">
      <div class="hero__bg">
        <img src="/img/hero/camels-8709070_1920.webp" alt="image">
        <img src="/img/hero/1/shape.svg" alt="image">
      </div>

      <div class="container">
        <div class="row justify-center">
          <div class="col-xl-12">
            <div class="hero__content">
              <h1 class="hero__title">
                {{__('strings.Your guide to everywhere')}}
              </h1>

              <p class="hero__text">
                {{__('strings.Txt Your guide to everywhere')}}
              </p>
            </div>
          </div>
        </div>
      </div>
    </section>

    <section class="layout-pt-md layout-pb-xl">
      <div class="container">
        <div class="tabs -pills-3 pt-30 js-tabs">

          <div class="tabs__content pt-30 js-tabs-content">

            <div class="tabs__pane -tab-item-1 is-tab-el-active">
              <div class="row y-gap-30">
              @if(!empty($articles))
					      @foreach($articles as $article)
                <div class="col-lg-4 col-md-6">
                  <a href="/blog/{{ $article->id }}-{!! str_replace(' ', '-', $article->title) !!}" class="blogCard -type-1">
                    <div class="blogCard__image ratio ratio-41:30">
                    @php
                      // Get the file path and extension
                      $imagePath = $article->image; // Assuming the image path is stored in the file_path attribute
                      $extension = pathinfo($imagePath, PATHINFO_EXTENSION);
                      
                      // Add text before the extension
                      $modifiedImagePath = preg_replace('/\.' . $extension . '$/', '-cropped.' . $extension, $imagePath);
                    @endphp
                      <img src="{{ asset('https://moroccomarrakechtravel.com/moroccomarrakechtravelFinal/public/storage/' . $modifiedImagePath) }}" decoding="async" alt="{{ $article->title }}" title="{{ $article->title }}" class="img-ratio rounded-12">

                      <div class="blogCard__badge">Trips</div>
                    </div>

                    <div class="blogCard__content mt-30">
                      <div class="blogCard__info text-14">
                        @php
                            $originalDate = \Carbon\Carbon::parse($article->created_at);
                        @endphp
                        <div class="lh-13">{{ $originalDate->format('F d Y') }}</div>
                        <div class="blogCard__line"></div>
                      </div>

                      <h3 class="blogCard__title text-18 fw-500 mt-10">{{ $article->title }}</h3>
                    </div>
                  </a>
                </div>
                  @endforeach
                @endif
              </div>
            </div>
          </div>
        </div>
      </div>
    </section>
    @include('layouts.footer')
  </main>

  <!-- JavaScript -->
  <script src="https://maps.googleapis.com/maps/api/js?key=AIzaSyAAz77U5XQuEME6TpftaMdX0bBelQxXRlM"></script>
  <script src="../../../unpkg.com/%40googlemaps/markerclusterer%402.5.3/dist/index.min.js"></script>

  <script src="/js/vendors.js"></script>
  <script src="/js/main.js"></script>
</body>
</html>