<!DOCTYPE html>
<html lang="en" data-x="html" data-x-toggle="html-overflow-hidden">
<head>
  <!-- Required meta tags -->
  <meta charset="UTF-8">
  <meta name="viewport" content="width=device-width, initial-scale=1">

  <!-- Google fonts -->
  <link rel="preconnect" href="https://fonts.googleapis.com/">
  <link rel="preconnect" href="https://fonts.gstatic.com/" crossorigin>
  <link href="https://fonts.googleapis.com/css2?family=DM+Sans:ital,wght@0,400;0,500;0,700;1,400;1,500;1,700&amp;display=swap" rel="stylesheet">
<link href="/img/favicon-moroccomarakech-travel.png" rel="shortcut icon" type="image/x-icon">
  <!-- Stylesheets -->
  <link rel="stylesheet" href="css/vendors.css">
  <link rel="stylesheet" href="css/main.css">
  <link rel="stylesheet" href="/css/style.css">

  <title>Morocco Marrakech Tours</title>
  <link rel="icon" href="/wp-content/uploads/logo/Morocco-Tours.png" sizes="192x192">
        <link rel="apple-touch-icon" href="/wp-content/uploads/logo/Morocco-Tours.png">
</head>

<body>
  <div class="preloader js-preloader">
    <div class="preloader__wrap">
      <div class="preloader__icon">
        <svg width="41" height="31" viewBox="0 0 41 31" fill="none" xmlns="http://www.w3.org/2000/svg">
          <path d="M39.9246 6.45422C38.6506 6.53101 37.3919 6.77205 36.1796 7.17136C34.9471 7.51728 33.7473 7.97054 32.594 8.52594C31.4296 9.02494 30.3322 9.66736 29.327 10.4383C28.3008 11.1471 27.3408 11.9472 26.4585 12.8287C25.5696 13.7546 24.7443 14.7396 23.9884 15.7769C23.2751 16.8197 22.6361 17.9114 22.076 19.0439C21.5552 20.2118 21.1029 21.409 20.7215 22.6295C20.4058 23.862 20.1663 25.1127 20.0043 26.3745C19.9199 25.1015 19.6791 23.8437 19.2872 22.6295C18.9413 21.397 18.488 20.1972 17.9326 19.0439C17.4336 17.8795 16.7912 16.7821 16.0203 15.7769C15.2919 14.7406 14.4932 13.7555 13.6298 12.8287C12.703 11.9653 11.7179 11.1666 10.6816 10.4383C9.67646 9.66736 8.579 9.02494 7.41468 8.52594C6.27257 7.9447 5.07016 7.49046 3.82902 7.17136C2.61677 6.77205 1.35801 6.53101 0.0840036 6.45422C0.0840036 7.17136 0.0043223 7.88849 0.0043223 8.60562C-0.0264515 10.0767 0.107179 11.5467 0.402729 12.9881C0.551182 13.7144 0.737357 14.4325 0.960498 15.1395C1.12782 15.8528 1.36813 16.5471 1.67763 17.2112C1.93625 17.8895 2.22878 18.5543 2.55412 19.2032L3.66966 21.1156L5.02424 22.8686L6.45851 24.4622L8.05213 25.9761L9.80512 27.251C10.4426 27.7291 11.08 28.0478 11.7175 28.4463L13.7095 29.4024L15.7015 30.1196L17.8529 30.6773L20.0043 30.9961L22.1557 30.6773L24.3071 30.1196L26.3788 29.4024L28.3709 28.4463L30.2035 27.251L31.9565 25.9761C32.5257 25.513 33.0584 25.0069 33.5501 24.4622C34.0948 23.9705 34.6009 23.4377 35.0641 22.8686L36.339 21.1156C36.7374 20.4781 37.1358 19.8407 37.4545 19.2032L38.4107 17.2112L39.1278 15.1395C39.3251 14.4313 39.4847 13.7132 39.6059 12.9881C39.7511 12.2773 39.8575 11.5591 39.9246 10.8367C40.0321 10.0981 40.0588 9.35 40.0043 8.60562C40.0175 7.88757 39.9909 7.16933 39.9246 6.45422Z" fill="url(#paint0_linear_433_3831)" />
          <path d="M25.0244 5.0996C25.0405 5.44685 25.0138 5.79477 24.9447 6.13546C24.875 6.49094 24.7681 6.83813 24.626 7.17131L24.1479 8.04781L23.5104 8.84462L22.7136 9.48207L21.7574 9.96016L20.8013 10.2789H18.7295L17.6937 9.96016L16.8172 9.48207L16.0204 8.84462L15.3033 8.04781L14.8252 7.17131L14.5064 6.13546C14.5064 5.81673 14.4268 5.49801 14.4268 5.0996C14.4268 4.7012 14.5064 4.46215 14.5064 4.14343C14.5064 3.8247 14.7455 3.42629 14.8252 3.10757L15.3033 2.23108L16.0204 1.43426C16.249 1.17933 16.5183 0.963939 16.8172 0.796813L17.6937 0.318725L18.7295 0H20.8013L21.7574 0.318725L22.7136 0.796813L23.5104 1.43426L24.1479 2.23108L24.626 3.10757C24.7789 3.43673 24.8861 3.78523 24.9447 4.14343C25.0105 4.45766 25.0372 4.77881 25.0244 5.0996Z" fill="#EB662B" />
          <defs>
            <linearGradient id="paint0_linear_433_3831" x1="6.50516" y1="10.1354" x2="23.3076" y2="35.2211" gradientUnits="userSpaceOnUse">
              <stop stop-color="#EB662B" />
              <stop offset="1" stop-color="#F28555" />
            </linearGradient>
          </defs>
        </svg>
      </div>
    </div>

    <div class="preloader__title">Viatours</div>
  </div>

  <div class="tourPagesSidebar" data-x="tourPagesSidebar" data-x-toggle="-is-active">
    <div class="tourPagesSidebar__overlay"></div>
    <div class="tourPagesSidebar__content">
      <div class="tourPagesSidebar__header d-flex items-center justify-between">
        <div class="text-20 fw-500">All filters</div>

        <button class="button -dark-1 size-40 rounded-full bg-light-1" data-x-click="tourPagesSidebar">
          <i class="icon-cross text-10"></i>
        </button>
      </div>


    </div>
  </div>

  <button class="toTopButton js-top-button">
    <svg width="22" height="22" viewBox="0 0 22 22" fill="none" xmlns="http://www.w3.org/2000/svg">
      <g clip-path="url(#clip0_83_4004)">
        <path d="M17.8783 0H4.12177C3.59388 0 3.16602 0.42786 3.16602 0.955755C3.16602 1.48365 3.59388 1.91151 4.12177 1.91151H17.8783C18.4062 1.91151 18.834 1.48365 18.834 0.955755C18.834 0.42786 18.4062 0 17.8783 0Z" />
        <path d="M11.6759 4.67546C11.3026 4.30219 10.6975 4.30219 10.3242 4.67546L6.04107 8.95863C5.66779 9.3319 5.66779 9.937 6.04107 10.3103C6.41434 10.6837 7.01955 10.6836 7.39272 10.3103L10.0444 7.6587V21.0443C10.0444 21.5722 10.4723 22 11.0002 22C11.5281 22 11.9559 21.5722 11.9559 21.0443V7.65859L14.6076 10.3102C14.7942 10.4969 15.0389 10.5901 15.2834 10.5901C15.528 10.5901 15.7726 10.4968 15.9593 10.3102C16.3325 9.9369 16.3325 9.3318 15.9593 8.95852L11.6759 4.67546Z" />
      </g>
      <defs>
        <clipPath id="clip0_83_4004">
          <rect width="22" height="22" fill="white" />
        </clipPath>
      </defs>
    </svg>
  </button>

  <main>


    <header class="header -type-1 -secondary js-header">
      <div data-anim="fade delay-3" class="header__container container">
        <div class="headerMobile__left">
          <button class="header__menuBtn js-menu-button">
            <i class="icon-main-menu"></i>
          </button>
        </div>

        <div class="header__logo">
          <a href="index.html" class="header__logo">
            <img src="img/general/logo-1.svg" alt="logo icon">
          </a>

          <div class="xl:d-none ml-30">
            <div class="header__search js-liverSearch js-form-dd">
              <i class="icon-search text-18"></i>
              <input type="text" placeholder="Search destinations or activities" class="js-search" data-x-click="headerSearch">

              <div class="headerSearchRecent" data-x="headerSearch" data-x-toggle="is-active">
                <div class="headerSearchRecent__container">
                  <div class="headerSearchRecent__title">
                    <h4 class="text-18 fw-500">Recent Searches</h4>
                  </div>

                  <div class="headerSearchRecent__list js-results">

                    <button class="headerSearchRecent__item js-search-option" data-x-click="headerSearch">
                      <div class="size-50 bg-white rounded-12 border-1 flex-center">
                        <i class="icon-pin text-20"></i>
                      </div>
                      <div class="ml-10">
                        <div class="fw-500 js-search-option-target">Phuket</div>
                        <div class="lh-14 text-14 text-light-2">Thailand, Asia</div>
                      </div>
                    </button>

                    <button class="headerSearchRecent__item js-search-option" data-x-click="headerSearch">
                      <div class="size-50 bg-white rounded-12 border-1 flex-center">
                        <i class="icon-price-tag text-20"></i>
                      </div>
                      <div class="ml-10">
                        <div class="fw-500 js-search-option-target">London Day Trips</div>
                        <div class="lh-14 text-14 text-light-2">England</div>
                      </div>
                    </button>

                    <button class="headerSearchRecent__item js-search-option" data-x-click="headerSearch">
                      <div class="size-50 bg-white rounded-12 border-1 flex-center">
                        <i class="icon-flag text-20"></i>
                      </div>
                      <div class="ml-10">
                        <div class="fw-500 js-search-option-target">Europe</div>
                        <div class="lh-14 text-14 text-light-2">Country</div>
                      </div>
                    </button>


                    <button class="headerSearchRecent__item js-search-option" data-x-click="headerSearch">
                      <div class="size-50 bg-white rounded-12 border-1 flex-center">
                        <img src="img/misc/icon.png" alt="image" class="rounded-12">
                      </div>
                      <div class="ml-10">
                        <div class="text-overflow fw-500 js-search-option-target">Centipede Tour - Guided Arizona Desert Tour by ATV</div>
                        <div class="lh-14 text-14 text-light-2">Country</div>
                      </div>
                    </button>


                    <button class="headerSearchRecent__item js-search-option" data-x-click="headerSearch">
                      <div class="size-50 bg-white rounded-12 border-1 flex-center">
                        <i class="icon-pin text-20"></i>
                      </div>
                      <div class="ml-10">
                        <div class="fw-500 js-search-option-target">Istanbul</div>
                        <div class="lh-14 text-14 text-light-2">Turkey</div>
                      </div>
                    </button>

                    <button class="headerSearchRecent__item js-search-option" data-x-click="headerSearch">
                      <div class="size-50 bg-white rounded-12 border-1 flex-center">
                        <i class="icon-pin text-20"></i>
                      </div>
                      <div class="ml-10">
                        <div class="fw-500 js-search-option-target">Berlin</div>
                        <div class="lh-14 text-14 text-light-2">Germany, Europe</div>
                      </div>
                    </button>

                    <button class="headerSearchRecent__item js-search-option" data-x-click="headerSearch">
                      <div class="size-50 bg-white rounded-12 border-1 flex-center">
                        <i class="icon-pin text-20"></i>
                      </div>
                      <div class="ml-10">
                        <div class="fw-500 js-search-option-target">London</div>
                        <div class="lh-14 text-14 text-light-2">England, Europe</div>
                      </div>
                    </button>

                  </div>
                </div>
              </div>
            </div>
          </div>
        </div>

        <div class="headerMobile__right">
          <button class="d-flex">
            <i class="icon-search text-18"></i>
          </button>

          <button class="d-flex ml-20">
            <i class="icon-person text-18"></i>
          </button>
        </div>

        <div class="header__right">

          <div class="headerDropdown lg:d-none js-form-dd">
            <div class="headerDropdown__button " data-x-click="headerDestinations">
              Destinations
              <i class="icon-chevron-down text-18"></i>
            </div>

            <div class="headerDropdown__content" data-x="headerDestinations" data-x-toggle="is-active">
              <div class="tabsMenu">
                <div class="tabsMenu__container">
                  <div class="tabs js-tabs">
                    <div class="tabsMenu__tabs">
                      <div class="tabs__controls js-tabs-controls">

                        <button class="tabs__button js-tabs-button is-tab-el-active" data-tab-target=".-tab-item-1">Europe</button>

                        <button class="tabs__button js-tabs-button " data-tab-target=".-tab-item-2">Asia</button>

                        <button class="tabs__button js-tabs-button " data-tab-target=".-tab-item-3">North America</button>

                        <button class="tabs__button js-tabs-button " data-tab-target=".-tab-item-4">South America</button>

                        <button class="tabs__button js-tabs-button " data-tab-target=".-tab-item-5">Africa</button>

                        <button class="tabs__button js-tabs-button " data-tab-target=".-tab-item-6">Oceania</button>

                        <button class="tabs__button js-tabs-button " data-tab-target=".-tab-item-7">Polar</button>

                        <button class="tabs__button js-tabs-button " data-tab-target=".-tab-item-8">Regions</button>

                      </div>
                    </div>

                    <div class="tabsMenu__content">
                      <div class="tabs__content js-tabs-content">

                        <div class="tabs__pane -tab-item-1 is-tab-el-active">
                          <div class="tabsMenu__lists">
                            <div class="tabsMenu-list">
                              <div class="tabsMenu-list__title">Europe Travel Guide</div>
                              <div class="tabsMenu-list__content">

                                <div class="tabsMenu-list__item">
                                  <a href="#">Italy Tours</a>
                                </div>

                                <div class="tabsMenu-list__item">
                                  <a href="#">Spain Tours</a>
                                </div>

                                <div class="tabsMenu-list__item">
                                  <a href="#">France Tours</a>
                                </div>

                                <div class="tabsMenu-list__item">
                                  <a href="#">Portugal Tours</a>
                                </div>

                                <div class="tabsMenu-list__item">
                                  <a href="#">Turkey Tours</a>
                                </div>

                                <div class="tabsMenu-list__item">
                                  <a href="#">Albania Tours</a>
                                </div>

                                <div class="tabsMenu-list__item">
                                  <a href="#">Andorra Tours</a>
                                </div>

                                <div class="tabsMenu-list__item">
                                  <a href="#">Armenia Tours</a>
                                </div>

                                <div class="tabsMenu-list__item">
                                  <a href="#">Austria Tours</a>
                                </div>

                                <div class="tabsMenu-list__item">
                                  <a href="#">Lithuania Tours</a>
                                </div>

                              </div>
                            </div>

                            <div class="tabsMenu-list">
                              <div class="tabsMenu-list__title">Europe Travel Guide</div>
                              <div class="tabsMenu-list__content">

                                <div class="tabsMenu-list__item">
                                  <a href="#">Azerbaijan Tours</a>
                                </div>

                                <div class="tabsMenu-list__item">
                                  <a href="#">Belgium Tours</a>
                                </div>

                                <div class="tabsMenu-list__item">
                                  <a href="#">Bosnia Herzegovina Tours</a>
                                </div>

                                <div class="tabsMenu-list__item">
                                  <a href="#">Bulgaria Tours</a>
                                </div>

                                <div class="tabsMenu-list__item">
                                  <a href="#">Croatia Tours</a>
                                </div>

                                <div class="tabsMenu-list__item">
                                  <a href="#">Cyprus Tours</a>
                                </div>

                                <div class="tabsMenu-list__item">
                                  <a href="#">Iceland Tours</a>
                                </div>

                                <div class="tabsMenu-list__item">
                                  <a href="#">Ireland Tours</a>
                                </div>

                                <div class="tabsMenu-list__item">
                                  <a href="#">Kosovo Tours</a>
                                </div>

                                <div class="tabsMenu-list__item">
                                  <a href="#">Latvia Tours</a>
                                </div>

                              </div>
                            </div>

                            <div class="tabsMenu-list">
                              <div class="tabsMenu-list__title">Europe Travel Guide</div>
                              <div class="tabsMenu-list__content">

                                <div class="tabsMenu-list__item">
                                  <a href="#">Czech Republic Tours</a>
                                </div>

                                <div class="tabsMenu-list__item">
                                  <a href="#">Denmark Tours</a>
                                </div>

                                <div class="tabsMenu-list__item">
                                  <a href="#">England Tours</a>
                                </div>

                                <div class="tabsMenu-list__item">
                                  <a href="#">Estonia Tours</a>
                                </div>

                                <div class="tabsMenu-list__item">
                                  <a href="#">Finland Tours</a>
                                </div>

                                <div class="tabsMenu-list__item">
                                  <a href="#">Georgia Tours</a>
                                </div>

                                <div class="tabsMenu-list__item">
                                  <a href="#">Germany Tours</a>
                                </div>

                                <div class="tabsMenu-list__item">
                                  <a href="#">Greece Tours</a>
                                </div>

                                <div class="tabsMenu-list__item">
                                  <a href="#">Holland Tours</a>
                                </div>

                                <div class="tabsMenu-list__item">
                                  <a href="#">Hungary Tours</a>
                                </div>

                              </div>
                            </div>
                          </div>
                        </div>

                        <div class="tabs__pane -tab-item-2 ">
                          <div class="tabsMenu__lists">
                            <div class="tabsMenu-list">
                              <div class="tabsMenu-list__title">Europe Travel Guide</div>
                              <div class="tabsMenu-list__content">

                                <div class="tabsMenu-list__item">
                                  <a href="#">Italy Tours</a>
                                </div>

                                <div class="tabsMenu-list__item">
                                  <a href="#">Spain Tours</a>
                                </div>

                                <div class="tabsMenu-list__item">
                                  <a href="#">France Tours</a>
                                </div>

                                <div class="tabsMenu-list__item">
                                  <a href="#">Portugal Tours</a>
                                </div>

                                <div class="tabsMenu-list__item">
                                  <a href="#">Turkey Tours</a>
                                </div>

                                <div class="tabsMenu-list__item">
                                  <a href="#">Albania Tours</a>
                                </div>

                                <div class="tabsMenu-list__item">
                                  <a href="#">Andorra Tours</a>
                                </div>

                                <div class="tabsMenu-list__item">
                                  <a href="#">Armenia Tours</a>
                                </div>

                                <div class="tabsMenu-list__item">
                                  <a href="#">Austria Tours</a>
                                </div>

                                <div class="tabsMenu-list__item">
                                  <a href="#">Lithuania Tours</a>
                                </div>

                              </div>
                            </div>

                            <div class="tabsMenu-list">
                              <div class="tabsMenu-list__title">Europe Travel Guide</div>
                              <div class="tabsMenu-list__content">

                                <div class="tabsMenu-list__item">
                                  <a href="#">Azerbaijan Tours</a>
                                </div>

                                <div class="tabsMenu-list__item">
                                  <a href="#">Belgium Tours</a>
                                </div>

                                <div class="tabsMenu-list__item">
                                  <a href="#">Bosnia Herzegovina Tours</a>
                                </div>

                                <div class="tabsMenu-list__item">
                                  <a href="#">Bulgaria Tours</a>
                                </div>

                                <div class="tabsMenu-list__item">
                                  <a href="#">Croatia Tours</a>
                                </div>

                                <div class="tabsMenu-list__item">
                                  <a href="#">Cyprus Tours</a>
                                </div>

                                <div class="tabsMenu-list__item">
                                  <a href="#">Iceland Tours</a>
                                </div>

                                <div class="tabsMenu-list__item">
                                  <a href="#">Ireland Tours</a>
                                </div>

                                <div class="tabsMenu-list__item">
                                  <a href="#">Kosovo Tours</a>
                                </div>

                                <div class="tabsMenu-list__item">
                                  <a href="#">Latvia Tours</a>
                                </div>

                              </div>
                            </div>

                            <div class="tabsMenu-list">
                              <div class="tabsMenu-list__title">Europe Travel Guide</div>
                              <div class="tabsMenu-list__content">

                                <div class="tabsMenu-list__item">
                                  <a href="#">Czech Republic Tours</a>
                                </div>

                                <div class="tabsMenu-list__item">
                                  <a href="#">Denmark Tours</a>
                                </div>

                                <div class="tabsMenu-list__item">
                                  <a href="#">England Tours</a>
                                </div>

                                <div class="tabsMenu-list__item">
                                  <a href="#">Estonia Tours</a>
                                </div>

                                <div class="tabsMenu-list__item">
                                  <a href="#">Finland Tours</a>
                                </div>

                                <div class="tabsMenu-list__item">
                                  <a href="#">Georgia Tours</a>
                                </div>

                                <div class="tabsMenu-list__item">
                                  <a href="#">Germany Tours</a>
                                </div>

                                <div class="tabsMenu-list__item">
                                  <a href="#">Greece Tours</a>
                                </div>

                                <div class="tabsMenu-list__item">
                                  <a href="#">Holland Tours</a>
                                </div>

                                <div class="tabsMenu-list__item">
                                  <a href="#">Hungary Tours</a>
                                </div>

                              </div>
                            </div>
                          </div>
                        </div>

                        <div class="tabs__pane -tab-item-3 ">
                          <div class="tabsMenu__lists">
                            <div class="tabsMenu-list">
                              <div class="tabsMenu-list__title">Europe Travel Guide</div>
                              <div class="tabsMenu-list__content">

                                <div class="tabsMenu-list__item">
                                  <a href="#">Italy Tours</a>
                                </div>

                                <div class="tabsMenu-list__item">
                                  <a href="#">Spain Tours</a>
                                </div>

                                <div class="tabsMenu-list__item">
                                  <a href="#">France Tours</a>
                                </div>

                                <div class="tabsMenu-list__item">
                                  <a href="#">Portugal Tours</a>
                                </div>

                                <div class="tabsMenu-list__item">
                                  <a href="#">Turkey Tours</a>
                                </div>

                                <div class="tabsMenu-list__item">
                                  <a href="#">Albania Tours</a>
                                </div>

                                <div class="tabsMenu-list__item">
                                  <a href="#">Andorra Tours</a>
                                </div>

                                <div class="tabsMenu-list__item">
                                  <a href="#">Armenia Tours</a>
                                </div>

                                <div class="tabsMenu-list__item">
                                  <a href="#">Austria Tours</a>
                                </div>

                                <div class="tabsMenu-list__item">
                                  <a href="#">Lithuania Tours</a>
                                </div>

                              </div>
                            </div>

                            <div class="tabsMenu-list">
                              <div class="tabsMenu-list__title">Europe Travel Guide</div>
                              <div class="tabsMenu-list__content">

                                <div class="tabsMenu-list__item">
                                  <a href="#">Azerbaijan Tours</a>
                                </div>

                                <div class="tabsMenu-list__item">
                                  <a href="#">Belgium Tours</a>
                                </div>

                                <div class="tabsMenu-list__item">
                                  <a href="#">Bosnia Herzegovina Tours</a>
                                </div>

                                <div class="tabsMenu-list__item">
                                  <a href="#">Bulgaria Tours</a>
                                </div>

                                <div class="tabsMenu-list__item">
                                  <a href="#">Croatia Tours</a>
                                </div>

                                <div class="tabsMenu-list__item">
                                  <a href="#">Cyprus Tours</a>
                                </div>

                                <div class="tabsMenu-list__item">
                                  <a href="#">Iceland Tours</a>
                                </div>

                                <div class="tabsMenu-list__item">
                                  <a href="#">Ireland Tours</a>
                                </div>

                                <div class="tabsMenu-list__item">
                                  <a href="#">Kosovo Tours</a>
                                </div>

                                <div class="tabsMenu-list__item">
                                  <a href="#">Latvia Tours</a>
                                </div>

                              </div>
                            </div>

                            <div class="tabsMenu-list">
                              <div class="tabsMenu-list__title">Europe Travel Guide</div>
                              <div class="tabsMenu-list__content">

                                <div class="tabsMenu-list__item">
                                  <a href="#">Czech Republic Tours</a>
                                </div>

                                <div class="tabsMenu-list__item">
                                  <a href="#">Denmark Tours</a>
                                </div>

                                <div class="tabsMenu-list__item">
                                  <a href="#">England Tours</a>
                                </div>

                                <div class="tabsMenu-list__item">
                                  <a href="#">Estonia Tours</a>
                                </div>

                                <div class="tabsMenu-list__item">
                                  <a href="#">Finland Tours</a>
                                </div>

                                <div class="tabsMenu-list__item">
                                  <a href="#">Georgia Tours</a>
                                </div>

                                <div class="tabsMenu-list__item">
                                  <a href="#">Germany Tours</a>
                                </div>

                                <div class="tabsMenu-list__item">
                                  <a href="#">Greece Tours</a>
                                </div>

                                <div class="tabsMenu-list__item">
                                  <a href="#">Holland Tours</a>
                                </div>

                                <div class="tabsMenu-list__item">
                                  <a href="#">Hungary Tours</a>
                                </div>

                              </div>
                            </div>
                          </div>
                        </div>

                        <div class="tabs__pane -tab-item-4 ">
                          <div class="tabsMenu__lists">
                            <div class="tabsMenu-list">
                              <div class="tabsMenu-list__title">Europe Travel Guide</div>
                              <div class="tabsMenu-list__content">

                                <div class="tabsMenu-list__item">
                                  <a href="#">Italy Tours</a>
                                </div>

                                <div class="tabsMenu-list__item">
                                  <a href="#">Spain Tours</a>
                                </div>

                                <div class="tabsMenu-list__item">
                                  <a href="#">France Tours</a>
                                </div>

                                <div class="tabsMenu-list__item">
                                  <a href="#">Portugal Tours</a>
                                </div>

                                <div class="tabsMenu-list__item">
                                  <a href="#">Turkey Tours</a>
                                </div>

                                <div class="tabsMenu-list__item">
                                  <a href="#">Albania Tours</a>
                                </div>

                                <div class="tabsMenu-list__item">
                                  <a href="#">Andorra Tours</a>
                                </div>

                                <div class="tabsMenu-list__item">
                                  <a href="#">Armenia Tours</a>
                                </div>

                                <div class="tabsMenu-list__item">
                                  <a href="#">Austria Tours</a>
                                </div>

                                <div class="tabsMenu-list__item">
                                  <a href="#">Lithuania Tours</a>
                                </div>

                              </div>
                            </div>

                            <div class="tabsMenu-list">
                              <div class="tabsMenu-list__title">Europe Travel Guide</div>
                              <div class="tabsMenu-list__content">

                                <div class="tabsMenu-list__item">
                                  <a href="#">Azerbaijan Tours</a>
                                </div>

                                <div class="tabsMenu-list__item">
                                  <a href="#">Belgium Tours</a>
                                </div>

                                <div class="tabsMenu-list__item">
                                  <a href="#">Bosnia Herzegovina Tours</a>
                                </div>

                                <div class="tabsMenu-list__item">
                                  <a href="#">Bulgaria Tours</a>
                                </div>

                                <div class="tabsMenu-list__item">
                                  <a href="#">Croatia Tours</a>
                                </div>

                                <div class="tabsMenu-list__item">
                                  <a href="#">Cyprus Tours</a>
                                </div>

                                <div class="tabsMenu-list__item">
                                  <a href="#">Iceland Tours</a>
                                </div>

                                <div class="tabsMenu-list__item">
                                  <a href="#">Ireland Tours</a>
                                </div>

                                <div class="tabsMenu-list__item">
                                  <a href="#">Kosovo Tours</a>
                                </div>

                                <div class="tabsMenu-list__item">
                                  <a href="#">Latvia Tours</a>
                                </div>

                              </div>
                            </div>

                            <div class="tabsMenu-list">
                              <div class="tabsMenu-list__title">Europe Travel Guide</div>
                              <div class="tabsMenu-list__content">

                                <div class="tabsMenu-list__item">
                                  <a href="#">Czech Republic Tours</a>
                                </div>

                                <div class="tabsMenu-list__item">
                                  <a href="#">Denmark Tours</a>
                                </div>

                                <div class="tabsMenu-list__item">
                                  <a href="#">England Tours</a>
                                </div>

                                <div class="tabsMenu-list__item">
                                  <a href="#">Estonia Tours</a>
                                </div>

                                <div class="tabsMenu-list__item">
                                  <a href="#">Finland Tours</a>
                                </div>

                                <div class="tabsMenu-list__item">
                                  <a href="#">Georgia Tours</a>
                                </div>

                                <div class="tabsMenu-list__item">
                                  <a href="#">Germany Tours</a>
                                </div>

                                <div class="tabsMenu-list__item">
                                  <a href="#">Greece Tours</a>
                                </div>

                                <div class="tabsMenu-list__item">
                                  <a href="#">Holland Tours</a>
                                </div>

                                <div class="tabsMenu-list__item">
                                  <a href="#">Hungary Tours</a>
                                </div>

                              </div>
                            </div>
                          </div>
                        </div>

                        <div class="tabs__pane -tab-item-5 ">
                          <div class="tabsMenu__lists">
                            <div class="tabsMenu-list">
                              <div class="tabsMenu-list__title">Europe Travel Guide</div>
                              <div class="tabsMenu-list__content">

                                <div class="tabsMenu-list__item">
                                  <a href="#">Italy Tours</a>
                                </div>

                                <div class="tabsMenu-list__item">
                                  <a href="#">Spain Tours</a>
                                </div>

                                <div class="tabsMenu-list__item">
                                  <a href="#">France Tours</a>
                                </div>

                                <div class="tabsMenu-list__item">
                                  <a href="#">Portugal Tours</a>
                                </div>

                                <div class="tabsMenu-list__item">
                                  <a href="#">Turkey Tours</a>
                                </div>

                                <div class="tabsMenu-list__item">
                                  <a href="#">Albania Tours</a>
                                </div>

                                <div class="tabsMenu-list__item">
                                  <a href="#">Andorra Tours</a>
                                </div>

                                <div class="tabsMenu-list__item">
                                  <a href="#">Armenia Tours</a>
                                </div>

                                <div class="tabsMenu-list__item">
                                  <a href="#">Austria Tours</a>
                                </div>

                                <div class="tabsMenu-list__item">
                                  <a href="#">Lithuania Tours</a>
                                </div>

                              </div>
                            </div>

                            <div class="tabsMenu-list">
                              <div class="tabsMenu-list__title">Europe Travel Guide</div>
                              <div class="tabsMenu-list__content">

                                <div class="tabsMenu-list__item">
                                  <a href="#">Azerbaijan Tours</a>
                                </div>

                                <div class="tabsMenu-list__item">
                                  <a href="#">Belgium Tours</a>
                                </div>

                                <div class="tabsMenu-list__item">
                                  <a href="#">Bosnia Herzegovina Tours</a>
                                </div>

                                <div class="tabsMenu-list__item">
                                  <a href="#">Bulgaria Tours</a>
                                </div>

                                <div class="tabsMenu-list__item">
                                  <a href="#">Croatia Tours</a>
                                </div>

                                <div class="tabsMenu-list__item">
                                  <a href="#">Cyprus Tours</a>
                                </div>

                                <div class="tabsMenu-list__item">
                                  <a href="#">Iceland Tours</a>
                                </div>

                                <div class="tabsMenu-list__item">
                                  <a href="#">Ireland Tours</a>
                                </div>

                                <div class="tabsMenu-list__item">
                                  <a href="#">Kosovo Tours</a>
                                </div>

                                <div class="tabsMenu-list__item">
                                  <a href="#">Latvia Tours</a>
                                </div>

                              </div>
                            </div>

                            <div class="tabsMenu-list">
                              <div class="tabsMenu-list__title">Europe Travel Guide</div>
                              <div class="tabsMenu-list__content">

                                <div class="tabsMenu-list__item">
                                  <a href="#">Czech Republic Tours</a>
                                </div>

                                <div class="tabsMenu-list__item">
                                  <a href="#">Denmark Tours</a>
                                </div>

                                <div class="tabsMenu-list__item">
                                  <a href="#">England Tours</a>
                                </div>

                                <div class="tabsMenu-list__item">
                                  <a href="#">Estonia Tours</a>
                                </div>

                                <div class="tabsMenu-list__item">
                                  <a href="#">Finland Tours</a>
                                </div>

                                <div class="tabsMenu-list__item">
                                  <a href="#">Georgia Tours</a>
                                </div>

                                <div class="tabsMenu-list__item">
                                  <a href="#">Germany Tours</a>
                                </div>

                                <div class="tabsMenu-list__item">
                                  <a href="#">Greece Tours</a>
                                </div>

                                <div class="tabsMenu-list__item">
                                  <a href="#">Holland Tours</a>
                                </div>

                                <div class="tabsMenu-list__item">
                                  <a href="#">Hungary Tours</a>
                                </div>

                              </div>
                            </div>
                          </div>
                        </div>

                        <div class="tabs__pane -tab-item-6 ">
                          <div class="tabsMenu__lists">
                            <div class="tabsMenu-list">
                              <div class="tabsMenu-list__title">Europe Travel Guide</div>
                              <div class="tabsMenu-list__content">

                                <div class="tabsMenu-list__item">
                                  <a href="#">Italy Tours</a>
                                </div>

                                <div class="tabsMenu-list__item">
                                  <a href="#">Spain Tours</a>
                                </div>

                                <div class="tabsMenu-list__item">
                                  <a href="#">France Tours</a>
                                </div>

                                <div class="tabsMenu-list__item">
                                  <a href="#">Portugal Tours</a>
                                </div>

                                <div class="tabsMenu-list__item">
                                  <a href="#">Turkey Tours</a>
                                </div>

                                <div class="tabsMenu-list__item">
                                  <a href="#">Albania Tours</a>
                                </div>

                                <div class="tabsMenu-list__item">
                                  <a href="#">Andorra Tours</a>
                                </div>

                                <div class="tabsMenu-list__item">
                                  <a href="#">Armenia Tours</a>
                                </div>

                                <div class="tabsMenu-list__item">
                                  <a href="#">Austria Tours</a>
                                </div>

                                <div class="tabsMenu-list__item">
                                  <a href="#">Lithuania Tours</a>
                                </div>

                              </div>
                            </div>

                            <div class="tabsMenu-list">
                              <div class="tabsMenu-list__title">Europe Travel Guide</div>
                              <div class="tabsMenu-list__content">

                                <div class="tabsMenu-list__item">
                                  <a href="#">Azerbaijan Tours</a>
                                </div>

                                <div class="tabsMenu-list__item">
                                  <a href="#">Belgium Tours</a>
                                </div>

                                <div class="tabsMenu-list__item">
                                  <a href="#">Bosnia Herzegovina Tours</a>
                                </div>

                                <div class="tabsMenu-list__item">
                                  <a href="#">Bulgaria Tours</a>
                                </div>

                                <div class="tabsMenu-list__item">
                                  <a href="#">Croatia Tours</a>
                                </div>

                                <div class="tabsMenu-list__item">
                                  <a href="#">Cyprus Tours</a>
                                </div>

                                <div class="tabsMenu-list__item">
                                  <a href="#">Iceland Tours</a>
                                </div>

                                <div class="tabsMenu-list__item">
                                  <a href="#">Ireland Tours</a>
                                </div>

                                <div class="tabsMenu-list__item">
                                  <a href="#">Kosovo Tours</a>
                                </div>

                                <div class="tabsMenu-list__item">
                                  <a href="#">Latvia Tours</a>
                                </div>

                              </div>
                            </div>

                            <div class="tabsMenu-list">
                              <div class="tabsMenu-list__title">Europe Travel Guide</div>
                              <div class="tabsMenu-list__content">

                                <div class="tabsMenu-list__item">
                                  <a href="#">Czech Republic Tours</a>
                                </div>

                                <div class="tabsMenu-list__item">
                                  <a href="#">Denmark Tours</a>
                                </div>

                                <div class="tabsMenu-list__item">
                                  <a href="#">England Tours</a>
                                </div>

                                <div class="tabsMenu-list__item">
                                  <a href="#">Estonia Tours</a>
                                </div>

                                <div class="tabsMenu-list__item">
                                  <a href="#">Finland Tours</a>
                                </div>

                                <div class="tabsMenu-list__item">
                                  <a href="#">Georgia Tours</a>
                                </div>

                                <div class="tabsMenu-list__item">
                                  <a href="#">Germany Tours</a>
                                </div>

                                <div class="tabsMenu-list__item">
                                  <a href="#">Greece Tours</a>
                                </div>

                                <div class="tabsMenu-list__item">
                                  <a href="#">Holland Tours</a>
                                </div>

                                <div class="tabsMenu-list__item">
                                  <a href="#">Hungary Tours</a>
                                </div>

                              </div>
                            </div>
                          </div>
                        </div>

                        <div class="tabs__pane -tab-item-7 ">
                          <div class="tabsMenu__lists">
                            <div class="tabsMenu-list">
                              <div class="tabsMenu-list__title">Europe Travel Guide</div>
                              <div class="tabsMenu-list__content">

                                <div class="tabsMenu-list__item">
                                  <a href="#">Italy Tours</a>
                                </div>

                                <div class="tabsMenu-list__item">
                                  <a href="#">Spain Tours</a>
                                </div>

                                <div class="tabsMenu-list__item">
                                  <a href="#">France Tours</a>
                                </div>

                                <div class="tabsMenu-list__item">
                                  <a href="#">Portugal Tours</a>
                                </div>

                                <div class="tabsMenu-list__item">
                                  <a href="#">Turkey Tours</a>
                                </div>

                                <div class="tabsMenu-list__item">
                                  <a href="#">Albania Tours</a>
                                </div>

                                <div class="tabsMenu-list__item">
                                  <a href="#">Andorra Tours</a>
                                </div>

                                <div class="tabsMenu-list__item">
                                  <a href="#">Armenia Tours</a>
                                </div>

                                <div class="tabsMenu-list__item">
                                  <a href="#">Austria Tours</a>
                                </div>

                                <div class="tabsMenu-list__item">
                                  <a href="#">Lithuania Tours</a>
                                </div>

                              </div>
                            </div>

                            <div class="tabsMenu-list">
                              <div class="tabsMenu-list__title">Europe Travel Guide</div>
                              <div class="tabsMenu-list__content">

                                <div class="tabsMenu-list__item">
                                  <a href="#">Azerbaijan Tours</a>
                                </div>

                                <div class="tabsMenu-list__item">
                                  <a href="#">Belgium Tours</a>
                                </div>

                                <div class="tabsMenu-list__item">
                                  <a href="#">Bosnia Herzegovina Tours</a>
                                </div>

                                <div class="tabsMenu-list__item">
                                  <a href="#">Bulgaria Tours</a>
                                </div>

                                <div class="tabsMenu-list__item">
                                  <a href="#">Croatia Tours</a>
                                </div>

                                <div class="tabsMenu-list__item">
                                  <a href="#">Cyprus Tours</a>
                                </div>

                                <div class="tabsMenu-list__item">
                                  <a href="#">Iceland Tours</a>
                                </div>

                                <div class="tabsMenu-list__item">
                                  <a href="#">Ireland Tours</a>
                                </div>

                                <div class="tabsMenu-list__item">
                                  <a href="#">Kosovo Tours</a>
                                </div>

                                <div class="tabsMenu-list__item">
                                  <a href="#">Latvia Tours</a>
                                </div>

                              </div>
                            </div>

                            <div class="tabsMenu-list">
                              <div class="tabsMenu-list__title">Europe Travel Guide</div>
                              <div class="tabsMenu-list__content">

                                <div class="tabsMenu-list__item">
                                  <a href="#">Czech Republic Tours</a>
                                </div>

                                <div class="tabsMenu-list__item">
                                  <a href="#">Denmark Tours</a>
                                </div>

                                <div class="tabsMenu-list__item">
                                  <a href="#">England Tours</a>
                                </div>

                                <div class="tabsMenu-list__item">
                                  <a href="#">Estonia Tours</a>
                                </div>

                                <div class="tabsMenu-list__item">
                                  <a href="#">Finland Tours</a>
                                </div>

                                <div class="tabsMenu-list__item">
                                  <a href="#">Georgia Tours</a>
                                </div>

                                <div class="tabsMenu-list__item">
                                  <a href="#">Germany Tours</a>
                                </div>

                                <div class="tabsMenu-list__item">
                                  <a href="#">Greece Tours</a>
                                </div>

                                <div class="tabsMenu-list__item">
                                  <a href="#">Holland Tours</a>
                                </div>

                                <div class="tabsMenu-list__item">
                                  <a href="#">Hungary Tours</a>
                                </div>

                              </div>
                            </div>
                          </div>
                        </div>

                        <div class="tabs__pane -tab-item-8 ">
                          <div class="tabsMenu__lists">
                            <div class="tabsMenu-list">
                              <div class="tabsMenu-list__title">Europe Travel Guide</div>
                              <div class="tabsMenu-list__content">

                                <div class="tabsMenu-list__item">
                                  <a href="#">Italy Tours</a>
                                </div>

                                <div class="tabsMenu-list__item">
                                  <a href="#">Spain Tours</a>
                                </div>

                                <div class="tabsMenu-list__item">
                                  <a href="#">France Tours</a>
                                </div>

                                <div class="tabsMenu-list__item">
                                  <a href="#">Portugal Tours</a>
                                </div>

                                <div class="tabsMenu-list__item">
                                  <a href="#">Turkey Tours</a>
                                </div>

                                <div class="tabsMenu-list__item">
                                  <a href="#">Albania Tours</a>
                                </div>

                                <div class="tabsMenu-list__item">
                                  <a href="#">Andorra Tours</a>
                                </div>

                                <div class="tabsMenu-list__item">
                                  <a href="#">Armenia Tours</a>
                                </div>

                                <div class="tabsMenu-list__item">
                                  <a href="#">Austria Tours</a>
                                </div>

                                <div class="tabsMenu-list__item">
                                  <a href="#">Lithuania Tours</a>
                                </div>

                              </div>
                            </div>

                            <div class="tabsMenu-list">
                              <div class="tabsMenu-list__title">Europe Travel Guide</div>
                              <div class="tabsMenu-list__content">

                                <div class="tabsMenu-list__item">
                                  <a href="#">Azerbaijan Tours</a>
                                </div>

                                <div class="tabsMenu-list__item">
                                  <a href="#">Belgium Tours</a>
                                </div>

                                <div class="tabsMenu-list__item">
                                  <a href="#">Bosnia Herzegovina Tours</a>
                                </div>

                                <div class="tabsMenu-list__item">
                                  <a href="#">Bulgaria Tours</a>
                                </div>

                                <div class="tabsMenu-list__item">
                                  <a href="#">Croatia Tours</a>
                                </div>

                                <div class="tabsMenu-list__item">
                                  <a href="#">Cyprus Tours</a>
                                </div>

                                <div class="tabsMenu-list__item">
                                  <a href="#">Iceland Tours</a>
                                </div>

                                <div class="tabsMenu-list__item">
                                  <a href="#">Ireland Tours</a>
                                </div>

                                <div class="tabsMenu-list__item">
                                  <a href="#">Kosovo Tours</a>
                                </div>

                                <div class="tabsMenu-list__item">
                                  <a href="#">Latvia Tours</a>
                                </div>

                              </div>
                            </div>

                            <div class="tabsMenu-list">
                              <div class="tabsMenu-list__title">Europe Travel Guide</div>
                              <div class="tabsMenu-list__content">

                                <div class="tabsMenu-list__item">
                                  <a href="#">Czech Republic Tours</a>
                                </div>

                                <div class="tabsMenu-list__item">
                                  <a href="#">Denmark Tours</a>
                                </div>

                                <div class="tabsMenu-list__item">
                                  <a href="#">England Tours</a>
                                </div>

                                <div class="tabsMenu-list__item">
                                  <a href="#">Estonia Tours</a>
                                </div>

                                <div class="tabsMenu-list__item">
                                  <a href="#">Finland Tours</a>
                                </div>

                                <div class="tabsMenu-list__item">
                                  <a href="#">Georgia Tours</a>
                                </div>

                                <div class="tabsMenu-list__item">
                                  <a href="#">Germany Tours</a>
                                </div>

                                <div class="tabsMenu-list__item">
                                  <a href="#">Greece Tours</a>
                                </div>

                                <div class="tabsMenu-list__item">
                                  <a href="#">Holland Tours</a>
                                </div>

                                <div class="tabsMenu-list__item">
                                  <a href="#">Hungary Tours</a>
                                </div>

                              </div>
                            </div>
                          </div>
                        </div>

                      </div>
                    </div>
                  </div>
                </div>
              </div>
            </div>
          </div>


          <div class="headerDropdown lg:d-none js-form-dd">
            <div class="headerDropdown__button " data-x-click="header-activities">
              Activities
              <i class="icon-chevron-down text-18"></i>
            </div>

            <div class="headerDropdown__content" data-x="header-activities" data-x-toggle="is-active">
              <div class="tabsMenu">
                <div class="tabsMenu__container">
                  <div class="tabs js-tabs">
                    <div class="tabsMenu__tabs">
                      <div class="tabs__controls js-tabs-controls">

                        <button class="tabs__button js-tabs-button is-tab-el-active" data-tab-target=".-tab-item-1">Top world landmarks</button>

                        <button class="tabs__button js-tabs-button " data-tab-target=".-tab-item-2">Food and Nightlife</button>

                        <button class="tabs__button js-tabs-button " data-tab-target=".-tab-item-3">Adventure and Sport</button>

                        <button class="tabs__button js-tabs-button " data-tab-target=".-tab-item-4">Landscapes and Nature</button>

                        <button class="tabs__button js-tabs-button " data-tab-target=".-tab-item-5">Boat Tours</button>

                        <button class="tabs__button js-tabs-button " data-tab-target=".-tab-item-6">Water Sports</button>

                        <button class="tabs__button js-tabs-button " data-tab-target=".-tab-item-7">Air Tours</button>

                        <button class="tabs__button js-tabs-button " data-tab-target=".-tab-item-8">Road Trips</button>

                      </div>
                    </div>

                    <div class="tabsMenu__content">
                      <div class="tabs__content js-tabs-content">

                        <div class="tabs__pane -tab-item-1 is-tab-el-active">
                          <div class="tabsMenu__lists">
                            <div class="tabsMenu-list">
                              <div class="tabsMenu-list__title">Food and Nightlife</div>
                              <div class="tabsMenu-list__content">

                                <div class="tabsMenu-list__item">
                                  <a href="#">Holi Tours</a>
                                </div>

                                <div class="tabsMenu-list__item">
                                  <a href="#">Christmas markets Tours</a>
                                </div>

                                <div class="tabsMenu-list__item">
                                  <a href="#">Day of the Dead Festival Tours</a>
                                </div>

                                <div class="tabsMenu-list__item">
                                  <a href="#">Food tours Tours</a>
                                </div>

                                <div class="tabsMenu-list__item">
                                  <a href="#">Party and nightlife Tours</a>
                                </div>

                                <div class="tabsMenu-list__item">
                                  <a href="#">Rio Carnival Tours</a>
                                </div>

                                <div class="tabsMenu-list__item">
                                  <a href="#">Pub and bar crawl Tours</a>
                                </div>

                                <div class="tabsMenu-list__item">
                                  <a href="#">St Patricks Day Tours</a>
                                </div>

                                <div class="tabsMenu-list__item">
                                  <a href="#">Cooking classes Tours</a>
                                </div>

                                <div class="tabsMenu-list__item">
                                  <a href="#">Wine tasting tours Tours</a>
                                </div>

                              </div>
                            </div>

                            <div class="tabsMenu-list">
                              <div class="tabsMenu-list__title">Food and Nightlife</div>
                              <div class="tabsMenu-list__content">

                                <div class="tabsMenu-list__item">
                                  <a href="#">Concerts and shows Tours</a>
                                </div>

                                <div class="tabsMenu-list__item">
                                  <a href="#">Coffee and tea tours Tours</a>
                                </div>

                                <div class="tabsMenu-list__item">
                                  <a href="#">Beer and drinks tasting Tours</a>
                                </div>

                                <div class="tabsMenu-list__item">
                                  <a href="#">Cherry Blossom Tours</a>
                                </div>

                              </div>
                            </div>
                          </div>
                        </div>

                        <div class="tabs__pane -tab-item-2 ">
                          <div class="tabsMenu__lists">
                            <div class="tabsMenu-list">
                              <div class="tabsMenu-list__title">Food and Nightlife</div>
                              <div class="tabsMenu-list__content">

                                <div class="tabsMenu-list__item">
                                  <a href="#">Holi Tours</a>
                                </div>

                                <div class="tabsMenu-list__item">
                                  <a href="#">Christmas markets Tours</a>
                                </div>

                                <div class="tabsMenu-list__item">
                                  <a href="#">Day of the Dead Festival Tours</a>
                                </div>

                                <div class="tabsMenu-list__item">
                                  <a href="#">Food tours Tours</a>
                                </div>

                                <div class="tabsMenu-list__item">
                                  <a href="#">Party and nightlife Tours</a>
                                </div>

                                <div class="tabsMenu-list__item">
                                  <a href="#">Rio Carnival Tours</a>
                                </div>

                                <div class="tabsMenu-list__item">
                                  <a href="#">Pub and bar crawl Tours</a>
                                </div>

                                <div class="tabsMenu-list__item">
                                  <a href="#">St Patricks Day Tours</a>
                                </div>

                                <div class="tabsMenu-list__item">
                                  <a href="#">Cooking classes Tours</a>
                                </div>

                                <div class="tabsMenu-list__item">
                                  <a href="#">Wine tasting tours Tours</a>
                                </div>

                              </div>
                            </div>

                            <div class="tabsMenu-list">
                              <div class="tabsMenu-list__title">Food and Nightlife</div>
                              <div class="tabsMenu-list__content">

                                <div class="tabsMenu-list__item">
                                  <a href="#">Concerts and shows Tours</a>
                                </div>

                                <div class="tabsMenu-list__item">
                                  <a href="#">Coffee and tea tours Tours</a>
                                </div>

                                <div class="tabsMenu-list__item">
                                  <a href="#">Beer and drinks tasting Tours</a>
                                </div>

                                <div class="tabsMenu-list__item">
                                  <a href="#">Cherry Blossom Tours</a>
                                </div>

                              </div>
                            </div>
                          </div>
                        </div>

                        <div class="tabs__pane -tab-item-3 ">
                          <div class="tabsMenu__lists">
                            <div class="tabsMenu-list">
                              <div class="tabsMenu-list__title">Food and Nightlife</div>
                              <div class="tabsMenu-list__content">

                                <div class="tabsMenu-list__item">
                                  <a href="#">Holi Tours</a>
                                </div>

                                <div class="tabsMenu-list__item">
                                  <a href="#">Christmas markets Tours</a>
                                </div>

                                <div class="tabsMenu-list__item">
                                  <a href="#">Day of the Dead Festival Tours</a>
                                </div>

                                <div class="tabsMenu-list__item">
                                  <a href="#">Food tours Tours</a>
                                </div>

                                <div class="tabsMenu-list__item">
                                  <a href="#">Party and nightlife Tours</a>
                                </div>

                                <div class="tabsMenu-list__item">
                                  <a href="#">Rio Carnival Tours</a>
                                </div>

                                <div class="tabsMenu-list__item">
                                  <a href="#">Pub and bar crawl Tours</a>
                                </div>

                                <div class="tabsMenu-list__item">
                                  <a href="#">St Patricks Day Tours</a>
                                </div>

                                <div class="tabsMenu-list__item">
                                  <a href="#">Cooking classes Tours</a>
                                </div>

                                <div class="tabsMenu-list__item">
                                  <a href="#">Wine tasting tours Tours</a>
                                </div>

                              </div>
                            </div>

                            <div class="tabsMenu-list">
                              <div class="tabsMenu-list__title">Food and Nightlife</div>
                              <div class="tabsMenu-list__content">

                                <div class="tabsMenu-list__item">
                                  <a href="#">Concerts and shows Tours</a>
                                </div>

                                <div class="tabsMenu-list__item">
                                  <a href="#">Coffee and tea tours Tours</a>
                                </div>

                                <div class="tabsMenu-list__item">
                                  <a href="#">Beer and drinks tasting Tours</a>
                                </div>

                                <div class="tabsMenu-list__item">
                                  <a href="#">Cherry Blossom Tours</a>
                                </div>

                              </div>
                            </div>
                          </div>
                        </div>

                        <div class="tabs__pane -tab-item-4 ">
                          <div class="tabsMenu__lists">
                            <div class="tabsMenu-list">
                              <div class="tabsMenu-list__title">Food and Nightlife</div>
                              <div class="tabsMenu-list__content">

                                <div class="tabsMenu-list__item">
                                  <a href="#">Holi Tours</a>
                                </div>

                                <div class="tabsMenu-list__item">
                                  <a href="#">Christmas markets Tours</a>
                                </div>

                                <div class="tabsMenu-list__item">
                                  <a href="#">Day of the Dead Festival Tours</a>
                                </div>

                                <div class="tabsMenu-list__item">
                                  <a href="#">Food tours Tours</a>
                                </div>

                                <div class="tabsMenu-list__item">
                                  <a href="#">Party and nightlife Tours</a>
                                </div>

                                <div class="tabsMenu-list__item">
                                  <a href="#">Rio Carnival Tours</a>
                                </div>

                                <div class="tabsMenu-list__item">
                                  <a href="#">Pub and bar crawl Tours</a>
                                </div>

                                <div class="tabsMenu-list__item">
                                  <a href="#">St Patricks Day Tours</a>
                                </div>

                                <div class="tabsMenu-list__item">
                                  <a href="#">Cooking classes Tours</a>
                                </div>

                                <div class="tabsMenu-list__item">
                                  <a href="#">Wine tasting tours Tours</a>
                                </div>

                              </div>
                            </div>

                            <div class="tabsMenu-list">
                              <div class="tabsMenu-list__title">Food and Nightlife</div>
                              <div class="tabsMenu-list__content">

                                <div class="tabsMenu-list__item">
                                  <a href="#">Concerts and shows Tours</a>
                                </div>

                                <div class="tabsMenu-list__item">
                                  <a href="#">Coffee and tea tours Tours</a>
                                </div>

                                <div class="tabsMenu-list__item">
                                  <a href="#">Beer and drinks tasting Tours</a>
                                </div>

                                <div class="tabsMenu-list__item">
                                  <a href="#">Cherry Blossom Tours</a>
                                </div>

                              </div>
                            </div>
                          </div>
                        </div>

                        <div class="tabs__pane -tab-item-5 ">
                          <div class="tabsMenu__lists">
                            <div class="tabsMenu-list">
                              <div class="tabsMenu-list__title">Food and Nightlife</div>
                              <div class="tabsMenu-list__content">

                                <div class="tabsMenu-list__item">
                                  <a href="#">Holi Tours</a>
                                </div>

                                <div class="tabsMenu-list__item">
                                  <a href="#">Christmas markets Tours</a>
                                </div>

                                <div class="tabsMenu-list__item">
                                  <a href="#">Day of the Dead Festival Tours</a>
                                </div>

                                <div class="tabsMenu-list__item">
                                  <a href="#">Food tours Tours</a>
                                </div>

                                <div class="tabsMenu-list__item">
                                  <a href="#">Party and nightlife Tours</a>
                                </div>

                                <div class="tabsMenu-list__item">
                                  <a href="#">Rio Carnival Tours</a>
                                </div>

                                <div class="tabsMenu-list__item">
                                  <a href="#">Pub and bar crawl Tours</a>
                                </div>

                                <div class="tabsMenu-list__item">
                                  <a href="#">St Patricks Day Tours</a>
                                </div>

                                <div class="tabsMenu-list__item">
                                  <a href="#">Cooking classes Tours</a>
                                </div>

                                <div class="tabsMenu-list__item">
                                  <a href="#">Wine tasting tours Tours</a>
                                </div>

                              </div>
                            </div>

                            <div class="tabsMenu-list">
                              <div class="tabsMenu-list__title">Food and Nightlife</div>
                              <div class="tabsMenu-list__content">

                                <div class="tabsMenu-list__item">
                                  <a href="#">Concerts and shows Tours</a>
                                </div>

                                <div class="tabsMenu-list__item">
                                  <a href="#">Coffee and tea tours Tours</a>
                                </div>

                                <div class="tabsMenu-list__item">
                                  <a href="#">Beer and drinks tasting Tours</a>
                                </div>

                                <div class="tabsMenu-list__item">
                                  <a href="#">Cherry Blossom Tours</a>
                                </div>

                              </div>
                            </div>
                          </div>
                        </div>

                        <div class="tabs__pane -tab-item-6 ">
                          <div class="tabsMenu__lists">
                            <div class="tabsMenu-list">
                              <div class="tabsMenu-list__title">Food and Nightlife</div>
                              <div class="tabsMenu-list__content">

                                <div class="tabsMenu-list__item">
                                  <a href="#">Holi Tours</a>
                                </div>

                                <div class="tabsMenu-list__item">
                                  <a href="#">Christmas markets Tours</a>
                                </div>

                                <div class="tabsMenu-list__item">
                                  <a href="#">Day of the Dead Festival Tours</a>
                                </div>

                                <div class="tabsMenu-list__item">
                                  <a href="#">Food tours Tours</a>
                                </div>

                                <div class="tabsMenu-list__item">
                                  <a href="#">Party and nightlife Tours</a>
                                </div>

                                <div class="tabsMenu-list__item">
                                  <a href="#">Rio Carnival Tours</a>
                                </div>

                                <div class="tabsMenu-list__item">
                                  <a href="#">Pub and bar crawl Tours</a>
                                </div>

                                <div class="tabsMenu-list__item">
                                  <a href="#">St Patricks Day Tours</a>
                                </div>

                                <div class="tabsMenu-list__item">
                                  <a href="#">Cooking classes Tours</a>
                                </div>

                                <div class="tabsMenu-list__item">
                                  <a href="#">Wine tasting tours Tours</a>
                                </div>

                              </div>
                            </div>

                            <div class="tabsMenu-list">
                              <div class="tabsMenu-list__title">Food and Nightlife</div>
                              <div class="tabsMenu-list__content">

                                <div class="tabsMenu-list__item">
                                  <a href="#">Concerts and shows Tours</a>
                                </div>

                                <div class="tabsMenu-list__item">
                                  <a href="#">Coffee and tea tours Tours</a>
                                </div>

                                <div class="tabsMenu-list__item">
                                  <a href="#">Beer and drinks tasting Tours</a>
                                </div>

                                <div class="tabsMenu-list__item">
                                  <a href="#">Cherry Blossom Tours</a>
                                </div>

                              </div>
                            </div>
                          </div>
                        </div>

                        <div class="tabs__pane -tab-item-7 ">
                          <div class="tabsMenu__lists">
                            <div class="tabsMenu-list">
                              <div class="tabsMenu-list__title">Food and Nightlife</div>
                              <div class="tabsMenu-list__content">

                                <div class="tabsMenu-list__item">
                                  <a href="#">Holi Tours</a>
                                </div>

                                <div class="tabsMenu-list__item">
                                  <a href="#">Christmas markets Tours</a>
                                </div>

                                <div class="tabsMenu-list__item">
                                  <a href="#">Day of the Dead Festival Tours</a>
                                </div>

                                <div class="tabsMenu-list__item">
                                  <a href="#">Food tours Tours</a>
                                </div>

                                <div class="tabsMenu-list__item">
                                  <a href="#">Party and nightlife Tours</a>
                                </div>

                                <div class="tabsMenu-list__item">
                                  <a href="#">Rio Carnival Tours</a>
                                </div>

                                <div class="tabsMenu-list__item">
                                  <a href="#">Pub and bar crawl Tours</a>
                                </div>

                                <div class="tabsMenu-list__item">
                                  <a href="#">St Patricks Day Tours</a>
                                </div>

                                <div class="tabsMenu-list__item">
                                  <a href="#">Cooking classes Tours</a>
                                </div>

                                <div class="tabsMenu-list__item">
                                  <a href="#">Wine tasting tours Tours</a>
                                </div>

                              </div>
                            </div>

                            <div class="tabsMenu-list">
                              <div class="tabsMenu-list__title">Food and Nightlife</div>
                              <div class="tabsMenu-list__content">

                                <div class="tabsMenu-list__item">
                                  <a href="#">Concerts and shows Tours</a>
                                </div>

                                <div class="tabsMenu-list__item">
                                  <a href="#">Coffee and tea tours Tours</a>
                                </div>

                                <div class="tabsMenu-list__item">
                                  <a href="#">Beer and drinks tasting Tours</a>
                                </div>

                                <div class="tabsMenu-list__item">
                                  <a href="#">Cherry Blossom Tours</a>
                                </div>

                              </div>
                            </div>
                          </div>
                        </div>

                        <div class="tabs__pane -tab-item-8 ">
                          <div class="tabsMenu__lists">
                            <div class="tabsMenu-list">
                              <div class="tabsMenu-list__title">Food and Nightlife</div>
                              <div class="tabsMenu-list__content">

                                <div class="tabsMenu-list__item">
                                  <a href="#">Holi Tours</a>
                                </div>

                                <div class="tabsMenu-list__item">
                                  <a href="#">Christmas markets Tours</a>
                                </div>

                                <div class="tabsMenu-list__item">
                                  <a href="#">Day of the Dead Festival Tours</a>
                                </div>

                                <div class="tabsMenu-list__item">
                                  <a href="#">Food tours Tours</a>
                                </div>

                                <div class="tabsMenu-list__item">
                                  <a href="#">Party and nightlife Tours</a>
                                </div>

                                <div class="tabsMenu-list__item">
                                  <a href="#">Rio Carnival Tours</a>
                                </div>

                                <div class="tabsMenu-list__item">
                                  <a href="#">Pub and bar crawl Tours</a>
                                </div>

                                <div class="tabsMenu-list__item">
                                  <a href="#">St Patricks Day Tours</a>
                                </div>

                                <div class="tabsMenu-list__item">
                                  <a href="#">Cooking classes Tours</a>
                                </div>

                                <div class="tabsMenu-list__item">
                                  <a href="#">Wine tasting tours Tours</a>
                                </div>

                              </div>
                            </div>

                            <div class="tabsMenu-list">
                              <div class="tabsMenu-list__title">Food and Nightlife</div>
                              <div class="tabsMenu-list__content">

                                <div class="tabsMenu-list__item">
                                  <a href="#">Concerts and shows Tours</a>
                                </div>

                                <div class="tabsMenu-list__item">
                                  <a href="#">Coffee and tea tours Tours</a>
                                </div>

                                <div class="tabsMenu-list__item">
                                  <a href="#">Beer and drinks tasting Tours</a>
                                </div>

                                <div class="tabsMenu-list__item">
                                  <a href="#">Cherry Blossom Tours</a>
                                </div>

                              </div>
                            </div>
                          </div>
                        </div>

                      </div>
                    </div>
                  </div>
                </div>
              </div>
            </div>
          </div>


          <div class="headerDropdown  js-form-dd">
            <div class="headerDropdown__button" data-x-click="header-currency">
              USD
              <i class="icon-chevron-down text-18"></i>
            </div>

            <div class="headerDropdown__content" data-x="header-currency" data-x-toggle="is-active">
              <div class="headerDropdown">
                <div class="headerDropdown__container">

                  <div class="headerDropdown__item">
                    <button class="">U.S. Dollar</button>
                  </div>

                  <div class="headerDropdown__item">
                    <button class="">Euro</button>
                  </div>

                  <div class="headerDropdown__item">
                    <button class="">British Pound</button>
                  </div>

                  <div class="headerDropdown__item">
                    <button class="">Turkish Lira</button>
                  </div>

                  <div class="headerDropdown__item">
                    <button class="">Canadian Dollar</button>
                  </div>

                  <div class="headerDropdown__item">
                    <button class="">Australian Dollar</button>
                  </div>

                  <div class="headerDropdown__item">
                    <button class="">Swiss Franc</button>
                  </div>

                  <div class="headerDropdown__item">
                    <button class="">Singapore Dollar</button>
                  </div>

                </div>
              </div>
            </div>
          </div>


          <a href="register.html" class="">
            Sign up
          </a>

          <a href="login.html" class="button -sm -dark-1 bg-accent-1 rounded-200 text-white ml-30">
            Log in
          </a>

          <button class="header__menuBtn ml-30 js-menu-button">
            <i class="icon-main-menu"></i>
          </button>
        </div>
      </div>
    </header>

    <div class="menu js-menu">
      <div class="menu__overlay js-menu-button"></div>

      <div class="menu__container">
        <div class="menu__header">
          <h4>Main Menu</h4>

          <button class="js-menu-button"><i class="icon-cross text-10"></i></button>
        </div>

        <div class="menu__content">
          <ul class="menuNav js-navList">
            <li class="menuNav__item -has-submenu js-has-submenu">
              <a>
                Home
                <i class="icon-chevron-right"></i>
              </a>

              <ul class="submenu">
                <li class="submenu__item js-nav-list-back">
                  <a>Back</a>
                </li>


                <li class="submenu__item">
                  <a href="index.html">Home 01</a>
                </li>

                <li class="submenu__item">
                  <a href="home-2.html">Home 02</a>
                </li>

                <li class="submenu__item">
                  <a href="home-3.html">Home 03</a>
                </li>

                <li class="submenu__item">
                  <a href="home-4.html">Home 04</a>
                </li>

                <li class="submenu__item">
                  <a href="home-5.html">Home 05</a>
                </li>

                <li class="submenu__item">
                  <a href="home-6.html">Home 06</a>
                </li>

                <li class="submenu__item">
                  <a href="home-7.html">Home 07</a>
                </li>

                <li class="submenu__item">
                  <a href="home-8.html">Home 08</a>
                </li>

                <li class="submenu__item">
                  <a href="home-9.html">Home 09</a>
                </li>

                <li class="submenu__item">
                  <a href="home-10.html">Home 10</a>
                </li>

              </ul>
            </li>

            <li class="menuNav__item -has-submenu js-has-submenu">
              <a>
                Tour
                <i class="icon-chevron-right"></i>
              </a>

              <ul class="submenu">
                <li class="submenu__item js-nav-list-back">
                  <a>Back</a>
                </li>


                <li class="submenu__item">
                  <a href="tour-list-1.html">Tour list 1</a>
                </li>

                <li class="submenu__item">
                  <a href="tour-list-2.html">Tour list 2</a>
                </li>

                <li class="submenu__item">
                  <a href="tour-list-3.html">Tour list 3</a>
                </li>

                <li class="submenu__item">
                  <a href="tour-list-4.html">Tour list 4</a>
                </li>

                <li class="submenu__item">
                  <a href="tour-list-5.html">Tour list 5</a>
                </li>

                <li class="submenu__item">
                  <a href="tour-list-6.html">Tour list 6</a>
                </li>

                <li class="submenu__item">
                  <a href="tour-list-7.html">Tour list 7</a>
                </li>

                <li class="submenu__item">
                  <a href="tour-list-8.html">Tour list 8</a>
                </li>

                <li class="submenu__item">
                  <a href="tour-list-9.html">Tour list 9</a>
                </li>

                <li class="submenu__item">
                  <a href="tour-list-10.html">Tour list 10</a>
                </li>

                <li class="submenu__item">
                  <a href="tour-single-1.html">Tour single 1</a>
                </li>

                <li class="submenu__item">
                  <a href="tour-single-2.html">Tour single 2</a>
                </li>

                <li class="submenu__item">
                  <a href="tour-single-3.html">Tour single 3</a>
                </li>

                <li class="submenu__item">
                  <a href="tour-single-4.html">Tour single 4</a>
                </li>

                <li class="submenu__item">
                  <a href="tour-single-5.html">Tour single 5</a>
                </li>

                <li class="submenu__item">
                  <a href="booking-pages.html">Booking</a>
                </li>

              </ul>
            </li>

            <li class="menuNav__item -has-submenu js-has-submenu">
              <a>
                Dashboard
                <i class="icon-chevron-right"></i>
              </a>

              <ul class="submenu">
                <li class="submenu__item js-nav-list-back">
                  <a>Back</a>
                </li>


                <li class="submenu__item">
                  <a href="db-main.html">Dashboard</a>
                </li>

                <li class="submenu__item">
                  <a href="db-booking.html">Booking</a>
                </li>

                <li class="submenu__item">
                  <a href="db-listing.html">Listing</a>
                </li>

                <li class="submenu__item">
                  <a href="db-add-tour.html">Add tour</a>
                </li>

                <li class="submenu__item">
                  <a href="db-favorites.html">Favorites</a>
                </li>

                <li class="submenu__item">
                  <a href="db-messages.html">Messages</a>
                </li>

                <li class="submenu__item">
                  <a href="db-profile.html">Profile</a>
                </li>

              </ul>
            </li>

            <li class="menuNav__item -has-submenu js-has-submenu">
              <a>
                Blog
                <i class="icon-chevron-right"></i>
              </a>

              <ul class="submenu">
                <li class="submenu__item js-nav-list-back">
                  <a>Back</a>
                </li>


                <li class="submenu__item">
                  <a href="blog-list-1.html">Blog list 1</a>
                </li>

                <li class="submenu__item">
                  <a href="blog-list-2.html">Blog list 2</a>
                </li>

                <li class="submenu__item">
                  <a href="blog-list-3.html">Blog list 3</a>
                </li>

                <li class="submenu__item">
                  <a href="blog-single.html">Blog single</a>
                </li>

              </ul>
            </li>

            <li class="menuNav__item -has-submenu js-has-submenu">
              <a>
                Pages
                <i class="icon-chevron-right"></i>
              </a>

              <ul class="submenu">
                <li class="submenu__item js-nav-list-back">
                  <a>Back</a>
                </li>


                <li class="submenu__item">
                  <a href="destinations.html">Destinations</a>
                </li>

                <li class="submenu__item">
                  <a href="about.html">About</a>
                </li>

                <li class="submenu__item">
                  <a href="contact.html">Contact</a>
                </li>

                <li class="submenu__item">
                  <a href="help-center.html">Help center</a>
                </li>

                <li class="submenu__item">
                  <a href="terms.html">Terms</a>
                </li>

                <li class="submenu__item">
                  <a href="login.html">Login</a>
                </li>

                <li class="submenu__item">
                  <a href="register.html">Register</a>
                </li>

                <li class="submenu__item">
                  <a href="404.html">404 Page</a>
                </li>

                <li class="submenu__item">
                  <a href="invoice.html">Invoice</a>
                </li>

                <li class="submenu__item">
                  <a href="ui-elements.html">UI elements</a>
                </li>

              </ul>
            </li>

            <li class="menuNav__item">
              <a href="contact.html">Contact</a>
            </li>
          </ul>
        </div>


        <div class="menu__footer">
          <i class="icon-headphone text-50"></i>

          <div class="text-20 lh-12 fw-500 mt-20">
            <div>Speak to our expert at</div>
            <div class="text-accent-1">1-800-453-6744</div>
          </div>

          <div class="d-flex items-center x-gap-10 pt-30">

            <div>
              <a class="d-block">
                <i class="icon-facebook"></i>
              </a>
            </div>

            <div>
              <a class="d-block">
                <i class="icon-twitter"></i>
              </a>
            </div>

            <div>
              <a class="d-block">
                <i class="icon-instagram"></i>
              </a>
            </div>

            <div>
              <a class="d-block">
                <i class="icon-linkedin"></i>
              </a>
            </div>

          </div>
        </div>
      </div>
    </div>


    <section class="nopage mt-header">
      <div class="container">
        <div class="row y-gap-30 justify-between items-center">
          <div class="col-xl-6 col-lg-6">
            <img src="img/404/1.svg" alt="image">
          </div>

          <div class="col-xl-5 col-lg-6">
            <div class="nopage__content pr-30 lg:pr-0">
              <h1>40<span class="text-accent-1">4</span></h1>
              <h2 class="text-30 md:text-24 fw-700">Oops! It looks like you're lost.</h2>
              <p>The page you're looking for isn't available. Try to search again or use the go to.</p>

              <button class="button -md -dark-1 bg-accent-1 text-white mt-25">
                Go back to homepage
                <i class="icon-arrow-top-right ml-10"></i>
              </button>
            </div>
          </div>
        </div>
      </div>
    </section>

    <footer class="footer -type-1">
      <div class="footer__main">
        <div class="footer__bg">
          <img src="img/footer/1/bg.svg" alt="image">
        </div>

        <div class="container">
          <div class="footer__info">
            <div class="row y-gap-20 justify-between">
              <div class="col-auto">
                <div class="row y-gap-20 items-center">
                  <div class="col-auto">
                    <i class="icon-headphone text-50"></i>
                  </div>

                  <div class="col-auto">
                    <div class="text-20 fw-500">
                      Speak to our expert at
                      <span class="text-accent-1">1-800-453-6744</span>
                    </div>
                  </div>
                </div>
              </div>

              <div class="col-auto">
                <div class="footerSocials">
                  <div class="footerSocials__title">
                    Follow Us
                  </div>

                  <div class="footerSocials__icons">
                    <a href="#" class="icon-facebook"></a>
                    <a href="#" class="icon-twitter"></a>
                    <a href="#" class="icon-instagram"></a>
                    <a href="#" class="icon-linkedin"></a>
                  </div>
                </div>
              </div>
            </div>
          </div>

          <div class="footer__content">
            <div class="row y-gap-40 justify-between">
              <div class="col-lg-4 col-md-6">
                <h4 class="text-20 fw-500">Contact</h4>

                <div class="y-gap-10 mt-20">
                  <a class="d-block" href="#">328 Queensberry Street, North Melbourne VIC3051, Australia.</a>
                  <a class="d-block" href="#">hi@viatours.com</a>
                </div>
              </div>

              <div class="col-lg-auto col-6">
                <h4 class="text-20 fw-500">Company</h4>

                <div class="y-gap-10 mt-20">

                  <a class="d-block fw-500" href="#">
                    About Us
                  </a>

                  <a class="d-block fw-500" href="#">
                    Tourz Reviews
                  </a>

                  <a class="d-block fw-500" href="#">
                    Contact Us
                  </a>

                  <a class="d-block fw-500" href="#">
                    Travel Guides
                  </a>

                  <a class="d-block fw-500" href="#">
                    Data Policy
                  </a>

                  <a class="d-block fw-500" href="#">
                    Cookie Policy
                  </a>

                  <a class="d-block fw-500" href="#">
                    Legal
                  </a>

                  <a class="d-block fw-500" href="#">
                    Sitemap
                  </a>

                </div>
              </div>

              <div class="col-lg-auto col-6">
                <h4 class="text-20 fw-500">Support</h4>

                <div class="y-gap-10 mt-20">

                  <a class="d-block fw-500" href="#">
                    Get in Touch
                  </a>

                  <a class="d-block fw-500" href="#">
                    Help center
                  </a>

                  <a class="d-block fw-500" href="#">
                    Live chat
                  </a>

                  <a class="d-block fw-500" href="#">
                    How it works
                  </a>

                </div>
              </div>

              <div class="col-lg-3 col-md-6">
                <h4 class="text-20 fw-500">Newsletter</h4>
                <p class="mt-20">Subscribe to the free newsletter and stay up to date</p>

                <div class="footer__newsletter">
                  <input type="Email" placeholder="Your email address">
                  <button>Send</button>
                </div>

                <h4 class="text-20 fw-500 mt-30">Mobile Apps</h4>

                <div class="mt-10">
                  <a class="d-flex items-center" href="#">
                    <i class="icon-apple text-16 mr-10"></i>
                    iOS App
                  </a>

                  <a class="d-flex items-center mt-10" href="#">
                    <i class="icon-android text-16 mr-10"></i>
                    Android App
                  </a>
                </div>
              </div>
            </div>
          </div>
        </div>
      </div>


      <div class="container">
        <div class="footer__bottom">
          <div class="row y-gap-5 justify-between items-center">
            <div class="col-auto">
              <div>© Copyright Viatours 2023</div>
            </div>

            <div class="col-auto">
              <div class="footer__images d-flex items-center x-gap-10">
                <img src="img/footer/cards/1.png" alt="image">
                <img src="img/footer/cards/2.png" alt="image">
                <img src="img/footer/cards/3.png" alt="image">
                <img src="img/footer/cards/4.png" alt="image">
                <img src="img/footer/cards/5.png" alt="image">
                <img src="img/footer/cards/6.png" alt="image">
              </div>
            </div>
          </div>
        </div>
      </div>
    </footer>


  </main>

  <!-- JavaScript -->
  <script src="https://maps.googleapis.com/maps/api/js?key=AIzaSyAAz77U5XQuEME6TpftaMdX0bBelQxXRlM"></script>
  <script src="../../../unpkg.com/%40googlemaps/markerclusterer%402.5.3/dist/index.min.js"></script>

  <script src="js/vendors.js"></script>
  <script src="js/main.js"></script>
</body>
</html>