<?php

namespace App\Services;

use Illuminate\Support\Facades\Http;
use Exception;

class AiTripPlanner
{
    protected $apiKey;
    protected $apiUrl = 'https://generativelanguage.googleapis.com/v1beta/models/gemini-2.0-flash:generateContent';

    public function __construct()
    {
        $this->apiKey = env('GEMINI_API_KEY');
    }

    public function generateTrip($preferences, $days, $locations)
    {
        $prompt = "Create a detailed, bespoke itinerary for exactly $days days in Morocco. The itinerary must cover all $days days, clearly labeled as ‘Day 1’, ‘Day 2’, and so on, up to Day $days. Include visits to: $locations. Preferences: $preferences.

Following the Deep Morocco Tours philosophy, the itinerary should:
	•	Highlight authentic Moroccan experiences, including cultural, historical, and local encounters.
	•	Include comfortable and luxury travel options such as private A/C vans or 4×4 vehicles, Riads, Kasbahs, and luxury desert tents where applicable.
	•	Feature personalized touches like English-speaking drivers, local guides, Berber music, traditional Moroccan meals, mint tea ceremonies, and camel trekking.
	•	Include overnight stays in desert camps, typical Moroccan hotels, Kasbahs, or Riads, depending on the region.
	•	Emphasize unique, immersive experiences such as visiting nomad villages, off-road desert exploration, panoramic viewpoints, and local artisan workshops.
	•	Incorporate recommendations from Deep Morocco Tours, based on expert knowledge of Morocco and traveler reviews (Deep Morocco Tours on TripAdvisor).
	•	Highlight optional experiences like private cultural shows, photography tours, and local market explorations.

For each day, provide simple highlights using emojis to illustrate the activities (e.g., 🏜 Camel Trek, 🏰 Kasbah Visit, 🍵 Mint Tea, 🎶 Berber Music, 🏨 Luxury Riad).

Do not include prices. Focus on luxury, authenticity, and immersive experiences that reflect the signature style of Deep Morocco Tours.";

        $response = Http::post($this->apiUrl . '?key=' . $this->apiKey, [
            'contents' => [
                ['parts' => [['text' => $prompt]]]
            ],
            'generationConfig' => [
                'temperature' => 0.7,
                'maxOutputTokens' => 2000,
            ],
        ]);

        if ($response->failed()) {
            throw new Exception('Gemini API Error: ' . $response->body());
        }

        $data = $response->json();

        return $data['candidates'][0]['content']['parts'][0]['text'] ?? __('messages.no_response');
    }
}
