<?php

// app/Mail/ContactMail.php

namespace App\Mail;

use Illuminate\Bus\Queueable;
use Illuminate\Mail\Mailable;
use Illuminate\Queue\SerializesModels;
use Illuminate\Support\Facades\Log;

class ReponseContact extends Mailable
{
    use Queueable, SerializesModels;

    public $data; // Define the property to hold the data

    /**
     * Create a new message instance.
     *
     * @param  string  $text
     * @return void
     */
    public function __construct(array $data)
    {
        $this->data  = $data; // Assign a value to the property
    }

    /**
     * Build the message.
     *
     * @return $this
     */
    public function build()
    {
        try {
            return $this->view('mail.reponse-contact')->with(['data' => $this->data])->subject('Thank You for Contacting Us')->from('ashraf.elouaar@gmail.com', 'Moroccon Tour');
        } catch (\Exception $exception) {
            Log::error($exception->getMessage());
            // You can also log additional information for debugging purposes.
        }
    }
}
