<?php

namespace App\Jobs;

use Illuminate\Bus\Queueable;
use Illuminate\Contracts\Queue\ShouldQueue;
use Illuminate\Foundation\Bus\Dispatchable;
use Illuminate\Queue\InteractsWithQueue;
use Illuminate\Queue\SerializesModels;
use App\Services\TranslateService;
use App\Trip;
use App\Blog;
use App\Review;
use App\Models\Menu;
use App\City;


class TranslateContent implements ShouldQueue
{
    use Dispatchable, InteractsWithQueue, Queueable, SerializesModels;

    protected $service;
    protected $from;
    protected $id;

    public function __construct($from, $id)
    {
        $this->service = app(TranslateService::class);
        $this->from = $from;
        $this->id = $id;
    }

    public function handle(): void
    {
        $menus = Menu::select('*', 'menu_items.id as Iditem')
            ->join('menu_items', 'menu_items.menu_id', '=', 'menus.id')
            ->where('menu_items.menu_id', '=', 2)
            ->get();

        $trips = Trip::where('category', '1')->limit(6)->orderByDesc('id')->get();
        $packages = Trip::where('category', '2')->limit(6)->orderByDesc('id')->get();
        $blogs = Blog::orderByDesc('id')->take(3)->get();
        $reviews = Review::orderByDesc('id')->get();

        $city = City::where('city', '=', $this->from)->first();
        $detail = Trip::where('id', '=', $this->id)->first();

        $languages = ['fr', 'ar', 'zh'];

        foreach ($languages as $lang) {
            $this->service->translateModelsBatchCached($menus, 'title', $lang);
            $this->service->translateModelsBatchCached($trips, 'name', $lang);
            $this->service->translateModelsBatchCached($packages, 'name', $lang);
            $this->service->translateModelsBatchCached($blogs, ['title', 'content'], $lang);
            $this->service->translateModelsBatchCached($reviews, ['title', 'content'], $lang);

            if ($city) {
                $this->service->translateModelsBatchCached(collect([$city]), ['city'], $lang);
            }

            if ($detail) {
                $this->service->translateModelsBatchCached(collect([$detail]), ['name', 'content'], $lang);
            }
        }
    }
}
