<?php

namespace App\Http\Controllers;

use Illuminate\Http\Request;
use App\Services\AiTripPlanner;
use App\Faq;

class TripPlannerController extends Controller
{
    protected $planner;

    public function __construct(AiTripPlanner $planner)
    {
        $this->planner = $planner;
    }

    public function index()
    {
        return view('trip-ai.planner');
    }

    public function plan(Request $request)
{
    $faqs = Faq::get();
    $validated = $request->validate([
        'preferences' => 'required|string|max:500',
        'days' => 'required|integer|min:1|max:30',
        'locations' => 'required|string|max:255',
    ]);

    try {
        $tripPlan = $this->planner->generateTrip(
            $validated['preferences'],
            $validated['days'],
            $validated['locations']
        );

        return view('trip-ai.result', ['tripPlan' => $tripPlan, 'faqs' => $faqs]);

    } catch (\Exception $e) {
        dd($e->getMessage()); // Temporarily shows the exact error
    }
}


}
