<?php

namespace App\Http\Controllers;

use Illuminate\Http\Request;
use App\Trip;
use App\City;
use App\Faq;
use App\Blog;
use App\Review;
use App\Category;
use App\Models\Menu;
use App\Services\TranslateService;
use Illuminate\Support\Facades\Session;
use Illuminate\Pagination\LengthAwarePaginator;
use Illuminate\Support\Collection;
class ToursController extends Controller
{
    //


    public function index(TranslateService $service)
{
    $menus = Menu::select('*', 'menu_items.id as Iditem')
    ->join('menu_items', 'menu_items.menu_id', '=', 'menus.id')
    ->where('menu_items.menu_id', '=', 2) // Use the actual column name here
    ->get();

    // Fetch trips with category = 1 (e.g., category for trips)
    $trips = Trip::select('*')
        ->where('category', '=', '1')
        ->limit(6)
        ->orderBy('id', 'DESC')
        ->get();

    // Fetch packages with category = 2
    $packages = Trip::select('*')
        ->where('category', '=', '2')
        ->limit(6)
        ->orderBy('id', 'DESC')
        ->get();

    // Fetch the latest blog article
    $latestArticle = Blog::orderBy('id', 'desc')->first();

    // Fetch the latest 3 blogs, excluding the latest article
    $blogs = Blog::select('*')
        ->orderBy('id', 'desc')
        ->take(3)
        ->get();
    $reviews = Review::select('*')
        ->orderBy('id', 'desc')
        ->get();

    // Get the current language from the session
    $language = Session::get('locale', 'en'); // Default to English

    // Translate the trips dynamically
    $translatedMenus = $service->translateModelsBatchCached($menus, 'title', $language);
    $translatedTrips = $service->translateModelsBatchCached($trips, 'name', $language);
    $translatedPackages = $service->translateModelsBatchCached($packages, 'name', $language);
    $translatedBlogs = $service->translateModelsBatchCached($blogs, ['title', 'content'], $language);
    $translatedReviews = $service->translateModelsBatchCached($reviews, ['title', 'content'], $language);

    // Return the view with all the translated data
    return view('index', [
        'menus' => $translatedMenus,
        'trips' => $translatedTrips,
        'packages' => $translatedPackages,
        'latestArticle' => $latestArticle,
        'blogs' => $translatedBlogs,
        'reviews' => $translatedReviews,
        'service' => $service // pass explicitly if required

    ]);
}


public function trips(TranslateService $service)
{
    $trips = Trip::where('category', 1)->orderBy('id', 'DESC')->paginate(12);

    $menus = Menu::select('*', 'menu_items.id as Iditem')
        ->join('menu_items', 'menu_items.menu_id', '=', 'menus.id')
        ->where('menu_items.menu_id', 2)
        ->get();

    $countTrips = $trips->count();
    $language   = Session::get('locale', 'en');
    $category   = Category::where('id', 1)->first();

    // Translate menus (titles)
    $translatedMenus = $service->translateModelsBatchCached($menus, ['title'], $language);

    $lang = $language;

    $translatedTripsCollection = $service->translateModelsBatchCached(
    $trips->getCollection(),
    ['title', 'content'],
    $language,
    ['format' => 'html']
);

$translatedCategory = $service->translateModelsBatchCached(
    collect([$category]),
    ['name', 'description'],
    $language,
    ['format' => 'html']
)->first();

    $translatedTrips = new LengthAwarePaginator(
        $translatedTripsCollection,
        $trips->total(),
        $trips->perPage(),
        $trips->currentPage(),
        ['path' => request()->url(), 'query' => request()->query()]
    );

    return view('trips', [
        'menus'          => $translatedMenus,
        'trips'          => $translatedTrips,
        'category'       => $category,      // ✅ pass the actual model (not an undefined var)
        'countTrips'     => $countTrips,
        'translatedDesc' => $translatedCategory,          // ✅ this exists
    ]);
}


    public function allPackages(TranslateService $service)
    {
        $packages=Trip::select('*')->where('category','=', '2')->orderby('id', 'DESC')->paginate(12);
        $menus = Menu::select('*', 'menu_items.id as Iditem')
                ->join('menu_items', 'menu_items.menu_id', '=', 'menus.id')
                ->where('menu_items.menu_id', '=', 2) // Use the actual column name here
                ->get();
        $language = Session::get('locale', 'en'); // Default to English
        $translatedMenus = $service->translateModelsBatchCached($menus, 'title', $language);
        $translatedPackages = $service->translateModelsBatchCached($packages, 'name', $language);
        return view('packages', [
            'menus' => $translatedMenus,
            'packages' => $translatedPackages,
        ]);
    }
    public function trekking(TranslateService $service)
    {
        $trekking=Trip::select('*')->where('category','=', 'Mountain Trekking')->get();
        return view('mountain-trekking', compact('trekking'));
    }
    public function desert($from, TranslateService $service)
{
    // Fetch city based on 'from'
    $city = City::where('city', '=', $from)->first();

    if (!$city) {
        abort(404);
    }

    // Fetch desert tours based on location and category
    $deserts = Trip::where('category', 2)
        ->where('city', $city->id)
        ->get();

    $countDeserts = $deserts->count();

    $menus = Menu::select('*', 'menu_items.id as Iditem')
        ->join('menu_items', 'menu_items.menu_id', '=', 'menus.id')
        ->where('menu_items.menu_id', '=', 2)
        ->get();

    $language = Session::get('locale', 'en');

    // Translate menus
    $translatedMenus = $service->translateModelsBatchCached($menus, 'title', $language);

    // Translate deserts (name and content)
    $translatedDeserts = $service->translateModelsBatchCached($deserts, ['name', 'content'], $language);

    // Translate city (city name only)
    $translatedCity = $service->translateModelsBatchCached(collect([$city]), 'city', $language)->first();
    $category= Category::select('*')->where('id', '=', 2)->first();
    $translatedCategory = $service->translateModelsBatchCached($category, ['name', 'Description'], $language);
    return view('desert-tours', [
        'menus' => $translatedMenus,
        'deserts' => $translatedDeserts,
        'city' => $translatedCity,
        'countDeserts' => $countDeserts,
        'category' =>$translatedCategory,
    ]);
}

    public function packages($from, TranslateService $service)
    {
        $city = City::select('*')->where('city', '=', $from)->first();
        // If no location is found, return a 404 error
        if (!$city) {
            abort(404);
        }
        // Fetch desert tours based on the location and category
        $packages = Trip::select('*')
            ->where('category', '=', 3)
            ->where('city', '=', $city->id)
            ->get();
        $countPackages = Trip::where('category', 3)
            ->where('city', $city->id)
            ->count();
        // If no location is found, return a 404 error
        if (!$packages) {
            abort(404);
        }
        $menus = Menu::select('*', 'menu_items.id as Iditem')
            ->join('menu_items', 'menu_items.menu_id', '=', 'menus.id')
            ->where('menu_items.menu_id', '=', 2) // Use the actual column name here
            ->get();
        $category= Category::select('*')->where('id', '=', 1)->first();
        $translatedCategoryCollection = $service->translateModelsBatchCached(collect([$category]), ['name', 'Description'], $language);
        $translatedCategory = $translatedCategoryCollection->first();
        $language = Session::get('locale', 'en'); // Default to English
        $translatedMenus = $service->translateModelsBatchCached($menus, 'title', $language);
        $translatedPackages = $service->translateModelsBatchCached($packages, ['name'], $language);
        $translatedCity = $service->translateModelsBatchCached(collect([$city]), 'city', $language)->first();

        return view('tour-packages', [
            'menus' => $translatedMenus,
            'packages' => $translatedPackages,
            'city' => $translatedCity,
            'countPackages' => $countPackages,
            'category' =>$translatedCategory,
        ]);
    }
    public function allDesert()
    {
        $deserts=Trip::select('*')->where('category','=', 'Desert Tours')->get();
        return view('desert', compact('deserts'));
    }
    public function detail($id, TranslateService $service)
{
    $detail = Trip::where('id', '=', $id)->first();
    $review = Review::where('trip', '=', $id)->orderByDesc('id')->first();
    $faqs = Faq::get();

    if (!$detail) {
        abort(404);
    }

    $trips = Trip::where('id', '!=', $id)->orderByDesc('id')->limit(5)->get();

    $menus = Menu::select('*', 'menu_items.id as Iditem')
        ->join('menu_items', 'menu_items.menu_id', '=', 'menus.id')
        ->where('menu_items.menu_id', '=', 2)
        ->get();

    $language = Session::get('locale', 'en');

    $translatedMenus = $service->translateModelsBatchCached($menus, 'title', $language);
    $translatedFaqs = $service->translateModelsBatchCached($faqs, ['title', 'content'], $language);
    $translatedTrips = $service->translateModelsBatchCached($trips, 'name', $language);
    $translatedReviewCollection = $service->translateModelsBatchCached(collect([$review]), ['title', 'comment'], $language);
    $translatedReview = $translatedReviewCollection->first();
    // Properly translate single detail model
    $translatedDetailCollection = $service->translateModelsBatchCached(collect([$detail]), ['name', 'overview', 'highlight', 'inclusive_exculsive', 'why_our_shared', 'program', 'extra_activity', 'Know_before_you_go'], $language);
    $translatedDetail = $translatedDetailCollection->first();

    return view('tour-details-m', [
        'menus' => $translatedMenus,
        'detail' => $translatedDetail,
        'trips' => $translatedTrips,
        'faqs' => $translatedFaqs,
        'review' => $translatedReview,
    ]);
}



    public function book($name)
    {
        $nameTrip = str_replace('-', ' ', $name);
        $trip=Trip::select('*')->where('name','=', $nameTrip)->first();
        return view('book', compact('trip'));
    }
}