<?php

namespace App\Http\Controllers;

use Illuminate\Http\Request;
use App\Models\Page;
use App\Models\Menu;
use App\Faq;
use App\Services\TranslateService;
use Illuminate\Support\Facades\Session;

class PagesController extends Controller
{
    //
    protected $translateService;

    public function __construct(TranslateService $translateService)
    {
        $this->translateService = $translateService;
    }
    public function index($page, TranslateService $service)
    {
        $pageT = str_replace('-', ' ', $page);
        $menus = Menu::select('*', 'menu_items.id as Iditem')
        ->join('menu_items', 'menu_items.menu_id', '=', 'menus.id')
        ->where('menu_items.menu_id', '=', 3) // Use the actual column name here
        ->get();
        $pages = Page::select('*')
        ->where('title', '=', $pageT)
        ->first();

        // Get the current language from the session
        $language = Session::get('locale', 'en'); // Default to English

         // Translate the trips dynamically
        $translatedMenus = $service->translateModelsBatchCached($menus, 'title', $language);
        if ($pages) {
            $translatedPage = $service->translateModelsBatchCached($pages, ['title', 'body'], $language);

        } else {
            $translatedPage = null; // Handle the case where no page is found
        }

        // Return the view with all the translated data
    return view('pages', [
        'menus' => $translatedMenus,
        'pages' => $translatedPage,
    ]);

    }
    public function privacy(TranslateService $service)
    {
        $privacy = Page::select('*')
        ->where('id', 3)
        ->first();
        $menus = Menu::select('*', 'menu_items.id as Iditem')
    ->join('menu_items', 'menu_items.menu_id', '=', 'menus.id')
    ->where('menu_items.menu_id', '=', 2) // Use the actual column name here
    ->get();
        $language = Session::get('locale', 'en'); // Default to English
        // Translate the trips dynamically
        $translatedMenus = $service->translateModelsBatchCached($menus, 'title', $language);
        if ($privacy) {
            $translatedPrivacy = $service->translateModelsBatchCached($privacy, ['title', 'body'], $language);
        } else {
            $translatedPrivacy = null; // or handle not found
        }
        $language = Session::get('locale', 'en'); // Default to English
        // Translate the trips dynamically

        return view('privacy-policy.index', [
            'menus' => $translatedMenus,
            'privacy' => $translatedPrivacy,
        ]);
    }
    public function faq(TranslateService $service)
    {
        $menus = Menu::select('*', 'menu_items.id as Iditem')
    ->join('menu_items', 'menu_items.menu_id', '=', 'menus.id')
    ->where('menu_items.menu_id', '=', 2) // Use the actual column name here
    ->get();
        
        
        $faqs = Faq::select('*')
        ->get();
        $language = Session::get('locale', 'en'); // Default to English
        // Translate the trips dynamically
        $translatedMenus = $service->translateModelsBatchCached($menus, 'title', $language);
        $language = Session::get('locale', 'en'); // Default to English
        // Translate the Faq dynamically
        $translatedFaqs = $service->translateModelsBatchCached($faqs,  ['title', 'content'], $language);
        return view('frequently-asked-questions.index', [
            'menus' => $translatedMenus,
            'faqs' => $translatedFaqs,
        ]);
    }
    public function terms(TranslateService $service)
    {
        $menus = Menu::select('*', 'menu_items.id as Iditem')
    ->join('menu_items', 'menu_items.menu_id', '=', 'menus.id')
    ->where('menu_items.menu_id', '=', 2) // Use the actual column name here
    ->get();
        
        
        $terms = Page::select('*')->where('id', 4)
        ->first();
        $language = Session::get('locale', 'en'); // Default to English
        // Translate the trips dynamically
        $translatedMenus = $service->translateModelsBatchCached($menus, 'title', $language);
        $language = Session::get('locale', 'en'); // Default to English
        // Translate the trips dynamically
        if ($terms) {
            $translatedMenus = $service->translateModelsBatchCached($terms, ['title', 'body'], $language);      
        } else {
            $translatedTerms = null; // or handle not found
        }
        return view('terms-conditions.index', [
            'menus' => $translatedMenus,
            'terms' => $translatedTerms,
        ]);
    }

}