<?php

namespace App\Http\Controllers;

use Illuminate\Http\Request;
use App\Newsletter;
class NewsletterController extends Controller
{
    //
    public function mail(Request $request)
    {
        $request->validate([
            'name' => 'required',
            'email' => 'required|email',
            'phone' => 'required',
            'message' => 'required',
        ]);
        $contact = new Newsletter(); //save helper result to variable, so it can be reused
        $contact->name = $request->input('name');
        $contact->phone = $request->input('phone');
        $contact->email = $request->input('email');
        $contact->description = $request->input('message');

        $contact->save();

    return redirect()->back()->with('success', 'Email sent successfully');
    }
}
