<?php

namespace App\Http\Controllers;

use Illuminate\Support\Facades\Session;
use Illuminate\Support\Facades\App;
use Illuminate\Http\RedirectResponse;

class LangController extends Controller
{
    /**
     * Change the language and store it in the session.
     *
     * @param string $lang
     * @return RedirectResponse
     */
    public function change($lang)
    {
        $availableLanguages = ['en', 'fr', 'es']; // Supported languages

        if (in_array($lang, $availableLanguages)) {
            Session::put('lang', $lang); // Store the language in the session
            App::setLocale($lang); // Optionally set the locale immediately
        }

        return redirect('/'); // Redirect back to the homepage
    }
}
