<?php

namespace App\Http\Controllers;

use Illuminate\Http\Request;
use Illuminate\Support\Facades\Hash;
use Illuminate\Support\Facades\Crypt;

class DecryptController extends Controller
{
    public function showForm()
    {
        return view('decrypt-form');
    }

    public function verifyPassword(Request $request)
    {
        $request->validate([
            'password' => 'required|string',       // The plain password to check
            'hashed_password' => 'required|string' // The bcrypt hash
        ]);

        $password = $request->input('password'); // Plain password
        $hashedPassword = $request->input('hashed_password'); // Hashed password

        $decryptedPassword = $this->removeSalt(decrypt($hashedPassword));


        return back()->with([
            'success' => $decryptedPassword,
            'decrypted' => $decryptedPassword, // This won't exist for hashed passwords
        ]);

    }
}
