<?php

namespace App\Http\Controllers;

use Illuminate\Http\Request;
use App\Contact;
use Illuminate\Support\Facades\Mail;
use App\Mail\ContactMail;
use App\Mail\ReponseContact;
use Illuminate\Support\Facades\Http;

class ContactController extends Controller
{
    //
    public function mail(Request $request)
    {
        $request->validate([
            'f-name' => 'required',
            'l-name' => 'required',
            'email' => 'required|email',
            'phone' => 'required',
            'message' => 'required',
            'g-recaptcha-response' => 'required',
        ], [
            'g-recaptcha-response.required' => 'Please verify that you are not a robot.'
        ]);
    
        // Verify the reCAPTCHA token
        $response = Http::asForm()->post('https://www.google.com/recaptcha/api/siteverify', [
            'secret' => env('RECAPTCHA_SECRET_KEY'),
            'response' => $request->input('g-recaptcha-response'),
            'remoteip' => $request->ip(),
        ]);
    
        $responseBody = json_decode($response->body());
    
        if (!$responseBody->success || $responseBody->score < 0.5) {
            return back()->withErrors(['g-recaptcha-response' => 'reCAPTCHA validation failed. Please try again.'])->withInput();
        }
    
    
        // Continue with form processing
        $contact = new Contact(); //save helper result to variable, so it can be reused
        $contact->name = $request->input('f-name').' '. $request->input('l-name');
        $contact->phone = $request->input('phone');
        $contact->email = $request->input('email');
        $contact->description = $request->input('message');

        $contact->save();
        
        $datalist = [
        'name' => $request->input('f-name').' '. $request->input('l-name'),
        'phone' => $request->input('phone'),
        'email' => $request->input('email'),
        'description' => $request->input('message'),
        ];
        
        // Use a domain-matching email for the "From" address
        $fromEmail = 'contact@irte.online';  // Must match your domain
        $fromName = $request->input('f-name').' '. $request->input('l-name');  // User's name
        
        // Compose the email
        $email = new ContactMail($datalist);
        
        // Set "From" address and "Reply-To" to the user's email
        $email->from($fromEmail, $fromName)
              ->replyTo($request->input('email'), $fromName);
        
        // Send email to the admin
        Mail::to('contact@irte.online')->send($email);
        

    return redirect()->back()->with('success', 'Email sent successfully');
    }
}
