<?php

namespace App\Http\Controllers;

use Illuminate\Http\Request;
use App\Book;
use Stevebauman\Location\Facades\Location;
use Carbon\Carbon;
use Illuminate\Support\Facades\Http;
use Illuminate\Support\Facades\Mail;
use App\Mail\BookMail;
use App\Mail\ReponseBook;

class BookController extends Controller
{
    //
    public function booking(Request $request)
    {
        $request->validate([
            'fullname' => 'required',
            'email' => 'required|email',
            'trip' => 'required',
            'tripStart' => 'required',
            'phone' => 'required',
            'g-recaptcha-response' => 'required',
        ], [
            'g-recaptcha-response.required' => 'Please verify that you are not a robot.'
        ]);
    
        // Verify the reCAPTCHA token
        $response = Http::asForm()->post('https://www.google.com/recaptcha/api/siteverify', [
            'secret' => env('RECAPTCHA_SECRET_KEY'),
            'response' => $request->input('g-recaptcha-response'),
            'remoteip' => $request->ip(),
        ]);
    
        $responseBody = json_decode($response->body());
    
        if (!$responseBody->success || $responseBody->score < 0.5) {
            return back()->withErrors(['g-recaptcha-response' => 'reCAPTCHA validation failed. Please try again.'])->withInput();
        }
        
        // Continue with form processing
        $book = new Book(); //save helper result to variable, so it can be reused
        $book->tour = $request->input('trip');
        $book->name = $request->input('fullname');
        $book->phone = $request->input('phone');
        $book->email = $request->input('email');
        $book->adults = $request->input('Adult');
        $book->childrens = $request->input('Children');
        $book->message = $request->input('message');
        $book->trip_start = Carbon::parse($request->input('tripStart'))->format('Y-m-d');
        $book->program_ai = $request->input('content');
        
        $book->save();
        

$datalist = [
    'trip' => $request->trip,
    'name' => $request->fullname,
    'phone' => $request->phone,
    'email' => $request->email,
    'description' => $request->message,
    'adults' => $request->Adult,
    'childrens' => $request->Children,
    'tripStart' => $request->tripStart,
    'tripEnd' => $request->tripEnd,
    'program_ai' => $request->content,
];

// Use a domain-matching email for the "From" address
$fromEmail = 'contact@irte.online';  // Must match your domain
$fromName = $request->fullname;  // User's full name

// Compose the email
$email = new BookMail($datalist);

// Set "From" address and "Reply-To" to the user's email
$email->from($fromEmail, $fromName)
      ->replyTo($request->email, $fromName);

// Send email to the admin
Mail::to('contact@irte.online')->send($email);



    // Redirect back with the success message
    return redirect()->back()->with('success', 'Book with success');
    }
}
