<?php

namespace App\Http\Controllers;

use Illuminate\Http\Request;
use App\Blog;
use App\Models\Menu;
use App\Services\TranslateService;
use Illuminate\Support\Facades\Session;
class BlogController extends Controller
{
    //
    protected $translateService;

    public function __construct(TranslateService $translateService)
    {
        $this->translateService = $translateService;
    }
    public function index(TranslateService $service)
    {
        $articles=Blog::select('*')->get();
        $menus = Menu::select('*', 'menu_items.id as Iditem')
        ->join('menu_items', 'menu_items.menu_id', '=', 'menus.id')
        ->where('menu_items.menu_id', '=', 3) // Use the actual column name here
        ->get();
        $countArticles = Blog::count();
        $language = Session::get('locale', 'en'); // Default to English
        $translatedMenus = $service->translateModelsBatchCached($menus, 'title', $language);
        $translatedArticle = $service->translateModelsBatchCached($articles, 'title', $language);
        // Return the view with all the translated data
        return view('blog.index', [
            'menus' => $translatedMenus,
            'articles' => $translatedArticle,
            'countArticles' => $countArticles,
        ]);
    }
    public function detail($id, TranslateService $service)
    {
        $detail=Blog::where('id','=', $id)->first();
        $latestArticles=Blog::orderBy('id', 'desc')->limit(3)->get();
        $menus = Menu::select('*', 'menu_items.id as Iditem')
        ->join('menu_items', 'menu_items.menu_id', '=', 'menus.id')
        ->where('menu_items.menu_id', '=', 3) // Use the actual column name here
        ->get();
        $language = Session::get('locale', 'en'); // Default to English
        $translatedMenus = $service->translateModelsBatchCached($menus, 'title', $language);
        $translatedLatest = $service->translateModelsBatchCached($latestArticles, 'title', $language);
        if ($detail) {
            $translatedDetail = $service->translateModelsBatchCached($detail, ['title', 'content'], $language);
        } else {
            $translatedDetail = null; // or handle not found
        }
        // Return the view with all the translated data
        return view('blog.details', [
            'menus' => $translatedMenus,
            'detail' => $translatedDetail,
            'latestArticles' => $translatedLatest,
        ]);
    }
}